/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.impl;

import ai.toloka.client.v1.SearchResult;
import ai.toloka.client.v1.impl.AbstractClientImpl;
import ai.toloka.client.v1.impl.TolokaClientFactoryImpl;
import ai.toloka.client.v1.impl.transport.MapperUtil;
import ai.toloka.client.v1.impl.transport.TransportUtil;
import ai.toloka.client.v1.impl.validation.Assertions;
import ai.toloka.client.v1.operation.Operation;
import ai.toloka.client.v1.operation.OperationClient;
import ai.toloka.client.v1.operation.OperationLogItem;
import ai.toloka.client.v1.operation.OperationSearchRequest;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import org.apache.http.HttpResponse;
import org.apache.http.client.utils.URIBuilder;

public class OperationClientImpl
extends AbstractClientImpl
implements OperationClient {
    private static final String OPERATIONS_PATH = "operations";
    private static final String LOG_PATH = "log";

    OperationClientImpl(TolokaClientFactoryImpl factory) {
        super(factory);
    }

    @Override
    public SearchResult<Operation<?, ?>> findOperations(OperationSearchRequest request) {
        SearchResult<Operation<?, ?>> result = this.find(request, OPERATIONS_PATH, new TypeReference<SearchResult<Operation>>(){});
        for (Operation operation : result.getItems()) {
            Operation.setOperationClient(operation, this);
        }
        return result;
    }

    @Override
    public <T extends Operation<?, ?>> T getOperation(final String operationId) {
        Assertions.checkArgNotNull(operationId, "Id may not be null");
        if ("PSEUDO_ID".equals(operationId)) {
            Operation pseudo = Operation.createPseudo(new Date());
            return (T)pseudo;
        }
        return (T)((Operation)new AbstractClientImpl.RequestExecutorWrapper<T>(){

            @Override
            T execute() throws URISyntaxException, IOException {
                URI uri = OperationClientImpl.this.addVersionPrefix(new URIBuilder(OperationClientImpl.this.getTolokaApiUrl()), OperationClientImpl.OPERATIONS_PATH, operationId).build();
                HttpResponse response = TransportUtil.executeGet(OperationClientImpl.this.getHttpClient(), uri, OperationClientImpl.this.getHttpConsumer());
                if (response.getStatusLine().getStatusCode() == 200) {
                    Operation result = (Operation)MapperUtil.getObjectReader(Operation.class).readValue(response.getEntity().getContent());
                    Operation.setOperationClient(result, OperationClientImpl.this);
                    return result;
                }
                if (response.getStatusLine().getStatusCode() == 404) {
                    return null;
                }
                throw OperationClientImpl.this.parseException(response);
            }
        }.wrap());
    }

    @Override
    public <T extends Operation<?, ?>> T getOperation(String operationId, Class<T> c) {
        Assertions.checkArgNotNull(c, "Requested class may not be null");
        T operation = this.getOperation(operationId);
        if (operation == null) {
            return null;
        }
        if (!operation.getClass().equals(c)) {
            throw new IllegalArgumentException("Requested class and actual operation type doesn't match");
        }
        return operation;
    }

    @Override
    public Iterator<OperationLogItem> getOperationLog(final String operationId) {
        Assertions.checkArgNotNull(operationId, "Id may not be null");
        if ("PSEUDO_ID".equals(operationId)) {
            return Collections.emptyIterator();
        }
        return (Iterator)new AbstractClientImpl.RequestExecutorWrapper<Iterator<OperationLogItem>>(){

            @Override
            Iterator<OperationLogItem> execute() throws URISyntaxException, IOException {
                URI uri = OperationClientImpl.this.addVersionPrefix(new URIBuilder(OperationClientImpl.this.getTolokaApiUrl()), OperationClientImpl.OPERATIONS_PATH, operationId, OperationClientImpl.LOG_PATH).build();
                HttpResponse response = TransportUtil.executeGet(OperationClientImpl.this.getHttpClient(), uri, OperationClientImpl.this.getHttpConsumer());
                if (response.getStatusLine().getStatusCode() == 200) {
                    JsonParser parser = MapperUtil.getObjectReader().getFactory().createParser(response.getEntity().getContent());
                    parser.nextToken();
                    JsonToken firstArrayToken = parser.nextToken();
                    if (firstArrayToken == JsonToken.END_ARRAY) {
                        return Collections.emptyIterator();
                    }
                    return parser.readValuesAs(OperationLogItem.class);
                }
                if (response.getStatusLine().getStatusCode() == 404) {
                    return null;
                }
                throw OperationClientImpl.this.parseException(response);
            }
        }.wrap();
    }
}

