/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.impl;

import ai.toloka.client.v1.ModificationResult;
import ai.toloka.client.v1.SearchResult;
import ai.toloka.client.v1.impl.AbstractClientImpl;
import ai.toloka.client.v1.impl.TolokaClientFactoryImpl;
import ai.toloka.client.v1.impl.validation.Assertions;
import ai.toloka.client.v1.operation.Operation;
import ai.toloka.client.v1.pool.Pool;
import ai.toloka.client.v1.pool.PoolArchiveOperation;
import ai.toloka.client.v1.pool.PoolClient;
import ai.toloka.client.v1.pool.PoolCloneOperation;
import ai.toloka.client.v1.pool.PoolCloseOperation;
import ai.toloka.client.v1.pool.PoolOpenOperation;
import ai.toloka.client.v1.pool.PoolPatchRequest;
import ai.toloka.client.v1.pool.PoolSearchRequest;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Date;

public class PoolClientImpl
extends AbstractClientImpl
implements PoolClient {
    private static final String POOLS_PATH = "pools";
    private static final String POOLS_OPEN_ACTION_PATH = "open";
    private static final String POOLS_CLOSE_ACTION_PATH = "close";
    private static final String POOLS_CLOSE_FOR_UPDATE_ACTION_PATH = "close-for-update";
    private static final String POOLS_ARCHIVE_ACTION_PATH = "archive";
    private static final String POOLS_CLONE_ACTION_PATH = "clone";

    PoolClientImpl(TolokaClientFactoryImpl factory) {
        super(factory);
    }

    @Override
    public SearchResult<Pool> findPools(PoolSearchRequest request) {
        return this.find(request, POOLS_PATH, new TypeReference<SearchResult<Pool>>(){});
    }

    @Override
    public Pool getPool(String id) {
        return this.get(id, POOLS_PATH, Pool.class);
    }

    @Override
    public ModificationResult<Pool> createPool(Pool pool) {
        Assertions.checkArgNotNull(pool, "Pool may not be null");
        return this.create(pool, POOLS_PATH, Pool.class, null);
    }

    @Override
    public ModificationResult<Pool> updatePool(String poolId, Pool pool) {
        Assertions.checkArgNotNull(poolId, "Pool id may not be null");
        Assertions.checkArgNotNull(pool, "Pool form may not be null");
        return this.update(poolId, pool, POOLS_PATH, Pool.class);
    }

    @Override
    public ModificationResult<Pool> patchPool(String poolId, PoolPatchRequest request) {
        Assertions.checkArgNotNull(poolId, "Id may not be null");
        Assertions.checkArgNotNull(request, "Patch request may not be null");
        return this.patch(poolId, request, POOLS_PATH, Pool.class, null);
    }

    @Override
    public PoolOpenOperation openPool(String poolId) {
        Assertions.checkArgNotNull(poolId, "Id may not be null");
        PoolOpenOperation operation = (PoolOpenOperation)this.executeAction(poolId, POOLS_PATH, POOLS_OPEN_ACTION_PATH, Operation.class);
        if (operation == null) {
            return PoolOpenOperation.createPseudo(new Date());
        }
        return operation;
    }

    @Override
    public PoolCloseOperation closePool(String poolId) {
        Assertions.checkArgNotNull(poolId, "Id may not be null");
        PoolCloseOperation operation = (PoolCloseOperation)this.executeAction(poolId, POOLS_PATH, POOLS_CLOSE_ACTION_PATH, Operation.class);
        if (operation == null) {
            return PoolCloseOperation.createPseudo(new Date());
        }
        return operation;
    }

    @Override
    public PoolCloseOperation closePoolForUpdate(String poolId) {
        Assertions.checkArgNotNull(poolId, "Id may not be null");
        PoolCloseOperation operation = (PoolCloseOperation)this.executeAction(poolId, POOLS_PATH, POOLS_CLOSE_FOR_UPDATE_ACTION_PATH, Operation.class);
        if (operation == null) {
            return PoolCloseOperation.createPseudo(new Date());
        }
        return operation;
    }

    @Override
    public PoolArchiveOperation archivePool(String poolId) {
        Assertions.checkArgNotNull(poolId, "Id may not be null");
        PoolArchiveOperation operation = (PoolArchiveOperation)this.executeAction(poolId, POOLS_PATH, POOLS_ARCHIVE_ACTION_PATH, Operation.class);
        if (operation == null) {
            return PoolArchiveOperation.createPseudo(new Date());
        }
        return operation;
    }

    @Override
    public PoolCloneOperation clonePool(String poolId) {
        Assertions.checkArgNotNull(poolId, "Id may not be null");
        PoolCloneOperation operation = (PoolCloneOperation)this.executeAction(poolId, POOLS_PATH, POOLS_CLONE_ACTION_PATH, Operation.class);
        if (operation == null) {
            return PoolCloneOperation.createPseudo(new Date());
        }
        return operation;
    }
}

