/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.impl;

import ai.toloka.client.v1.ModificationResult;
import ai.toloka.client.v1.SearchResult;
import ai.toloka.client.v1.impl.AbstractClientImpl;
import ai.toloka.client.v1.impl.TolokaClientFactoryImpl;
import ai.toloka.client.v1.impl.validation.Assertions;
import ai.toloka.client.v1.operation.Operation;
import ai.toloka.client.v1.project.Project;
import ai.toloka.client.v1.project.ProjectArchiveOperation;
import ai.toloka.client.v1.project.ProjectClient;
import ai.toloka.client.v1.project.ProjectSearchRequest;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Date;

public class ProjectClientImpl
extends AbstractClientImpl
implements ProjectClient {
    private static final String PROJECTS_PATH = "projects";
    private static final String ARCHIVE_ACTION_PATH = "archive";

    ProjectClientImpl(TolokaClientFactoryImpl factory) {
        super(factory);
    }

    @Override
    public SearchResult<Project> findProjects(ProjectSearchRequest request) {
        return this.find(request, PROJECTS_PATH, new TypeReference<SearchResult<Project>>(){});
    }

    @Override
    public Project getProject(String projectId) {
        return this.get(projectId, PROJECTS_PATH, Project.class);
    }

    @Override
    public ModificationResult<Project> createProject(Project project) {
        Assertions.checkArgNotNull(project, "Project may not be null");
        return this.create(project, PROJECTS_PATH, Project.class, null);
    }

    @Override
    public ModificationResult<Project> updateProject(String projectId, Project project) {
        Assertions.checkArgNotNull(projectId, "Project id may not be null");
        Assertions.checkArgNotNull(project, "Project may not be null");
        return this.update(projectId, project, PROJECTS_PATH, Project.class);
    }

    @Override
    public ProjectArchiveOperation archiveProject(String projectId) {
        Assertions.checkArgNotNull(projectId, "Id may not be null");
        ProjectArchiveOperation operation = (ProjectArchiveOperation)this.executeAction(projectId, PROJECTS_PATH, ARCHIVE_ACTION_PATH, Operation.class);
        if (operation == null) {
            return ProjectArchiveOperation.createPseudo(new Date());
        }
        return operation;
    }
}

