/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.impl;

import ai.toloka.client.v1.ModificationResult;
import ai.toloka.client.v1.SearchResult;
import ai.toloka.client.v1.impl.AbstractClientImpl;
import ai.toloka.client.v1.impl.TolokaClientFactoryImpl;
import ai.toloka.client.v1.impl.transport.MapperUtil;
import ai.toloka.client.v1.impl.transport.TransportUtil;
import ai.toloka.client.v1.impl.validation.Assertions;
import ai.toloka.client.v1.skill.Skill;
import ai.toloka.client.v1.skill.SkillClient;
import ai.toloka.client.v1.skill.SkillSearchRequest;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpResponse;
import org.apache.http.client.utils.URIBuilder;

public class SkillClientImpl
extends AbstractClientImpl
implements SkillClient {
    private static final String SKILLS_PATH = "skills";

    SkillClientImpl(TolokaClientFactoryImpl factory) {
        super(factory);
    }

    @Override
    public SearchResult<Skill> findSkills(SkillSearchRequest request) {
        return this.find(request, SKILLS_PATH, new TypeReference<SearchResult<Skill>>(){});
    }

    @Override
    public Skill getSkill(String skillId) {
        return this.get(skillId, SKILLS_PATH, Skill.class);
    }

    @Override
    public ModificationResult<Skill> createSkill(Skill skill) {
        Assertions.checkArgNotNull(skill, "Skill may not be null");
        return this.create(skill, SKILLS_PATH, Skill.class, null);
    }

    @Override
    public ModificationResult<Skill> updateSkill(final String skillId, final Skill skill) {
        Assertions.checkArgNotNull(skillId, "Skill id may not be null");
        Assertions.checkArgNotNull(skill, "Skill may not be null");
        return (ModificationResult)new AbstractClientImpl.RequestExecutorWrapper<ModificationResult<Skill>>(){

            @Override
            ModificationResult<Skill> execute() throws URISyntaxException, IOException {
                URI uri = SkillClientImpl.this.addVersionPrefix(new URIBuilder(SkillClientImpl.this.getTolokaApiUrl()), SkillClientImpl.SKILLS_PATH, skillId).build();
                HttpResponse response = TransportUtil.executePut(SkillClientImpl.this.getHttpClient(), uri, SkillClientImpl.this.getHttpConsumer(), skill);
                if (response.getStatusLine().getStatusCode() == 200) {
                    return new ModificationResult<Skill>((Skill)MapperUtil.getObjectReader(Skill.class).readValue(response.getEntity().getContent()), false);
                }
                throw SkillClientImpl.this.parseException(response);
            }
        }.wrap();
    }
}

