/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.impl;

import ai.toloka.client.v1.BatchCreateResult;
import ai.toloka.client.v1.ModificationResult;
import ai.toloka.client.v1.SearchResult;
import ai.toloka.client.v1.impl.AbstractClientImpl;
import ai.toloka.client.v1.impl.TolokaClientFactoryImpl;
import ai.toloka.client.v1.impl.transport.MapperUtil;
import ai.toloka.client.v1.impl.transport.TransportUtil;
import ai.toloka.client.v1.impl.validation.Assertions;
import ai.toloka.client.v1.operation.Operation;
import ai.toloka.client.v1.task.Task;
import ai.toloka.client.v1.task.TaskClient;
import ai.toloka.client.v1.task.TaskCreateBatchOperation;
import ai.toloka.client.v1.task.TaskCreateRequestParameters;
import ai.toloka.client.v1.task.TaskOverlapPatch;
import ai.toloka.client.v1.task.TaskPatch;
import ai.toloka.client.v1.task.TaskPatchRequestParameters;
import ai.toloka.client.v1.task.TaskSearchRequest;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.utils.URIBuilder;

public class TaskClientImpl
extends AbstractClientImpl
implements TaskClient {
    private static final String TASKS_PATH = "tasks";
    private static final String SET_OVERLAP_OR_MIN_PATH = "set-overlap-or-min";

    TaskClientImpl(TolokaClientFactoryImpl factory) {
        super(factory);
    }

    @Override
    public ModificationResult<Task> createTask(Task task) {
        return this.createTask(task, null);
    }

    @Override
    public ModificationResult<Task> createTask(Task task, TaskCreateRequestParameters parameters) {
        Assertions.checkArgNotNull(task, "Task may not be null");
        return this.create(task, TASKS_PATH, Task.class, parameters != null ? parameters.getQueryParameters() : null);
    }

    @Override
    public BatchCreateResult<Task> createTasks(List<Task> tasks) {
        return this.createTasks(tasks, null);
    }

    @Override
    public BatchCreateResult<Task> createTasks(List<Task> tasks, TaskCreateRequestParameters parameters) {
        Assertions.checkArgNotNull(tasks, "Tasks may not be null");
        return this.createMultiple(tasks, TASKS_PATH, new TypeReference<BatchCreateResult<Task>>(){}, parameters);
    }

    @Override
    public TaskCreateBatchOperation createTasksAsync(Iterator<Task> tasks) {
        return this.createTasksAsync(tasks, null);
    }

    @Override
    public TaskCreateBatchOperation createTasksAsync(Iterator<Task> tasks, TaskCreateRequestParameters parameters) {
        return (TaskCreateBatchOperation)this.createMultipleAsync(tasks, TASKS_PATH, Operation.class, parameters);
    }

    @Override
    public SearchResult<Task> findTasks(TaskSearchRequest request) {
        return this.find(request, TASKS_PATH, new TypeReference<SearchResult<Task>>(){});
    }

    @Override
    public Task getTask(String taskId) {
        return this.get(taskId, TASKS_PATH, Task.class);
    }

    @Override
    public ModificationResult<Task> patchTask(String taskId, TaskPatch patch) {
        return this.patchTask(taskId, patch, null);
    }

    @Override
    public ModificationResult<Task> patchTask(String taskId, TaskPatch patch, TaskPatchRequestParameters parameters) {
        return this.patch(taskId, patch, TASKS_PATH, Task.class, parameters != null ? parameters.getQueryParameters() : null);
    }

    @Override
    public ModificationResult<Task> setOverlapOrMin(final String taskId, final TaskOverlapPatch overlapPatch) {
        Assertions.checkArgNotNull(taskId, "Id may not be null");
        Assertions.checkArgNotNull(overlapPatch, "Patch form may not be null");
        return (ModificationResult)new AbstractClientImpl.RequestExecutorWrapper<ModificationResult<Task>>(){

            @Override
            ModificationResult<Task> execute() throws URISyntaxException, IOException {
                URIBuilder uriBuilder = TaskClientImpl.this.addVersionPrefix(new URIBuilder(TaskClientImpl.this.getTolokaApiUrl()), TaskClientImpl.TASKS_PATH, taskId, TaskClientImpl.SET_OVERLAP_OR_MIN_PATH);
                HttpResponse response = TransportUtil.executePatch(TaskClientImpl.this.getHttpClient(), uriBuilder.build(), TaskClientImpl.this.getHttpConsumer(), overlapPatch);
                if (response.getStatusLine().getStatusCode() == 200) {
                    ModificationResult<Task> result = new ModificationResult<Task>((Task)MapperUtil.getObjectReader(Task.class).readValue(response.getEntity().getContent()), false);
                    return result;
                }
                throw TaskClientImpl.this.parseException(response);
            }
        }.wrap();
    }
}

