/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.impl;

import ai.toloka.client.v1.BatchCreateResult;
import ai.toloka.client.v1.ModificationResult;
import ai.toloka.client.v1.SearchResult;
import ai.toloka.client.v1.impl.AbstractClientImpl;
import ai.toloka.client.v1.impl.TolokaClientFactoryImpl;
import ai.toloka.client.v1.impl.transport.MapperUtil;
import ai.toloka.client.v1.impl.transport.TransportUtil;
import ai.toloka.client.v1.impl.validation.Assertions;
import ai.toloka.client.v1.operation.Operation;
import ai.toloka.client.v1.tasksuite.TaskSuite;
import ai.toloka.client.v1.tasksuite.TaskSuiteClient;
import ai.toloka.client.v1.tasksuite.TaskSuiteCreateBatchOperation;
import ai.toloka.client.v1.tasksuite.TaskSuiteCreateRequestParameters;
import ai.toloka.client.v1.tasksuite.TaskSuiteOverlapPatch;
import ai.toloka.client.v1.tasksuite.TaskSuitePatch;
import ai.toloka.client.v1.tasksuite.TaskSuitePatchRequestParameters;
import ai.toloka.client.v1.tasksuite.TaskSuiteSearchRequest;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.utils.URIBuilder;

public class TaskSuiteClientImpl
extends AbstractClientImpl
implements TaskSuiteClient {
    private static final String TASK_SUITES_PATH = "task-suites";
    private static final String SET_OVERLAP_OR_MIN_PATH = "set-overlap-or-min";

    TaskSuiteClientImpl(TolokaClientFactoryImpl factory) {
        super(factory);
    }

    @Override
    public ModificationResult<TaskSuite> createTaskSuite(TaskSuite taskSuite) {
        return this.createTaskSuite(taskSuite, null);
    }

    @Override
    public ModificationResult<TaskSuite> createTaskSuite(TaskSuite taskSuite, TaskSuiteCreateRequestParameters parameters) {
        Assertions.checkArgNotNull(taskSuite, "Task suite may not be null");
        return this.create(taskSuite, TASK_SUITES_PATH, TaskSuite.class, parameters != null ? parameters.getQueryParameters() : null);
    }

    @Override
    public BatchCreateResult<TaskSuite> createTaskSuites(List<TaskSuite> taskSuites) {
        return this.createTaskSuites(taskSuites, null);
    }

    @Override
    public BatchCreateResult<TaskSuite> createTaskSuites(List<TaskSuite> taskSuites, TaskSuiteCreateRequestParameters parameters) {
        Assertions.checkArgNotNull(taskSuites, "Task suites may not be null");
        return this.createMultiple(taskSuites, TASK_SUITES_PATH, new TypeReference<BatchCreateResult<TaskSuite>>(){}, parameters);
    }

    @Override
    public TaskSuiteCreateBatchOperation createTaskSuitesAsync(Iterator<TaskSuite> taskSuites) {
        return this.createTaskSuitesAsync(taskSuites, null);
    }

    @Override
    public TaskSuiteCreateBatchOperation createTaskSuitesAsync(Iterator<TaskSuite> taskSuites, TaskSuiteCreateRequestParameters parameters) {
        Assertions.checkArgNotNull(taskSuites, "Task suites may not be null");
        return (TaskSuiteCreateBatchOperation)this.createMultipleAsync(taskSuites, TASK_SUITES_PATH, Operation.class, parameters);
    }

    @Override
    public SearchResult<TaskSuite> findTaskSuites(TaskSuiteSearchRequest request) {
        return this.find(request, TASK_SUITES_PATH, new TypeReference<SearchResult<TaskSuite>>(){});
    }

    @Override
    public TaskSuite getTaskSuite(String taskSuiteId) {
        Assertions.checkArgNotNull(taskSuiteId, "Id may not be null");
        return this.get(taskSuiteId, TASK_SUITES_PATH, TaskSuite.class);
    }

    @Override
    public ModificationResult<TaskSuite> patchTaskSuite(String taskSuiteId, TaskSuitePatch patch) {
        return this.patchTaskSuite(taskSuiteId, patch, null);
    }

    @Override
    public ModificationResult<TaskSuite> patchTaskSuite(String taskSuiteId, TaskSuitePatch patch, TaskSuitePatchRequestParameters parameters) {
        Assertions.checkArgNotNull(taskSuiteId, "Id may not be null");
        Assertions.checkArgNotNull(patch, "Patch form may not be null");
        return this.patch(taskSuiteId, patch, TASK_SUITES_PATH, TaskSuite.class, parameters != null ? parameters.getQueryParameters() : null);
    }

    @Override
    public ModificationResult<TaskSuite> setOverlapOrMin(final String taskSuiteId, final TaskSuiteOverlapPatch overlapPatch) {
        Assertions.checkArgNotNull(taskSuiteId, "Id may not be null");
        Assertions.checkArgNotNull(overlapPatch, "Overlap patch form may not be null");
        return (ModificationResult)new AbstractClientImpl.RequestExecutorWrapper<ModificationResult<TaskSuite>>(){

            @Override
            ModificationResult<TaskSuite> execute() throws URISyntaxException, IOException {
                URIBuilder uriBuilder = TaskSuiteClientImpl.this.addVersionPrefix(new URIBuilder(TaskSuiteClientImpl.this.getTolokaApiUrl()), TaskSuiteClientImpl.TASK_SUITES_PATH, taskSuiteId, TaskSuiteClientImpl.SET_OVERLAP_OR_MIN_PATH);
                HttpResponse response = TransportUtil.executePatch(TaskSuiteClientImpl.this.getHttpClient(), uriBuilder.build(), TaskSuiteClientImpl.this.getHttpConsumer(), overlapPatch);
                if (response.getStatusLine().getStatusCode() == 200) {
                    ModificationResult<TaskSuite> result = new ModificationResult<TaskSuite>((TaskSuite)MapperUtil.getObjectReader(TaskSuite.class).readValue(response.getEntity().getContent()), false);
                    return result;
                }
                throw TaskSuiteClientImpl.this.parseException(response);
            }
        }.wrap();
    }
}

