/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.impl;

import ai.toloka.client.v1.TolokaClientFactory;
import ai.toloka.client.v1.aggregatedsolutions.AggregatedSolutionClient;
import ai.toloka.client.v1.assignment.AssignmentClient;
import ai.toloka.client.v1.attachment.AttachmentClient;
import ai.toloka.client.v1.impl.AggregatedSolutionClientImpl;
import ai.toloka.client.v1.impl.AssignmentClientImpl;
import ai.toloka.client.v1.impl.AttachmentClientImpl;
import ai.toloka.client.v1.impl.MessageThreadClientImpl;
import ai.toloka.client.v1.impl.OperationClientImpl;
import ai.toloka.client.v1.impl.PoolClientImpl;
import ai.toloka.client.v1.impl.ProjectClientImpl;
import ai.toloka.client.v1.impl.RequesterClientImpl;
import ai.toloka.client.v1.impl.SkillClientImpl;
import ai.toloka.client.v1.impl.TaskClientImpl;
import ai.toloka.client.v1.impl.TaskSuiteClientImpl;
import ai.toloka.client.v1.impl.TrainingClientImpl;
import ai.toloka.client.v1.impl.UserBonusClientImpl;
import ai.toloka.client.v1.impl.UserRestrictionClientImpl;
import ai.toloka.client.v1.impl.UserSkillClientImpl;
import ai.toloka.client.v1.impl.WebhookSubscriptionClientImpl;
import ai.toloka.client.v1.impl.transport.DefaultHttpClientConfiguration;
import ai.toloka.client.v1.impl.validation.Assertions;
import ai.toloka.client.v1.messagethread.MessageThreadClient;
import ai.toloka.client.v1.operation.OperationClient;
import ai.toloka.client.v1.pool.PoolClient;
import ai.toloka.client.v1.project.ProjectClient;
import ai.toloka.client.v1.requester.RequesterClient;
import ai.toloka.client.v1.skill.SkillClient;
import ai.toloka.client.v1.task.TaskClient;
import ai.toloka.client.v1.tasksuite.TaskSuiteClient;
import ai.toloka.client.v1.training.TrainingClient;
import ai.toloka.client.v1.userbonus.UserBonusClient;
import ai.toloka.client.v1.userrestriction.UserRestrictionClient;
import ai.toloka.client.v1.userskill.UserSkillClient;
import ai.toloka.client.v1.webhooksubscription.WebhookSubscriptionClient;
import java.net.URI;
import java.util.function.Consumer;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;

public class TolokaClientFactoryImpl
implements TolokaClientFactory {
    private final HttpClient httpClient;
    private final URI tolokaApiUrl;
    private Consumer<HttpRequestBase> headersSupplier;
    private RequesterClient requesterClient;
    private ProjectClient projectClient;
    private PoolClient poolClient;
    private TrainingClient trainingClient;
    private TaskClient taskClient;
    private TaskSuiteClient taskSuiteClient;
    private AssignmentClient assignmentClient;
    private AggregatedSolutionClient aggregatedSolutionClient;
    private UserSkillClient userSkillClient;
    private UserRestrictionClient userRestrictionClient;
    private AttachmentClient attachmentClient;
    private OperationClient operationClient;
    private SkillClient skillClient;
    private UserBonusClient userBonusClient;
    private MessageThreadClient messageThreadClient;
    private WebhookSubscriptionClient webhookSubscriptionClient;

    public TolokaClientFactoryImpl(String oauthToken) {
        Assertions.checkArgNotNull(oauthToken, "OAuth token may not be null");
        this.tolokaApiUrl = DefaultHttpClientConfiguration.DEFAULT_TOLOKA_SANDBOX_URI;
        this.httpClient = DefaultHttpClientConfiguration.buildDefaultClient(oauthToken);
    }

    public TolokaClientFactoryImpl(URI tolokaApiUrl, String oauthToken) {
        Assertions.checkArgNotNull(tolokaApiUrl, "Toloka API URL may not be null");
        Assertions.checkArgNotNull(oauthToken, "OAuth token may not be null");
        this.tolokaApiUrl = tolokaApiUrl;
        this.httpClient = DefaultHttpClientConfiguration.buildDefaultClient(oauthToken);
    }

    public TolokaClientFactoryImpl(String tolokaApiUrl, String oauthToken) {
        Assertions.checkArgNotNull(tolokaApiUrl, "Toloka API URL may not be null");
        Assertions.checkArgNotNull(oauthToken, "OAuth token may not be null");
        this.tolokaApiUrl = URI.create(tolokaApiUrl);
        this.httpClient = DefaultHttpClientConfiguration.buildDefaultClient(oauthToken);
    }

    public TolokaClientFactoryImpl(URI tolokaApiUrl, HttpClient httpClient) {
        Assertions.checkArgNotNull(tolokaApiUrl, "Toloka API URL may not be null");
        Assertions.checkArgNotNull(httpClient, "Http Client may not be null");
        this.tolokaApiUrl = tolokaApiUrl;
        this.httpClient = httpClient;
    }

    public TolokaClientFactoryImpl(String tolokaApiUrl, HttpClient httpClient) {
        Assertions.checkArgNotNull(tolokaApiUrl, "Toloka API URL may not be null");
        Assertions.checkArgNotNull(httpClient, "Http Client may not be null");
        this.tolokaApiUrl = URI.create(tolokaApiUrl);
        this.httpClient = httpClient;
    }

    @Override
    public RequesterClient getRequesterClient() {
        if (this.requesterClient == null) {
            this.requesterClient = new RequesterClientImpl(this);
        }
        return this.requesterClient;
    }

    @Override
    public ProjectClient getProjectClient() {
        if (this.projectClient == null) {
            this.projectClient = new ProjectClientImpl(this);
        }
        return this.projectClient;
    }

    @Override
    public PoolClient getPoolClient() {
        if (this.poolClient == null) {
            this.poolClient = new PoolClientImpl(this);
        }
        return this.poolClient;
    }

    @Override
    public TrainingClient getTrainingClient() {
        if (this.trainingClient == null) {
            this.trainingClient = new TrainingClientImpl(this);
        }
        return this.trainingClient;
    }

    @Override
    public TaskClient getTaskClient() {
        if (this.taskClient == null) {
            this.taskClient = new TaskClientImpl(this);
        }
        return this.taskClient;
    }

    @Override
    public TaskSuiteClient getTaskSuiteClient() {
        if (this.taskSuiteClient == null) {
            this.taskSuiteClient = new TaskSuiteClientImpl(this);
        }
        return this.taskSuiteClient;
    }

    @Override
    public AssignmentClient getAssignmentClient() {
        if (this.assignmentClient == null) {
            this.assignmentClient = new AssignmentClientImpl(this);
        }
        return this.assignmentClient;
    }

    @Override
    public AggregatedSolutionClient getAggregatedSolutionClient() {
        if (this.aggregatedSolutionClient == null) {
            this.aggregatedSolutionClient = new AggregatedSolutionClientImpl(this);
        }
        return this.aggregatedSolutionClient;
    }

    @Override
    public UserSkillClient getUserSkillClient() {
        if (this.userSkillClient == null) {
            this.userSkillClient = new UserSkillClientImpl(this);
        }
        return this.userSkillClient;
    }

    @Override
    public UserRestrictionClient getUserRestrictionClient() {
        if (this.userRestrictionClient == null) {
            this.userRestrictionClient = new UserRestrictionClientImpl(this);
        }
        return this.userRestrictionClient;
    }

    @Override
    public AttachmentClient getAttachmentClient() {
        if (this.attachmentClient == null) {
            this.attachmentClient = new AttachmentClientImpl(this);
        }
        return this.attachmentClient;
    }

    @Override
    public OperationClient getOperationClient() {
        if (this.operationClient == null) {
            this.operationClient = new OperationClientImpl(this);
        }
        return this.operationClient;
    }

    @Override
    public SkillClient getSkillClient() {
        if (this.skillClient == null) {
            this.skillClient = new SkillClientImpl(this);
        }
        return this.skillClient;
    }

    @Override
    public UserBonusClient getUserBonusClient() {
        if (this.userBonusClient == null) {
            this.userBonusClient = new UserBonusClientImpl(this);
        }
        return this.userBonusClient;
    }

    @Override
    public MessageThreadClient getMessageThreadClient() {
        if (this.messageThreadClient == null) {
            this.messageThreadClient = new MessageThreadClientImpl(this);
        }
        return this.messageThreadClient;
    }

    @Override
    public WebhookSubscriptionClient getWebhookSubscriptionClient() {
        if (this.webhookSubscriptionClient == null) {
            this.webhookSubscriptionClient = new WebhookSubscriptionClientImpl(this);
        }
        return this.webhookSubscriptionClient;
    }

    public URI getTolokaApiUrl() {
        return this.tolokaApiUrl;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public Consumer<HttpRequestBase> getHeadersSupplier() {
        return this.headersSupplier;
    }

    public TolokaClientFactoryImpl tune(Consumer<HttpRequestBase> httpConsumer) {
        this.headersSupplier = httpConsumer;
        return this;
    }
}

