/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.impl;

import ai.toloka.client.v1.ModificationResult;
import ai.toloka.client.v1.SearchResult;
import ai.toloka.client.v1.impl.AbstractClientImpl;
import ai.toloka.client.v1.impl.TolokaClientFactoryImpl;
import ai.toloka.client.v1.impl.validation.Assertions;
import ai.toloka.client.v1.operation.Operation;
import ai.toloka.client.v1.training.Training;
import ai.toloka.client.v1.training.TrainingArchiveOperation;
import ai.toloka.client.v1.training.TrainingClient;
import ai.toloka.client.v1.training.TrainingCloneOperation;
import ai.toloka.client.v1.training.TrainingCloseOperation;
import ai.toloka.client.v1.training.TrainingOpenOperation;
import ai.toloka.client.v1.training.TrainingSearchRequest;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Date;

public class TrainingClientImpl
extends AbstractClientImpl
implements TrainingClient {
    private static final String TRAININGS_PATH = "trainings";
    private static final String TRAININGS_OPEN_ACTION_PATH = "open";
    private static final String TRAININGS_CLOSE_ACTION_PATH = "close";
    private static final String TRAININGS_ARCHIVE_ACTION_PATH = "archive";
    private static final String TRAININGS_CLONE_ACTION_PATH = "clone";

    TrainingClientImpl(TolokaClientFactoryImpl factory) {
        super(factory);
    }

    @Override
    public SearchResult<Training> findTrainings(TrainingSearchRequest request) {
        return this.find(request, TRAININGS_PATH, new TypeReference<SearchResult<Training>>(){});
    }

    @Override
    public Training getTraining(String id) {
        return this.get(id, TRAININGS_PATH, Training.class);
    }

    @Override
    public ModificationResult<Training> createTraining(Training training) {
        Assertions.checkArgNotNull(training, "Training may not be null");
        return this.create(training, TRAININGS_PATH, Training.class, null);
    }

    @Override
    public ModificationResult<Training> updateTraining(String trainingId, Training training) {
        Assertions.checkArgNotNull(trainingId, "Training id may not be null");
        Assertions.checkArgNotNull(training, "Training form may not be null");
        return this.update(trainingId, training, TRAININGS_PATH, Training.class);
    }

    @Override
    public TrainingOpenOperation openTraining(String trainingId) {
        Assertions.checkArgNotNull(trainingId, "Id may not be null");
        TrainingOpenOperation operation = (TrainingOpenOperation)this.executeAction(trainingId, TRAININGS_PATH, TRAININGS_OPEN_ACTION_PATH, Operation.class);
        if (operation == null) {
            return TrainingOpenOperation.createPseudo(new Date());
        }
        return operation;
    }

    @Override
    public TrainingCloseOperation closeTraining(String trainingId) {
        Assertions.checkArgNotNull(trainingId, "Id may not be null");
        TrainingCloseOperation operation = (TrainingCloseOperation)this.executeAction(trainingId, TRAININGS_PATH, TRAININGS_CLOSE_ACTION_PATH, Operation.class);
        if (operation == null) {
            return TrainingCloseOperation.createPseudo(new Date());
        }
        return operation;
    }

    @Override
    public TrainingArchiveOperation archiveTraining(String trainingId) {
        Assertions.checkArgNotNull(trainingId, "Id may not be null");
        TrainingArchiveOperation operation = (TrainingArchiveOperation)this.executeAction(trainingId, TRAININGS_PATH, TRAININGS_ARCHIVE_ACTION_PATH, Operation.class);
        if (operation == null) {
            return TrainingArchiveOperation.createPseudo(new Date());
        }
        return operation;
    }

    @Override
    public TrainingCloneOperation cloneTraining(String trainingId) {
        Assertions.checkArgNotNull(trainingId, "Id may not be null");
        TrainingCloneOperation operation = (TrainingCloneOperation)this.executeAction(trainingId, TRAININGS_PATH, TRAININGS_CLONE_ACTION_PATH, Operation.class);
        if (operation == null) {
            return TrainingCloneOperation.createPseudo(new Date());
        }
        return operation;
    }
}

