/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.impl;

import ai.toloka.client.v1.BatchCreateResult;
import ai.toloka.client.v1.ModificationResult;
import ai.toloka.client.v1.SearchResult;
import ai.toloka.client.v1.impl.AbstractClientImpl;
import ai.toloka.client.v1.impl.TolokaClientFactoryImpl;
import ai.toloka.client.v1.impl.validation.Assertions;
import ai.toloka.client.v1.operation.Operation;
import ai.toloka.client.v1.userbonus.UserBonus;
import ai.toloka.client.v1.userbonus.UserBonusClient;
import ai.toloka.client.v1.userbonus.UserBonusCreateBatchOperation;
import ai.toloka.client.v1.userbonus.UserBonusCreateRequestParameters;
import ai.toloka.client.v1.userbonus.UserBonusSearchRequest;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Iterator;
import java.util.List;

public class UserBonusClientImpl
extends AbstractClientImpl
implements UserBonusClient {
    private static final String USER_BONUSES_PATH = "user-bonuses";

    UserBonusClientImpl(TolokaClientFactoryImpl factory) {
        super(factory);
    }

    @Override
    public ModificationResult<UserBonus> createUserBonus(UserBonus userBonus) {
        return this.createUserBonus(userBonus, null);
    }

    @Override
    public ModificationResult<UserBonus> createUserBonus(UserBonus userBonus, UserBonusCreateRequestParameters parameters) {
        Assertions.checkArgNotNull(userBonus, "Form may not be null");
        return this.create(userBonus, USER_BONUSES_PATH, UserBonus.class, parameters != null ? parameters.getQueryParameters() : null);
    }

    @Override
    public BatchCreateResult<UserBonus> createUserBonuses(List<UserBonus> userBonuses) {
        return this.createUserBonuses(userBonuses, null);
    }

    @Override
    public BatchCreateResult<UserBonus> createUserBonuses(List<UserBonus> userBonuses, UserBonusCreateRequestParameters parameters) {
        Assertions.checkArgNotNull(userBonuses, "Forms may not be null");
        return this.createMultiple(userBonuses, USER_BONUSES_PATH, new TypeReference<BatchCreateResult<UserBonus>>(){}, parameters);
    }

    @Override
    public UserBonusCreateBatchOperation createUserBonusesAsync(Iterator<UserBonus> userBonuses) {
        return this.createUserBonusesAsync(userBonuses, null);
    }

    @Override
    public UserBonusCreateBatchOperation createUserBonusesAsync(Iterator<UserBonus> userBonuses, UserBonusCreateRequestParameters parameters) {
        Assertions.checkArgNotNull(userBonuses, "Forms may not be null");
        return (UserBonusCreateBatchOperation)this.createMultipleAsync(userBonuses, USER_BONUSES_PATH, Operation.class, parameters);
    }

    @Override
    public SearchResult<UserBonus> findUserBonuses(UserBonusSearchRequest request) {
        return this.find(request, USER_BONUSES_PATH, new TypeReference<SearchResult<UserBonus>>(){});
    }

    @Override
    public UserBonus getUserBonus(String userBonusId) {
        Assertions.checkArgNotNull(userBonusId, "Id may not be null");
        return this.get(userBonusId, USER_BONUSES_PATH, UserBonus.class);
    }
}

