/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.impl;

import ai.toloka.client.v1.ModificationResult;
import ai.toloka.client.v1.SearchResult;
import ai.toloka.client.v1.impl.AbstractClientImpl;
import ai.toloka.client.v1.impl.TolokaClientFactoryImpl;
import ai.toloka.client.v1.impl.transport.MapperUtil;
import ai.toloka.client.v1.impl.transport.TransportUtil;
import ai.toloka.client.v1.impl.validation.Assertions;
import ai.toloka.client.v1.userrestriction.UserRestriction;
import ai.toloka.client.v1.userrestriction.UserRestrictionClient;
import ai.toloka.client.v1.userrestriction.UserRestrictionSearchRequest;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpResponse;
import org.apache.http.client.utils.URIBuilder;

public class UserRestrictionClientImpl
extends AbstractClientImpl
implements UserRestrictionClient {
    private static final String USER_RESTRICTIONS_PATH = "user-restrictions";

    UserRestrictionClientImpl(TolokaClientFactoryImpl factory) {
        super(factory);
    }

    @Override
    public SearchResult<UserRestriction> findUserRestrictions(UserRestrictionSearchRequest request) {
        return this.find(request, USER_RESTRICTIONS_PATH, new TypeReference<SearchResult<UserRestriction>>(){});
    }

    @Override
    public UserRestriction getUserRestriction(String userRestrictionId) {
        return this.get(userRestrictionId, USER_RESTRICTIONS_PATH, UserRestriction.class);
    }

    @Override
    public ModificationResult<UserRestriction> setUserRestriction(final UserRestriction userRestriction) {
        Assertions.checkArgNotNull(userRestriction, "User restriction may not be null");
        return (ModificationResult)new AbstractClientImpl.RequestExecutorWrapper<ModificationResult<UserRestriction>>(){

            @Override
            ModificationResult<UserRestriction> execute() throws URISyntaxException, IOException {
                URI uri = UserRestrictionClientImpl.this.addVersionPrefix(new URIBuilder(UserRestrictionClientImpl.this.getTolokaApiUrl()), UserRestrictionClientImpl.USER_RESTRICTIONS_PATH).build();
                HttpResponse response = TransportUtil.executePut(UserRestrictionClientImpl.this.getHttpClient(), uri, UserRestrictionClientImpl.this.getHttpConsumer(), userRestriction);
                if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201) {
                    return new ModificationResult<UserRestriction>((UserRestriction)MapperUtil.getObjectReader(UserRestriction.class).readValue(response.getEntity().getContent()), response.getStatusLine().getStatusCode() == 201);
                }
                throw UserRestrictionClientImpl.this.parseException(response);
            }
        }.wrap();
    }

    @Override
    public void deleteUserRestriction(String userRestrictionId) {
        this.delete(userRestrictionId, USER_RESTRICTIONS_PATH);
    }
}

