/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.impl;

import ai.toloka.client.v1.ModificationResult;
import ai.toloka.client.v1.SearchResult;
import ai.toloka.client.v1.impl.AbstractClientImpl;
import ai.toloka.client.v1.impl.TolokaClientFactoryImpl;
import ai.toloka.client.v1.impl.transport.MapperUtil;
import ai.toloka.client.v1.impl.transport.TransportUtil;
import ai.toloka.client.v1.impl.validation.Assertions;
import ai.toloka.client.v1.userskill.UserSkill;
import ai.toloka.client.v1.userskill.UserSkillClient;
import ai.toloka.client.v1.userskill.UserSkillSearchRequest;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpResponse;
import org.apache.http.client.utils.URIBuilder;

public class UserSkillClientImpl
extends AbstractClientImpl
implements UserSkillClient {
    private static final String USER_SKILLS_PATH = "user-skills";

    public UserSkillClientImpl(TolokaClientFactoryImpl factory) {
        super(factory);
    }

    @Override
    public SearchResult<UserSkill> findUsersSkills(UserSkillSearchRequest request) {
        return this.find(request, USER_SKILLS_PATH, new TypeReference<SearchResult<UserSkill>>(){});
    }

    @Override
    public UserSkill getUserSkill(String userSkillId) {
        return this.get(userSkillId, USER_SKILLS_PATH, UserSkill.class);
    }

    @Override
    public ModificationResult<UserSkill> setUserSkill(UserSkill userSkill) {
        return this.setUserSkill(userSkill, null);
    }

    @Override
    public ModificationResult<UserSkill> setUserSkill(final UserSkill userSkill, final String reason) {
        Assertions.checkArgNotNull(userSkill, "User skill may not be null");
        return (ModificationResult)new AbstractClientImpl.RequestExecutorWrapper<ModificationResult<UserSkill>>(){

            @Override
            ModificationResult<UserSkill> execute() throws URISyntaxException, IOException {
                URI uri = UserSkillClientImpl.this.addVersionPrefix(new URIBuilder(UserSkillClientImpl.this.getTolokaApiUrl()), UserSkillClientImpl.USER_SKILLS_PATH).build();
                HttpResponse response = TransportUtil.executePut(UserSkillClientImpl.this.getHttpClient(), uri, UserSkillClientImpl.this.getHttpConsumer(), new UserSkillUpdate(userSkill.getId(), userSkill.getSkillId(), userSkill.getUserId(), userSkill.getExactValue(), reason));
                if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201) {
                    return new ModificationResult<UserSkill>((UserSkill)MapperUtil.getObjectReader(UserSkill.class).readValue(response.getEntity().getContent()), response.getStatusLine().getStatusCode() == 201);
                }
                throw UserSkillClientImpl.this.parseException(response);
            }
        }.wrap();
    }

    @Override
    public void deleteUserSkill(String userSkillId) {
        this.delete(userSkillId, USER_SKILLS_PATH);
    }

    private static class UserSkillUpdate {
        public final String id;
        public final String skill_id;
        public final String user_id;
        public final BigDecimal value;
        public final String reason;

        public UserSkillUpdate(String id, String skillId, String userId, BigDecimal exactValue, String reason) {
            this.id = id;
            this.skill_id = skillId;
            this.user_id = userId;
            this.value = exactValue;
            this.reason = reason;
        }
    }
}

