/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.impl;

import ai.toloka.client.v1.BatchCreateResult;
import ai.toloka.client.v1.ModificationResult;
import ai.toloka.client.v1.SearchResult;
import ai.toloka.client.v1.impl.AbstractClientImpl;
import ai.toloka.client.v1.impl.TolokaClientFactoryImpl;
import ai.toloka.client.v1.impl.validation.Assertions;
import ai.toloka.client.v1.webhooksubscription.WebhookSubscription;
import ai.toloka.client.v1.webhooksubscription.WebhookSubscriptionClient;
import ai.toloka.client.v1.webhooksubscription.WebhookSubscriptionSearchRequest;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;

public class WebhookSubscriptionClientImpl
extends AbstractClientImpl
implements WebhookSubscriptionClient {
    private static final String WEBHOOK_SUBSCRIPTIONS_PATH = "webhook-subscriptions/";

    WebhookSubscriptionClientImpl(TolokaClientFactoryImpl factory) {
        super(factory);
    }

    @Override
    public ModificationResult<WebhookSubscription> upsertWebhookSubscription(WebhookSubscription webhookSubscription) {
        Assertions.checkArgNotNull(webhookSubscription, "Form may not be null");
        return this.upsert(null, webhookSubscription, WEBHOOK_SUBSCRIPTIONS_PATH, WebhookSubscription.class);
    }

    @Override
    public BatchCreateResult<WebhookSubscription> upsertWebhookSubscriptions(List<WebhookSubscription> subscriptions) {
        Assertions.checkArgNotNull(subscriptions, "Forms may not be null");
        return this.upsertMultiple(subscriptions, WEBHOOK_SUBSCRIPTIONS_PATH, new TypeReference<BatchCreateResult<WebhookSubscription>>(){});
    }

    @Override
    public SearchResult<WebhookSubscription> findWebhookSubscriptions(WebhookSubscriptionSearchRequest request) {
        return this.find(request, WEBHOOK_SUBSCRIPTIONS_PATH, new TypeReference<SearchResult<WebhookSubscription>>(){});
    }

    @Override
    public WebhookSubscription getWebhookSubscription(String webhookSubscriptionId) {
        Assertions.checkArgNotNull(webhookSubscriptionId, "Id may not be null");
        return this.get(webhookSubscriptionId, WEBHOOK_SUBSCRIPTIONS_PATH, WebhookSubscription.class);
    }

    @Override
    public void deleteWebhookSubscription(String webhookSubscriptionId) {
        this.delete(webhookSubscriptionId, WEBHOOK_SUBSCRIPTIONS_PATH);
    }
}

