/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.impl.transport;

import ai.toloka.client.v1.impl.transport.EncodeUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Properties;
import org.apache.http.Header;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;

public class DefaultHttpClientConfiguration {
    public static final URI DEFAULT_TOLOKA_PROD_URI = URI.create("https://toloka.yandex.com/api");
    public static final URI DEFAULT_TOLOKA_SANDBOX_URI = URI.create("https://sandbox.toloka.yandex.com/api");
    public static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    public static final int DEFAULT_SOCKET_TIMEOUT = 120000;
    public static final int DEFAULT_MAX_CONNECTIONS = 100;
    public static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    public static final String AUTHORIZATION_OAUTH_HEADER_FORMAT = "OAuth %s";
    public static final String USER_AGENT_FORMAT = "toloka-java-sdk/%s";

    public static HttpClient buildDefaultClient(String oauthToken) {
        return HttpClientBuilder.create().setMaxConnTotal(100).setMaxConnPerRoute(100).setDefaultRequestConfig(DefaultHttpClientConfiguration.getDefaultRequestConfig()).setUserAgent(DefaultHttpClientConfiguration.getUserAgent()).setDefaultHeaders(Collections.singletonList(DefaultHttpClientConfiguration.getDefaultAuthorizationHeader(oauthToken))).build();
    }

    public static RequestConfig getDefaultRequestConfig() {
        return RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(10000).setSocketTimeout(120000).build();
    }

    public static Header getDefaultAuthorizationHeader(String oauthToken) {
        return new BasicHeader(AUTHORIZATION_HEADER_NAME, String.format(AUTHORIZATION_OAUTH_HEADER_FORMAT, EncodeUtil.encodeNonAscii(oauthToken)));
    }

    public static String getUserAgent() {
        return String.format(USER_AGENT_FORMAT, EncodeUtil.encodeNonAscii(DefaultHttpClientConfiguration.getVersion()));
    }

    private static String getVersion() {
        Properties prop = new Properties();
        try {
            InputStream input = DefaultHttpClientConfiguration.class.getClassLoader().getResourceAsStream("version.properties");
            prop.load(input);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return prop.getProperty("version", "undefined");
    }
}

