/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.impl.transport;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class EncodeUtil {
    private static final List<String> TO_REPLACES = Arrays.asList("{", "}", ":", "\"", ",", "[", "]");
    private static final Map<String, String> REPLACES = new HashMap<String, String>();

    private EncodeUtil() {
    }

    public static String encodeNonAscii(String string) {
        try {
            String s = URLEncoder.encode(string, "UTF8");
            for (Map.Entry<String, String> replace : REPLACES.entrySet()) {
                s = s.replaceAll(replace.getKey(), replace.getValue());
            }
            return s;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("utf8 is gone - no way", e);
        }
    }

    static {
        for (String raw : TO_REPLACES) {
            try {
                REPLACES.put(URLEncoder.encode(raw, "UTF8"), raw);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("really?", e);
            }
        }
    }
}

