/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.impl.transport;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class MapperUtil {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).disable(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public static DateFormat getTolokaDateFormat() {
        return new TlkCustomDateFormat();
    }

    public static ObjectWriter getObjectWriter() {
        return OBJECT_MAPPER.writer(new TlkCustomDateFormat());
    }

    public static ObjectReader getObjectReader() {
        return MapperUtil.formatReader(OBJECT_MAPPER.reader());
    }

    public static ObjectReader getObjectReader(Class<?> c) {
        return MapperUtil.formatReader(OBJECT_MAPPER.readerFor(c));
    }

    public static ObjectReader getObjectReader(TypeReference<?> type) {
        return MapperUtil.formatReader(OBJECT_MAPPER.readerFor(type));
    }

    private static ObjectReader formatReader(ObjectReader reader) {
        return reader.with((DeserializationConfig)OBJECT_MAPPER.getDeserializationConfig().with(new TlkCustomDateFormat()));
    }

    private static class TlkCustomDateFormat
    extends DateFormat {
        private static final int DATE_FORMAT_LENGTH = 19;
        private final SimpleDateFormat defaultDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        private final SimpleDateFormat dateFormatWithMillis;

        private TlkCustomDateFormat() {
            this.defaultDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.dateFormatWithMillis = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            this.dateFormatWithMillis.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        @Override
        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            String withMillisFormat = this.dateFormatWithMillis.format(date);
            return withMillisFormat.endsWith("000") ? this.defaultDateFormat.format(date, toAppendTo, fieldPosition) : this.dateFormatWithMillis.format(date, toAppendTo, fieldPosition);
        }

        @Override
        public Date parse(String source, ParsePosition pos) {
            return source.length() == 19 ? this.defaultDateFormat.parse(source, pos) : this.dateFormatWithMillis.parse(source, pos);
        }

        @Override
        public Object clone() {
            return new TlkCustomDateFormat();
        }
    }
}

