/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.messagethread;

import ai.toloka.client.v1.SearchRequest;
import ai.toloka.client.v1.messagethread.Folder;
import ai.toloka.client.v1.messagethread.MessageThreadFilterParam;
import ai.toloka.client.v1.messagethread.MessageThreadRangeParam;
import ai.toloka.client.v1.messagethread.MessageThreadSortParam;
import java.util.Date;
import java.util.Map;

public class MessageThreadSearchRequest
extends SearchRequest {
    static final String FOLDER_PARAMETER = "folder";
    static final String FOLDER_NE_PARAMETER = "folder_ne";
    static final String ID_PARAMETER = "id";
    static final String CREATED_PARAMETER = "created";

    public MessageThreadSearchRequest(Map<String, Object> filterParameters, Map<String, Object> rangeParameters, String sortParameter, Integer limit) {
        super(filterParameters, rangeParameters, sortParameter, limit);
    }

    public static MessageThreadBuilder make() {
        return new MessageThreadBuilder(new MessageThreadFilterBuilder(), new MessageThreadRangeBuilder(), new MessageThreadSortBuilder());
    }

    public static class MessageThreadSortBuilder
    extends SearchRequest.SortBuilder<MessageThreadSortBuilder, MessageThreadBuilder, MessageThreadSortParam> {
        public SearchRequest.SortBuilder.SortItem<MessageThreadSortBuilder> byId() {
            return this.by(MessageThreadSortParam.id);
        }

        public SearchRequest.SortBuilder.SortItem<MessageThreadSortBuilder> byCreated() {
            return this.by(MessageThreadSortParam.created);
        }
    }

    public static class MessageThreadRangeBuilder
    extends SearchRequest.RangeBuilder<MessageThreadRangeBuilder, MessageThreadBuilder, MessageThreadRangeParam> {
        public SearchRequest.RangeBuilder.RangeItemBuilder<MessageThreadRangeBuilder> byId(String id) {
            return this.by(MessageThreadRangeParam.id, id);
        }

        public SearchRequest.RangeBuilder.RangeItemBuilder<MessageThreadRangeBuilder> byCreated(Date created) {
            return this.by(MessageThreadRangeParam.created, created);
        }
    }

    public static class MessageThreadFilterBuilder
    extends SearchRequest.FilterBuilder<MessageThreadFilterBuilder, MessageThreadBuilder, MessageThreadFilterParam> {
        public MessageThreadFilterBuilder byFolder(Folder folder) {
            return (MessageThreadFilterBuilder)this.by(MessageThreadFilterParam.folder, folder);
        }

        public MessageThreadFilterBuilder byFolderNe(Folder folder) {
            return (MessageThreadFilterBuilder)this.by(MessageThreadFilterParam.folder_ne, folder);
        }
    }

    public static class MessageThreadBuilder
    extends SearchRequest.Builder<MessageThreadSearchRequest, MessageThreadBuilder, MessageThreadFilterBuilder, MessageThreadRangeBuilder, MessageThreadSortBuilder> {
        public MessageThreadBuilder(MessageThreadFilterBuilder filterBuilder, MessageThreadRangeBuilder rangeBuilder, MessageThreadSortBuilder sortBuilder) {
            super(filterBuilder, rangeBuilder, sortBuilder);
        }

        @Override
        public MessageThreadSearchRequest done() {
            return new MessageThreadSearchRequest(((MessageThreadFilterBuilder)this.filterBuilder).getFilterParameters(), ((MessageThreadRangeBuilder)this.rangeBuilder).getRangeParameters(), ((MessageThreadSortBuilder)this.sortBuilder).getSortParameter(), this.getLimit());
        }
    }
}

