/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.operation;

import ai.toloka.client.v1.aggregatedsolutions.AggregatedSolutionOperation;
import ai.toloka.client.v1.impl.transport.MapperUtil;
import ai.toloka.client.v1.operation.OperationClient;
import ai.toloka.client.v1.operation.OperationStatus;
import ai.toloka.client.v1.operation.OperationType;
import ai.toloka.client.v1.operation.OperationUtil;
import ai.toloka.client.v1.pool.PoolArchiveOperation;
import ai.toloka.client.v1.pool.PoolCloneOperation;
import ai.toloka.client.v1.pool.PoolCloseOperation;
import ai.toloka.client.v1.pool.PoolOpenOperation;
import ai.toloka.client.v1.project.ProjectArchiveOperation;
import ai.toloka.client.v1.task.TaskCreateBatchOperation;
import ai.toloka.client.v1.tasksuite.TaskSuiteCreateBatchOperation;
import ai.toloka.client.v1.training.TrainingArchiveOperation;
import ai.toloka.client.v1.training.TrainingCloneOperation;
import ai.toloka.client.v1.training.TrainingCloseOperation;
import ai.toloka.client.v1.training.TrainingOpenOperation;
import ai.toloka.client.v1.userbonus.UserBonusCreateBatchOperation;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true, defaultImpl=UnknownOperation.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ProjectArchiveOperation.class, name="PROJECT.ARCHIVE"), @JsonSubTypes.Type(value=PoolOpenOperation.class, name="POOL.OPEN"), @JsonSubTypes.Type(value=PoolCloseOperation.class, name="POOL.CLOSE"), @JsonSubTypes.Type(value=PoolArchiveOperation.class, name="POOL.ARCHIVE"), @JsonSubTypes.Type(value=PoolCloneOperation.class, name="POOL.CLONE"), @JsonSubTypes.Type(value=TrainingOpenOperation.class, name="TRAINING.OPEN"), @JsonSubTypes.Type(value=TrainingCloseOperation.class, name="TRAINING.CLOSE"), @JsonSubTypes.Type(value=TrainingArchiveOperation.class, name="TRAINING.ARCHIVE"), @JsonSubTypes.Type(value=TrainingCloneOperation.class, name="TRAINING.CLONE"), @JsonSubTypes.Type(value=TaskCreateBatchOperation.class, name="TASK.BATCH_CREATE"), @JsonSubTypes.Type(value=TaskSuiteCreateBatchOperation.class, name="TASK_SUITE.BATCH_CREATE"), @JsonSubTypes.Type(value=UserBonusCreateBatchOperation.class, name="USER_BONUS.BATCH_CREATE"), @JsonSubTypes.Type(value=AggregatedSolutionOperation.class, name="SOLUTION.AGGREGATE")})
public abstract class Operation<P, T extends Operation<P, T>> {
    public static final String PSEUDO_OPERATION_ID = "PSEUDO_ID";
    public static final OperationType DEFAULT_PSEUDO_OPERATION_TYPE = OperationType.PSEUDO;
    protected String id;
    protected OperationType type;
    protected OperationStatus status;
    protected Date submitted;
    protected Date started;
    protected Date finished;
    protected Integer progress;
    protected P parameters;
    @JsonProperty
    protected JsonNode details;
    @JsonIgnore
    private Map<String, Object> detailsMap;
    @JsonIgnore
    protected OperationClient operationClient;

    public Operation() {
    }

    protected Operation(Date currentDateTime) {
        this.id = PSEUDO_OPERATION_ID;
        this.type = OperationType.PSEUDO;
        this.status = OperationStatus.SUCCESS;
        this.submitted = currentDateTime;
        this.started = currentDateTime;
        this.finished = currentDateTime;
        this.progress = 100;
    }

    public String getId() {
        return this.id;
    }

    public OperationType getType() {
        return this.type;
    }

    public OperationStatus getStatus() {
        return this.status;
    }

    public Date getSubmitted() {
        return this.submitted;
    }

    public Date getStarted() {
        return this.started;
    }

    public Date getFinished() {
        return this.finished;
    }

    public Integer getProgress() {
        return this.progress;
    }

    public P getParameters() {
        return this.parameters;
    }

    public Map<String, Object> getDetailsAsMap() {
        if (this.details == null) {
            return Collections.emptyMap();
        }
        if (this.detailsMap == null) {
            try {
                this.detailsMap = (Map)MapperUtil.getObjectReader(Map.class).readValue(this.details);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.detailsMap;
    }

    public boolean isCompleted() {
        return this.getStatus().isTerminal();
    }

    public boolean isSuccess() {
        return this.getStatus() == OperationStatus.SUCCESS;
    }

    public T refresh() {
        if (this.isPseudo()) {
            return (T)this;
        }
        return this.operationClient.getOperation(this.id);
    }

    public T waitToComplete() throws InterruptedException {
        if (this.isPseudo()) {
            return (T)this;
        }
        return (T)OperationUtil.waitToComplete(this, this.operationClient);
    }

    public T waitToCompleteUninterrupted() {
        if (this.isPseudo()) {
            return (T)this;
        }
        return (T)OperationUtil.waitToCompleteUninterrupted(this, this.operationClient);
    }

    public T waitAndGetSuccessful() throws InterruptedException {
        if (this.isPseudo()) {
            return (T)this;
        }
        return (T)OperationUtil.waitAndGetSuccessful(this, this.operationClient);
    }

    public T waitAndGetSuccessfulUninterrupted() {
        if (this.isPseudo()) {
            return (T)this;
        }
        return (T)OperationUtil.waitAndGetSuccessfulUninterrupted(this, this.operationClient);
    }

    public boolean isPseudo() {
        return this.getId().equals(PSEUDO_OPERATION_ID);
    }

    public static void setOperationClient(Operation<?, ?> operation, OperationClient operationClient) {
        operation.operationClient = operationClient;
    }

    public static Operation createPseudo(Date currentDateTime) {
        return new Operation(currentDateTime){};
    }

    public static class UnknownOperation
    extends Operation {
    }
}

