/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.operation;

import ai.toloka.client.v1.SearchRequest;
import ai.toloka.client.v1.operation.OperationFilterParam;
import ai.toloka.client.v1.operation.OperationRangeParam;
import ai.toloka.client.v1.operation.OperationSortParam;
import ai.toloka.client.v1.operation.OperationStatus;
import ai.toloka.client.v1.operation.OperationType;
import java.util.Date;
import java.util.Map;

public class OperationSearchRequest
extends SearchRequest {
    public static final String TYPE_PARAMETER = "type";
    public static final String STATUS_PARAMETER = "status";
    public static final String ID_PARAMETER = "id";
    public static final String SUBMITTED_PARAMETER = "submitted";
    public static final String FINISHED_PARAMETER = "finished";

    private OperationSearchRequest(Map<String, Object> filterParameters, Map<String, Object> rangeParameters, String sortParameter, Integer limit) {
        super(filterParameters, rangeParameters, sortParameter, limit);
    }

    public static OperationBuilder make() {
        return new OperationBuilder(new OperationFilterBuilder(), new OperationRangeBuilder(), new OperationSortBuilder());
    }

    public static class OperationSortBuilder
    extends SearchRequest.SortBuilder<OperationSortBuilder, OperationBuilder, OperationSortParam> {
        public SearchRequest.SortBuilder.SortItem<OperationSortBuilder> byId() {
            return this.by(OperationSortParam.id);
        }

        public SearchRequest.SortBuilder.SortItem<OperationSortBuilder> bySubmitted() {
            return this.by(OperationSortParam.submitted);
        }

        public SearchRequest.SortBuilder.SortItem<OperationSortBuilder> byFinished() {
            return this.by(OperationSortParam.finished);
        }
    }

    public static class OperationRangeBuilder
    extends SearchRequest.RangeBuilder<OperationRangeBuilder, OperationBuilder, OperationRangeParam> {
        public SearchRequest.RangeBuilder.RangeItemBuilder<OperationRangeBuilder> byId(String id) {
            return this.by(OperationRangeParam.id, id);
        }

        public SearchRequest.RangeBuilder.RangeItemBuilder<OperationRangeBuilder> bySubmitted(Date submitted) {
            return this.by(OperationRangeParam.submitted, submitted);
        }

        public SearchRequest.RangeBuilder.RangeItemBuilder<OperationRangeBuilder> byFinished(Date finished) {
            return this.by(OperationRangeParam.finished, finished);
        }
    }

    public static class OperationFilterBuilder
    extends SearchRequest.FilterBuilder<OperationFilterBuilder, OperationBuilder, OperationFilterParam> {
        public OperationFilterBuilder byType(OperationType type) {
            return (OperationFilterBuilder)this.by(OperationFilterParam.type, type);
        }

        public OperationFilterBuilder byStatus(OperationStatus status) {
            return (OperationFilterBuilder)this.by(OperationFilterParam.status, status);
        }
    }

    public static class OperationBuilder
    extends SearchRequest.Builder<OperationSearchRequest, OperationBuilder, OperationFilterBuilder, OperationRangeBuilder, OperationSortBuilder> {
        private OperationBuilder(OperationFilterBuilder filterBuilder, OperationRangeBuilder rangeBuilder, OperationSortBuilder sortBuilder) {
            super(filterBuilder, rangeBuilder, sortBuilder);
        }

        @Override
        public OperationSearchRequest done() {
            return new OperationSearchRequest(((OperationFilterBuilder)this.filterBuilder).getFilterParameters(), ((OperationRangeBuilder)this.rangeBuilder).getRangeParameters(), ((OperationSortBuilder)this.sortBuilder).getSortParameter(), this.getLimit());
        }
    }
}

