/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.operation;

import ai.toloka.client.v1.operation.Operation;
import ai.toloka.client.v1.operation.OperationClient;
import ai.toloka.client.v1.operation.OperationFailedException;
import ai.toloka.client.v1.operation.OperationTimeoutException;

class OperationUtil {
    public static final int DEFAULT_TIME_TO_WAIT_MILLIS = 1000;
    public static final int DEFAULT_TIMEOUT_MILLIS = 600000;
    public static final int DEFAULT_INITIAL_DELAY_MILLIS = 500;

    OperationUtil() {
    }

    static <P, T extends Operation<P, T>> T waitToComplete(T operation, OperationClient client) throws InterruptedException {
        if (operation == null || operation.getStatus().isTerminal()) {
            return operation;
        }
        long now = System.currentTimeMillis();
        long timeoutMillis = now + 600000L;
        if (operation.getStarted() == null || now - operation.getStarted().getTime() < 500L) {
            Thread.sleep(500L);
        }
        do {
            Object newOperation;
            if (((Operation)(newOperation = client.getOperation(operation.getId()))).isCompleted()) {
                return newOperation;
            }
            Thread.sleep(1000L);
        } while (System.currentTimeMillis() <= timeoutMillis);
        throw new OperationTimeoutException();
    }

    static <P, T extends Operation<P, T>> T waitToCompleteUninterrupted(T operation, OperationClient client) {
        try {
            return OperationUtil.waitToComplete(operation, client);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    static <P, T extends Operation<P, T>> T waitAndGetSuccessful(T operation, OperationClient client) throws InterruptedException {
        T completed = OperationUtil.waitToComplete(operation, client);
        if (!completed.isSuccess()) {
            throw new OperationFailedException(completed.getDetailsAsMap());
        }
        return completed;
    }

    static <P, T extends Operation<P, T>> T waitAndGetSuccessfulUninterrupted(T operation, OperationClient client) {
        try {
            return OperationUtil.waitAndGetSuccessful(operation, client);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}

