/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.pool;

import ai.toloka.client.v1.SearchRequest;
import ai.toloka.client.v1.pool.PoolFilterParam;
import ai.toloka.client.v1.pool.PoolRangeParam;
import ai.toloka.client.v1.pool.PoolSortParam;
import ai.toloka.client.v1.pool.PoolStatus;
import java.util.Date;
import java.util.Map;

public class PoolSearchRequest
extends SearchRequest {
    static final String OWNER_ID_PARAMETER = "owner_id";
    static final String OWNER_COMPANY_ID_PARAMETER = "owner_company_id";
    static final String STATUS_PARAMETER = "status";
    static final String PROJECT_ID_PARAMETER = "project_id";
    static final String ID_PARAMETER = "id";
    static final String CREATED_PARAMETER = "created";
    static final String LAST_STARTED_PARAMETER = "last_started";

    public PoolSearchRequest(Map<String, Object> filterParameters, Map<String, Object> rangeParameters, String sortParameter, Integer limit) {
        super(filterParameters, rangeParameters, sortParameter, limit);
    }

    public static PoolBuilder make() {
        return new PoolBuilder(new PoolFilterBuilder(), new PoolRangeBuilder(), new PoolSortBuilder());
    }

    public static class PoolSortBuilder
    extends SearchRequest.SortBuilder<PoolSortBuilder, PoolBuilder, PoolSortParam> {
        public SearchRequest.SortBuilder.SortItem<PoolSortBuilder> byId() {
            return this.by(PoolSortParam.id);
        }

        public SearchRequest.SortBuilder.SortItem<PoolSortBuilder> byCreated() {
            return this.by(PoolSortParam.created);
        }

        public SearchRequest.SortBuilder.SortItem<PoolSortBuilder> byLastStarted() {
            return this.by(PoolSortParam.lastStarted);
        }
    }

    public static class PoolRangeBuilder
    extends SearchRequest.RangeBuilder<PoolRangeBuilder, PoolBuilder, PoolRangeParam> {
        public SearchRequest.RangeBuilder.RangeItemBuilder<PoolRangeBuilder> byId(String id) {
            return this.by(PoolRangeParam.id, id);
        }

        public SearchRequest.RangeBuilder.RangeItemBuilder<PoolRangeBuilder> byCreated(Date created) {
            return this.by(PoolRangeParam.created, created);
        }

        public SearchRequest.RangeBuilder.RangeItemBuilder<PoolRangeBuilder> byLastStarted(Date lastStarted) {
            return this.by(PoolRangeParam.lastStarted, lastStarted);
        }
    }

    public static class PoolFilterBuilder
    extends SearchRequest.FilterBuilder<PoolFilterBuilder, PoolBuilder, PoolFilterParam> {
        public PoolFilterBuilder byOwnerId(String ownerId) {
            return (PoolFilterBuilder)this.by(PoolFilterParam.ownerId, ownerId);
        }

        public PoolFilterBuilder byOwnerCompanyId(String companyId) {
            return (PoolFilterBuilder)this.by(PoolFilterParam.ownerCompanyId, companyId);
        }

        public PoolFilterBuilder byStatus(PoolStatus status) {
            return (PoolFilterBuilder)this.by(PoolFilterParam.status, status);
        }

        public PoolFilterBuilder byProjectId(String projectId) {
            return (PoolFilterBuilder)this.by(PoolFilterParam.projectId, projectId);
        }
    }

    public static class PoolBuilder
    extends SearchRequest.Builder<PoolSearchRequest, PoolBuilder, PoolFilterBuilder, PoolRangeBuilder, PoolSortBuilder> {
        public PoolBuilder(PoolFilterBuilder filterBuilder, PoolRangeBuilder rangeBuilder, PoolSortBuilder sortBuilder) {
            super(filterBuilder, rangeBuilder, sortBuilder);
        }

        @Override
        public PoolSearchRequest done() {
            return new PoolSearchRequest(((PoolFilterBuilder)this.filterBuilder).getFilterParameters(), ((PoolRangeBuilder)this.rangeBuilder).getRangeParameters(), ((PoolSortBuilder)this.sortBuilder).getSortParameter(), this.getLimit());
        }
    }
}

