/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.pool.filter;

import ai.toloka.client.v1.impl.transport.MapperUtil;
import ai.toloka.client.v1.pool.filter.Connective;
import ai.toloka.client.v1.pool.filter.Expression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Map;

public abstract class Condition {

    public static class RawCondition {
        private final Map<String, Object> content;

        @JsonCreator
        RawCondition(Map<String, Object> content) {
            this.content = content;
        }

        @JsonValue
        public Map<String, Object> getContent() {
            return this.content;
        }
    }

    public static class ConditionDeserializer
    extends JsonDeserializer<Condition> {
        @Override
        public Condition deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Object node;
            if (p.getCurrentToken() == JsonToken.START_OBJECT) {
                p.nextToken();
            }
            if ((node = p.readValueAsTree()) instanceof ObjectNode) {
                ObjectNode objectNode = (ObjectNode)node;
                if (objectNode.has("and")) {
                    return (Condition)MapperUtil.getObjectReader(Connective.And.class).readValue(objectNode);
                }
                if (objectNode.has("or")) {
                    return (Condition)MapperUtil.getObjectReader(Connective.Or.class).readValue(objectNode);
                }
                if (objectNode.has("category") && objectNode.get("category").isTextual()) {
                    String category;
                    switch (category = objectNode.get("category").asText()) {
                        case "profile": {
                            return (Condition)MapperUtil.getObjectReader(Expression.ProfileExpression.class).readValue(objectNode);
                        }
                        case "computed": {
                            return (Condition)MapperUtil.getObjectReader(Expression.ComputedExpression.class).readValue(objectNode);
                        }
                        case "skill": {
                            return (Condition)MapperUtil.getObjectReader(Expression.Skill.class).readValue(objectNode);
                        }
                    }
                }
                return (Condition)MapperUtil.getObjectReader(Expression.RawExpression.class).readValue(objectNode);
            }
            return (Condition)MapperUtil.getObjectReader(RawCondition.class).readValue((JsonNode)node);
        }
    }
}

