/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.pool.qualitycontrol;

import ai.toloka.client.v1.pool.qualitycontrol.CollectorConfigType;
import ai.toloka.client.v1.pool.qualitycontrol.RuleConditionKey;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true, defaultImpl=Unknown.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=GoldenSet.class, name="GOLDEN_SET"), @JsonSubTypes.Type(value=MajorityVote.class, name="MAJORITY_VOTE"), @JsonSubTypes.Type(value=Captcha.class, name="CAPTCHA"), @JsonSubTypes.Type(value=Income.class, name="INCOME"), @JsonSubTypes.Type(value=SkippedInRowAssignments.class, name="SKIPPED_IN_ROW_ASSIGNMENTS"), @JsonSubTypes.Type(value=AnswerCount.class, name="ANSWER_COUNT"), @JsonSubTypes.Type(value=AssignmentSubmitTime.class, name="ASSIGNMENT_SUBMIT_TIME"), @JsonSubTypes.Type(value=AcceptanceRate.class, name="ACCEPTANCE_RATE"), @JsonSubTypes.Type(value=AssignmentsAssessment.class, name="ASSIGNMENTS_ASSESSMENT"), @JsonSubTypes.Type(value=UsersAssessment.class, name="USERS_ASSESSMENT"), @JsonSubTypes.Type(value=Training.class, name="TRAINING")})
public abstract class CollectorConfig<P> {
    protected UUID uuid;
    private final CollectorConfigType type;
    private P parameters;

    private CollectorConfig(CollectorConfigType type) {
        this.type = type;
    }

    private CollectorConfig(CollectorConfigType type, P parameters) {
        this.type = type;
        this.parameters = parameters;
    }

    public CollectorConfigType getType() {
        return this.type;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public P getParameters() {
        return this.parameters;
    }

    public void setParameters(P parameters) {
        this.parameters = parameters;
    }

    public static class Unknown
    extends CollectorConfig<Map<String, Object>> {
        @JsonCreator
        public Unknown(@JsonProperty(value="type") CollectorConfigType type) {
            super(type);
        }
    }

    public static class Training
    extends CollectorConfig<Parameters> {
        private static final Set<RuleConditionKey> OUTPUT_FIELDS = Collections.unmodifiableSet(new HashSet<RuleConditionKey>(){
            {
                this.add(RuleConditionKey.SUBMITTED_ASSIGNMENTS_COUNT);
                this.add(RuleConditionKey.TOTAL_ANSWERS_COUNT);
                this.add(RuleConditionKey.CORRECT_ANSWERS_RATE);
                this.add(RuleConditionKey.INCORRECT_ANSWERS_RATE);
                this.add(RuleConditionKey.NEXT_ASSIGNMENT_AVAILABLE);
            }
        });

        public Training() {
            super(CollectorConfigType.TRAINING);
        }

        @JsonCreator
        public Training(@JsonProperty(value="parameters") Parameters parameters) {
            super(CollectorConfigType.TRAINING, parameters);
        }

        public static Set<RuleConditionKey> outputFields() {
            return OUTPUT_FIELDS;
        }

        public static class Parameters {
        }
    }

    public static class UsersAssessment
    extends CollectorConfig<Parameters> {
        private static final Set<RuleConditionKey> OUTPUT_FIELDS = Collections.unmodifiableSet(new HashSet<RuleConditionKey>(){
            {
                this.add(RuleConditionKey.POOL_ACCESS_REVOKED_REASON);
                this.add(RuleConditionKey.SKILL_ID);
            }
        });

        public UsersAssessment() {
            super(CollectorConfigType.USERS_ASSESSMENT);
        }

        @JsonCreator
        public UsersAssessment(@JsonProperty(value="parameters") Parameters parameters) {
            super(CollectorConfigType.USERS_ASSESSMENT, parameters);
        }

        public static Set<RuleConditionKey> outputFields() {
            return OUTPUT_FIELDS;
        }

        public static class Parameters {
        }
    }

    public static class AssignmentsAssessment
    extends CollectorConfig<Parameters> {
        private static final Set<RuleConditionKey> OUTPUT_FIELDS = Collections.unmodifiableSet(new HashSet<RuleConditionKey>(){
            {
                this.add(RuleConditionKey.PENDING_ASSIGNMENTS_COUNT);
                this.add(RuleConditionKey.ACCEPTED_ASSIGNMENTS_COUNT);
                this.add(RuleConditionKey.REJECTED_ASSIGNMENTS_COUNT);
                this.add(RuleConditionKey.ASSESSMENT_EVENT);
            }
        });

        public AssignmentsAssessment() {
            super(CollectorConfigType.ASSIGNMENTS_ASSESSMENT);
        }

        @JsonCreator
        public AssignmentsAssessment(@JsonProperty(value="parameters") Parameters parameters) {
            super(CollectorConfigType.ASSIGNMENTS_ASSESSMENT, parameters);
        }

        public static Set<RuleConditionKey> outputFields() {
            return OUTPUT_FIELDS;
        }

        public static class Parameters {
        }
    }

    public static class AcceptanceRate
    extends CollectorConfig<Parameters> {
        private static final Set<RuleConditionKey> OUTPUT_FIELDS = Collections.unmodifiableSet(new HashSet<RuleConditionKey>(){
            {
                this.add(RuleConditionKey.TOTAL_ASSIGNMENTS_COUNT);
                this.add(RuleConditionKey.ACCEPTED_ASSIGNMENTS_RATE);
                this.add(RuleConditionKey.REJECTED_ASSIGNMENTS_RATE);
            }
        });

        public AcceptanceRate() {
            super(CollectorConfigType.ACCEPTANCE_RATE);
        }

        @JsonCreator
        public AcceptanceRate(@JsonProperty(value="parameters") Parameters parameters) {
            super(CollectorConfigType.ACCEPTANCE_RATE, parameters);
        }

        public static Set<RuleConditionKey> outputFields() {
            return OUTPUT_FIELDS;
        }

        public static class Parameters {
        }
    }

    public static class AssignmentSubmitTime
    extends CollectorConfig<Parameters> {
        private static final Set<RuleConditionKey> OUTPUT_FIELDS = Collections.unmodifiableSet(new HashSet<RuleConditionKey>(){
            {
                this.add(RuleConditionKey.TOTAL_SUBMITTED_COUNT);
                this.add(RuleConditionKey.FAST_SUBMITTED_COUNT);
            }
        });

        @JsonCreator
        public AssignmentSubmitTime(@JsonProperty(value="parameters") Parameters parameters) {
            super(CollectorConfigType.ASSIGNMENT_SUBMIT_TIME, parameters);
        }

        public static Set<RuleConditionKey> outputFields() {
            return OUTPUT_FIELDS;
        }

        public static class Parameters {
            @JsonProperty(value="history_size")
            private Integer historySize;
            @JsonProperty(value="fast_submit_threshold_seconds")
            private Integer fastSubmitThresholdSeconds;

            @JsonCreator
            public Parameters(@JsonProperty(value="history_size") Integer historySize, @JsonProperty(value="fast_submit_threshold_seconds") Integer fastSubmitThresholdSeconds) {
                this.historySize = historySize;
                this.fastSubmitThresholdSeconds = fastSubmitThresholdSeconds;
            }

            public Integer getHistorySize() {
                return this.historySize;
            }

            public void setHistorySize(Integer historySize) {
                this.historySize = historySize;
            }

            public Integer getFastSubmitThresholdSeconds() {
                return this.fastSubmitThresholdSeconds;
            }

            public void setFastSubmitThresholdSeconds(Integer fastSubmitThresholdSeconds) {
                this.fastSubmitThresholdSeconds = fastSubmitThresholdSeconds;
            }
        }
    }

    public static class AnswerCount
    extends CollectorConfig<Parameters> {
        private static final Set<RuleConditionKey> OUTPUT_FIELDS = Collections.unmodifiableSet(new HashSet<RuleConditionKey>(){
            {
                this.add(RuleConditionKey.ASSIGNMENTS_ACCEPTED_COUNT);
            }
        });

        public AnswerCount() {
            super(CollectorConfigType.ANSWER_COUNT);
        }

        @JsonCreator
        public AnswerCount(@JsonProperty(value="parameters") Parameters parameters) {
            super(CollectorConfigType.ANSWER_COUNT, parameters);
        }

        public static Set<RuleConditionKey> outputFields() {
            return OUTPUT_FIELDS;
        }

        public static class Parameters {
        }
    }

    public static class SkippedInRowAssignments
    extends CollectorConfig<Parameters> {
        private static final Set<RuleConditionKey> OUTPUT_FIELDS = Collections.unmodifiableSet(new HashSet<RuleConditionKey>(){
            {
                this.add(RuleConditionKey.SKIPPED_IN_ROW_COUNT);
            }
        });

        public SkippedInRowAssignments() {
            super(CollectorConfigType.SKIPPED_IN_ROW_ASSIGNMENTS);
        }

        @JsonCreator
        public SkippedInRowAssignments(@JsonProperty(value="parameters") Parameters parameters) {
            super(CollectorConfigType.SKIPPED_IN_ROW_ASSIGNMENTS, parameters);
        }

        public static Set<RuleConditionKey> outputFields() {
            return OUTPUT_FIELDS;
        }

        public static class Parameters {
        }
    }

    public static class Income
    extends CollectorConfig<Parameters> {
        private static final Set<RuleConditionKey> OUTPUT_FIELDS = Collections.unmodifiableSet(new HashSet<RuleConditionKey>(){
            {
                this.add(RuleConditionKey.INCOME_SUM_FOR_LAST_24_HOURS);
            }
        });

        public Income() {
            super(CollectorConfigType.INCOME);
        }

        @JsonCreator
        public Income(@JsonProperty(value="parameters") Parameters parameters) {
            super(CollectorConfigType.INCOME, parameters);
        }

        public static Set<RuleConditionKey> outputFields() {
            return OUTPUT_FIELDS;
        }

        public static class Parameters {
        }
    }

    public static class Captcha
    extends CollectorConfig<Parameters> {
        private static final Set<RuleConditionKey> OUTPUT_FIELDS = Collections.unmodifiableSet(new HashSet<RuleConditionKey>(){
            {
                this.add(RuleConditionKey.STORED_RESULTS_COUNT);
                this.add(RuleConditionKey.SUCCESS_RATE);
                this.add(RuleConditionKey.FAIL_RATE);
            }
        });

        @JsonCreator
        public Captcha(@JsonProperty(value="parameters") Parameters parameters) {
            super(CollectorConfigType.CAPTCHA, parameters);
        }

        public static Set<RuleConditionKey> outputFields() {
            return OUTPUT_FIELDS;
        }

        public static class Parameters {
            @JsonProperty(value="history_size")
            private Integer historySize;

            @JsonCreator
            public Parameters(@JsonProperty(value="history_size") Integer historySize) {
                this.historySize = historySize;
            }

            public Integer getHistorySize() {
                return this.historySize;
            }

            public void setHistorySize(Integer historySize) {
                this.historySize = historySize;
            }
        }
    }

    public static class MajorityVote
    extends CollectorConfig<Parameters> {
        private static final Set<RuleConditionKey> OUTPUT_FIELDS = Collections.unmodifiableSet(new HashSet<RuleConditionKey>(){
            {
                this.add(RuleConditionKey.TOTAL_ANSWERS_COUNT);
                this.add(RuleConditionKey.CORRECT_ANSWERS_RATE);
                this.add(RuleConditionKey.INCORRECT_ANSWERS_RATE);
            }
        });

        @JsonCreator
        public MajorityVote(@JsonProperty(value="parameters") Parameters parameters) {
            super(CollectorConfigType.MAJORITY_VOTE, parameters);
        }

        public static Set<RuleConditionKey> outputFields() {
            return OUTPUT_FIELDS;
        }

        public static class Parameters {
            @JsonProperty(value="answer_threshold")
            private Integer answerThreshold;
            @JsonProperty(value="history_size")
            private Integer historySize;

            @JsonCreator
            public Parameters(@JsonProperty(value="answer_threshold") Integer answerThreshold) {
                this.answerThreshold = answerThreshold;
            }

            public Integer getAnswerThreshold() {
                return this.answerThreshold;
            }

            public void setAnswerThreshold(Integer answerThreshold) {
                this.answerThreshold = answerThreshold;
            }

            public Integer getHistorySize() {
                return this.historySize;
            }

            public void setHistorySize(Integer historySize) {
                this.historySize = historySize;
            }
        }
    }

    public static class GoldenSet
    extends CollectorConfig<Parameters> {
        private static final Set<RuleConditionKey> OUTPUT_FIELDS = Collections.unmodifiableSet(new HashSet<RuleConditionKey>(){
            {
                this.add(RuleConditionKey.TOTAL_ANSWERS_COUNT);
                this.add(RuleConditionKey.CORRECT_ANSWERS_RATE);
                this.add(RuleConditionKey.INCORRECT_ANSWERS_RATE);
                this.add(RuleConditionKey.GOLDEN_SET_ANSWERS_COUNT);
                this.add(RuleConditionKey.GOLDEN_SET_CORRECT_ANSWERS_RATE);
                this.add(RuleConditionKey.GOLDEN_SET_INCORRECT_ANSWERS_RATE);
            }
        });

        public GoldenSet() {
            super(CollectorConfigType.GOLDEN_SET);
        }

        @JsonCreator
        public GoldenSet(@JsonProperty(value="parameters") Parameters parameters) {
            super(CollectorConfigType.GOLDEN_SET, parameters);
        }

        public static Set<RuleConditionKey> outputFields() {
            return OUTPUT_FIELDS;
        }

        public static class Parameters {
            @JsonProperty(value="history_size")
            private Integer historySize;

            public Integer getHistorySize() {
                return this.historySize;
            }

            public void setHistorySize(Integer historySize) {
                this.historySize = historySize;
            }
        }
    }
}

