/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.pool.qualitycontrol;

import ai.toloka.client.v1.pool.qualitycontrol.RuleActionType;
import ai.toloka.client.v1.pool.qualitycontrol.RuleConditionKey;
import ai.toloka.client.v1.userrestriction.DurationUnit;
import ai.toloka.client.v1.userrestriction.UserRestrictionScope;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true, defaultImpl=Unknown.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Restriction.class, name="RESTRICTION"), @JsonSubTypes.Type(value=RestrictionV2.class, name="RESTRICTION_V2"), @JsonSubTypes.Type(value=SetSkillFromOutputField.class, name="SET_SKILL_FROM_OUTPUT_FIELD"), @JsonSubTypes.Type(value=ChangeOverlap.class, name="CHANGE_OVERLAP"), @JsonSubTypes.Type(value=SetSkill.class, name="SET_SKILL"), @JsonSubTypes.Type(value=RejectAllAssignments.class, name="REJECT_ALL_ASSIGNMENTS"), @JsonSubTypes.Type(value=ApproveAllAssignments.class, name="APPROVE_ALL_ASSIGNMENTS")})
public abstract class RuleAction<P> {
    private final RuleActionType type;
    private P parameters;

    private RuleAction(RuleActionType type) {
        this.type = type;
    }

    private RuleAction(RuleActionType type, P parameters) {
        this.type = type;
        this.parameters = parameters;
    }

    public RuleActionType getType() {
        return this.type;
    }

    public P getParameters() {
        return this.parameters;
    }

    public void setParameters(P parameters) {
        this.parameters = parameters;
    }

    public static class Unknown
    extends RuleAction<Map<String, Object>> {
        @JsonCreator
        public Unknown(@JsonProperty(value="type") RuleActionType type) {
            super(type);
        }
    }

    public static class ApproveAllAssignments
    extends RuleAction<Parameters> {
        @JsonCreator
        public ApproveAllAssignments(@JsonProperty(value="parameters") Parameters parameters) {
            super(RuleActionType.APPROVE_ALL_ASSIGNMENTS, parameters);
        }

        public static class Parameters {
        }
    }

    @Deprecated
    public static class RejectAllAssignments
    extends RuleAction<Parameters> {
        @JsonCreator
        public RejectAllAssignments(@JsonProperty(value="parameters") Parameters parameters) {
            super(RuleActionType.REJECT_ALL_ASSIGNMENTS, parameters);
        }

        public static class Parameters {
            @JsonProperty(value="public_comment")
            private String publicComment;

            @JsonCreator
            public Parameters(@JsonProperty(value="public_comment") String publicComment) {
                this.publicComment = publicComment;
            }

            public String getPublicComment() {
                return this.publicComment;
            }

            public void setPublicComment(String publicComment) {
                this.publicComment = publicComment;
            }
        }
    }

    public static class SetSkill
    extends RuleAction<Parameters> {
        @JsonCreator
        public SetSkill(@JsonProperty(value="parameters") Parameters parameters) {
            super(RuleActionType.SET_SKILL, parameters);
        }

        public static class Parameters {
            @JsonProperty(value="skill_id")
            private String skillId;
            @JsonProperty(value="skill_value")
            private Integer skillValue;

            @JsonCreator
            public Parameters(@JsonProperty(value="skill_id") String skillId, @JsonProperty(value="skill_value") Integer skillValue) {
                this.skillId = skillId;
                this.skillValue = skillValue;
            }

            public String getSkillId() {
                return this.skillId;
            }

            public void setSkillId(String skillId) {
                this.skillId = skillId;
            }

            public Integer getSkillValue() {
                return this.skillValue;
            }

            public void setSkillValue(Integer skillValue) {
                this.skillValue = skillValue;
            }
        }
    }

    public static class ChangeOverlap
    extends RuleAction<Parameters> {
        @JsonCreator
        public ChangeOverlap(@JsonProperty(value="parameters") Parameters parameters) {
            super(RuleActionType.CHANGE_OVERLAP, parameters);
        }

        public static class Parameters {
            private Integer delta;
            @JsonProperty(value="open_pool")
            private Boolean openPool;

            @JsonCreator
            public Parameters(@JsonProperty(value="delta") Integer delta) {
                this.delta = delta;
            }

            public Parameters(Integer delta, Boolean openPool) {
                this.delta = delta;
                this.openPool = openPool;
            }

            public Integer getDelta() {
                return this.delta;
            }

            public void setDelta(Integer delta) {
                this.delta = delta;
            }

            public Boolean getOpenPool() {
                return this.openPool;
            }

            public void setOpenPool(Boolean openPool) {
                this.openPool = openPool;
            }
        }
    }

    public static class SetSkillFromOutputField
    extends RuleAction<Parameters> {
        @JsonCreator
        public SetSkillFromOutputField(@JsonProperty(value="parameters") Parameters parameters) {
            super(RuleActionType.SET_SKILL_FROM_OUTPUT_FIELD, parameters);
        }

        public static class Parameters {
            @JsonProperty(value="skill_id")
            private String skillId;
            @JsonProperty(value="from_field")
            private RuleConditionKey fromField;

            @JsonCreator
            public Parameters(@JsonProperty(value="skill_id") String skillId, @JsonProperty(value="from_field") RuleConditionKey fromField) {
                this.skillId = skillId;
                this.fromField = fromField;
            }

            public String getSkillId() {
                return this.skillId;
            }

            public void setSkillId(String skillId) {
                this.skillId = skillId;
            }

            public RuleConditionKey getFromField() {
                return this.fromField;
            }

            public void setFromField(RuleConditionKey fromField) {
                this.fromField = fromField;
            }
        }
    }

    public static class RestrictionV2
    extends RuleAction<Parameters> {
        @JsonCreator
        public RestrictionV2(@JsonProperty(value="parameters") Parameters parameters) {
            super(RuleActionType.RESTRICTION_V2, parameters);
        }

        public static class Parameters {
            private UserRestrictionScope scope;
            @JsonProperty(value="duration")
            private Integer duration;
            @JsonProperty(value="duration_unit")
            private DurationUnit durationUnit;
            @JsonProperty(value="private_comment")
            private String privateComment;

            @JsonCreator
            public Parameters(@JsonProperty(value="scope") UserRestrictionScope scope) {
                this.scope = scope;
            }

            public Parameters(UserRestrictionScope scope, Integer duration, DurationUnit durationUnit, String privateComment) {
                this.scope = scope;
                this.duration = duration;
                this.durationUnit = durationUnit;
                this.privateComment = privateComment;
            }

            public UserRestrictionScope getScope() {
                return this.scope;
            }

            public void setScope(UserRestrictionScope scope) {
                this.scope = scope;
            }

            public Integer getDuration() {
                return this.duration;
            }

            public void setDuration(Integer duration) {
                this.duration = duration;
            }

            public DurationUnit getDurationUnit() {
                return this.durationUnit;
            }

            public void setDurationUnit(DurationUnit durationUnit) {
                this.durationUnit = durationUnit;
            }

            public String getPrivateComment() {
                return this.privateComment;
            }

            public void setPrivateComment(String privateComment) {
                this.privateComment = privateComment;
            }
        }
    }

    @Deprecated
    public static class Restriction
    extends RuleAction<Parameters> {
        @JsonCreator
        public Restriction(@JsonProperty(value="parameters") Parameters parameters) {
            super(RuleActionType.RESTRICTION, parameters);
        }

        public static class Parameters {
            private UserRestrictionScope scope;
            @JsonProperty(value="duration_days")
            private Integer durationDays;
            @JsonProperty(value="private_comment")
            private String privateComment;

            @JsonCreator
            public Parameters(@JsonProperty(value="scope") UserRestrictionScope scope) {
                this.scope = scope;
            }

            public Parameters(UserRestrictionScope scope, Integer durationDays, String privateComment) {
                this.scope = scope;
                this.durationDays = durationDays;
                this.privateComment = privateComment;
            }

            public UserRestrictionScope getScope() {
                return this.scope;
            }

            public void setScope(UserRestrictionScope scope) {
                this.scope = scope;
            }

            public Integer getDurationDays() {
                return this.durationDays;
            }

            public void setDurationDays(Integer durationDays) {
                this.durationDays = durationDays;
            }

            public String getPrivateComment() {
                return this.privateComment;
            }

            public void setPrivateComment(String privateComment) {
                this.privateComment = privateComment;
            }
        }
    }
}

