/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.project.spec;

import ai.toloka.client.v1.project.spec.FieldType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Set;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true, defaultImpl=UnknownSpec.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=BooleanSpec.class, name="boolean"), @JsonSubTypes.Type(value=ArrayBooleanSpec.class, name="array_boolean"), @JsonSubTypes.Type(value=StringSpec.class, name="string"), @JsonSubTypes.Type(value=ArrayStringSpec.class, name="array_string"), @JsonSubTypes.Type(value=IntegerSpec.class, name="integer"), @JsonSubTypes.Type(value=ArrayIntegerSpec.class, name="array_integer"), @JsonSubTypes.Type(value=FloatSpec.class, name="float"), @JsonSubTypes.Type(value=ArrayFloatSpec.class, name="array_float"), @JsonSubTypes.Type(value=UrlSpec.class, name="url"), @JsonSubTypes.Type(value=ArrayUrlSpec.class, name="array_url"), @JsonSubTypes.Type(value=FileSpec.class, name="file"), @JsonSubTypes.Type(value=ArrayFileSpec.class, name="array_file"), @JsonSubTypes.Type(value=CoordinatesSpec.class, name="coordinates"), @JsonSubTypes.Type(value=ArrayCoordinatesSpec.class, name="array_coordinates"), @JsonSubTypes.Type(value=JsonSpec.class, name="json"), @JsonSubTypes.Type(value=ArrayJsonSpec.class, name="array_json")})
public abstract class FieldSpec {
    private FieldType type;
    private boolean required;
    private boolean hidden;

    @JsonCreator
    private FieldSpec(@JsonProperty(value="type") FieldType type, @JsonProperty(value="required") boolean required, @JsonProperty(value="hidden") boolean hidden) {
        this.type = type;
        this.required = required;
        this.hidden = hidden;
    }

    public FieldType getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public static class UnknownSpec
    extends FieldSpec {
        public UnknownSpec(FieldType type, boolean required) {
            this(type, required, false);
        }

        @JsonCreator
        UnknownSpec(@JsonProperty(value="type") FieldType type, @JsonProperty(value="required") boolean required, @JsonProperty(value="hidden", defaultValue="false") boolean hidden) {
            super(type, required, hidden);
        }
    }

    public static class ArrayJsonSpec
    extends JsonSpec {
        @JsonProperty(value="min_size")
        private Integer minSize;
        @JsonProperty(value="max_size")
        private Integer maxSize;

        public ArrayJsonSpec(boolean required) {
            this(required, false);
        }

        @JsonCreator
        public ArrayJsonSpec(@JsonProperty(value="required") boolean required, @JsonProperty(value="hidden", defaultValue="false") boolean hidden) {
            super(FieldType.ARRAY_JSON, required, hidden);
        }

        public Integer getMinSize() {
            return this.minSize;
        }

        public void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public Integer getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }
    }

    public static class JsonSpec
    extends FieldSpec {
        public JsonSpec(boolean required) {
            this(required, false);
        }

        @JsonCreator
        public JsonSpec(@JsonProperty(value="required") boolean required, @JsonProperty(value="hidden", defaultValue="false") boolean hidden) {
            this(FieldType.JSON, required, hidden);
        }

        private JsonSpec(FieldType type, boolean required, boolean hidden) {
            super(type, required, hidden);
        }
    }

    public static class ArrayCoordinatesSpec
    extends CoordinatesSpec {
        @JsonProperty(value="min_size")
        private Integer minSize;
        @JsonProperty(value="max_size")
        private Integer maxSize;

        public ArrayCoordinatesSpec(boolean required) {
            this(required, false);
        }

        @JsonCreator
        public ArrayCoordinatesSpec(@JsonProperty(value="required") boolean required, @JsonProperty(value="hidden", defaultValue="false") boolean hidden) {
            super(FieldType.ARRAY_COORDINATES, required, hidden);
        }

        public Integer getMinSize() {
            return this.minSize;
        }

        public void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public Integer getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }
    }

    public static class CoordinatesSpec
    extends FieldSpec {
        @JsonProperty(value="current_location")
        private Boolean currentLocation;

        public CoordinatesSpec(boolean required) {
            this(required, false);
        }

        public CoordinatesSpec(@JsonProperty(value="required") boolean required, @JsonProperty(value="hidden", defaultValue="false") boolean hidden) {
            this(FieldType.COORDINATES, required, hidden);
        }

        private CoordinatesSpec(FieldType type, boolean required, boolean hidden) {
            super(type, required, hidden);
        }

        public Boolean getCurrentLocation() {
            return this.currentLocation;
        }

        public void setCurrentLocation(Boolean currentLocation) {
            this.currentLocation = currentLocation;
        }
    }

    public static class ArrayFileSpec
    extends FileSpec {
        @JsonProperty(value="min_size")
        private Integer minSize;
        @JsonProperty(value="max_size")
        private Integer maxSize;

        public ArrayFileSpec(boolean required) {
            this(required, false);
        }

        public ArrayFileSpec(@JsonProperty(value="required") boolean required, @JsonProperty(value="hidden", defaultValue="false") boolean hidden) {
            super(FieldType.ARRAY_FILE, required, hidden);
        }

        public Integer getMinSize() {
            return this.minSize;
        }

        public void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public Integer getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }
    }

    public static class FileSpec
    extends FieldSpec {
        public FileSpec(boolean required) {
            this(required, false);
        }

        @JsonCreator
        public FileSpec(@JsonProperty(value="required") boolean required, @JsonProperty(value="hidden", defaultValue="false") boolean hidden) {
            this(FieldType.FILE, required, hidden);
        }

        private FileSpec(FieldType type, boolean required, boolean hidden) {
            super(type, required, hidden);
        }
    }

    public static class ArrayUrlSpec
    extends UrlSpec {
        @JsonProperty(value="min_size")
        private Integer minSize;
        @JsonProperty(value="max_size")
        private Integer maxSize;

        public ArrayUrlSpec(boolean required) {
            this(required, false);
        }

        @JsonCreator
        public ArrayUrlSpec(@JsonProperty(value="required") boolean required, @JsonProperty(value="hidden", defaultValue="false") boolean hidden) {
            super(FieldType.ARRAY_URL, required, hidden);
        }

        public Integer getMinSize() {
            return this.minSize;
        }

        public void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public Integer getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }
    }

    public static class UrlSpec
    extends FieldSpec {
        public UrlSpec(boolean required) {
            this(required, false);
        }

        @JsonCreator
        public UrlSpec(@JsonProperty(value="required") boolean required, @JsonProperty(value="hidden", defaultValue="false") boolean hidden) {
            this(FieldType.URL, required, hidden);
        }

        private UrlSpec(FieldType type, boolean required, boolean hidden) {
            super(type, required, hidden);
        }
    }

    public static class ArrayFloatSpec
    extends FloatSpec {
        @JsonProperty(value="min_size")
        private Integer minSize;
        @JsonProperty(value="max_size")
        private Integer maxSize;

        public ArrayFloatSpec(boolean required) {
            this(required, false);
        }

        @JsonCreator
        public ArrayFloatSpec(@JsonProperty(value="required") boolean required, @JsonProperty(value="hidden", defaultValue="false") boolean hidden) {
            super(FieldType.ARRAY_FLOAT, required, hidden);
        }

        public Integer getMinSize() {
            return this.minSize;
        }

        public void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public Integer getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }
    }

    public static class FloatSpec
    extends FieldSpec {
        @JsonProperty(value="min_value")
        private Double minValue;
        @JsonProperty(value="max_value")
        private Double maxValue;

        public FloatSpec(boolean required) {
            this(required, false);
        }

        @JsonCreator
        public FloatSpec(@JsonProperty(value="required") boolean required, @JsonProperty(value="hidden", defaultValue="false") boolean hidden) {
            this(FieldType.FLOAT, required, hidden);
        }

        private FloatSpec(FieldType type, boolean required, boolean hidden) {
            super(type, required, hidden);
        }

        public Double getMinValue() {
            return this.minValue;
        }

        public void setMinValue(Double minValue) {
            this.minValue = minValue;
        }

        public Double getMaxValue() {
            return this.maxValue;
        }

        public void setMaxValue(Double maxValue) {
            this.maxValue = maxValue;
        }
    }

    public static class ArrayIntegerSpec
    extends IntegerSpec {
        @JsonProperty(value="min_size")
        private Integer minSize;
        @JsonProperty(value="max_size")
        private Integer maxSize;

        public ArrayIntegerSpec(boolean required) {
            this(required, false);
        }

        @JsonCreator
        public ArrayIntegerSpec(@JsonProperty(value="required") boolean required, @JsonProperty(value="hidden", defaultValue="false") boolean hidden) {
            super(FieldType.ARRAY_INTEGER, required, hidden);
        }

        public Integer getMinSize() {
            return this.minSize;
        }

        public void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public Integer getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }
    }

    public static class IntegerSpec
    extends FieldSpec {
        @JsonProperty(value="min_value")
        private Long minValue;
        @JsonProperty(value="max_value")
        private Long maxValue;
        @JsonProperty(value="allowed_values")
        private Set<Long> allowedValues;

        public IntegerSpec(boolean required) {
            this(required, false);
        }

        @JsonCreator
        public IntegerSpec(@JsonProperty(value="required") boolean required, @JsonProperty(value="hidden", defaultValue="false") boolean hidden) {
            super(FieldType.INTEGER, required, hidden);
        }

        private IntegerSpec(FieldType type, boolean required, boolean hidden) {
            super(type, required, hidden);
        }

        public Long getMinValue() {
            return this.minValue;
        }

        public void setMinValue(Long minValue) {
            this.minValue = minValue;
        }

        public Long getMaxValue() {
            return this.maxValue;
        }

        public void setMaxValue(Long maxValue) {
            this.maxValue = maxValue;
        }

        public Set<Long> getAllowedValues() {
            return this.allowedValues;
        }

        public void setAllowedValues(Set<Long> allowedValues) {
            this.allowedValues = allowedValues;
        }
    }

    public static class ArrayStringSpec
    extends StringSpec {
        @JsonProperty(value="min_size")
        private Integer minSize;
        @JsonProperty(value="max_size")
        private Integer maxSize;

        public ArrayStringSpec(boolean required) {
            this(required, false);
        }

        @JsonCreator
        public ArrayStringSpec(@JsonProperty(value="required") boolean required, @JsonProperty(value="hidden", defaultValue="false") boolean hidden) {
            super(FieldType.ARRAY_STRING, required, hidden);
        }

        public Integer getMinSize() {
            return this.minSize;
        }

        public void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public Integer getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }
    }

    public static class StringSpec
    extends FieldSpec {
        @JsonProperty(value="min_length")
        private Integer minLength;
        @JsonProperty(value="max_length")
        private Integer maxLength;
        private String pattern;
        @JsonProperty(value="allowed_values")
        private Set<String> allowedValues;

        public StringSpec(boolean required) {
            this(required, false);
        }

        @JsonCreator
        public StringSpec(@JsonProperty(value="required") boolean required, @JsonProperty(value="hidden", defaultValue="false") boolean hidden) {
            this(FieldType.STRING, required, hidden);
        }

        private StringSpec(FieldType type, boolean required, boolean hidden) {
            super(type, required, hidden);
        }

        public Integer getMinLength() {
            return this.minLength;
        }

        public void setMinLength(Integer minLength) {
            this.minLength = minLength;
        }

        public Integer getMaxLength() {
            return this.maxLength;
        }

        public void setMaxLength(Integer maxLength) {
            this.maxLength = maxLength;
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public Set<String> getAllowedValues() {
            return this.allowedValues;
        }

        public void setAllowedValues(Set<String> allowedValues) {
            this.allowedValues = allowedValues;
        }
    }

    public static class ArrayBooleanSpec
    extends BooleanSpec {
        @JsonProperty(value="min_size")
        private Integer minSize;
        @JsonProperty(value="max_size")
        private Integer maxSize;

        public ArrayBooleanSpec(boolean required) {
            this(required, false);
        }

        @JsonCreator
        public ArrayBooleanSpec(@JsonProperty(value="required") boolean required, @JsonProperty(value="hidden", defaultValue="false") boolean hidden) {
            super(FieldType.ARRAY_BOOLEAN, required, hidden);
        }

        public Integer getMinSize() {
            return this.minSize;
        }

        public void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public Integer getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }
    }

    public static class BooleanSpec
    extends FieldSpec {
        @JsonProperty(value="allowed_values")
        private Set<Boolean> allowedValues;

        public BooleanSpec(boolean required) {
            this(required, false);
        }

        @JsonCreator
        public BooleanSpec(@JsonProperty(value="required") boolean required, @JsonProperty(value="hidden", defaultValue="false") boolean hidden) {
            this(FieldType.BOOLEAN, required, hidden);
        }

        private BooleanSpec(FieldType type, boolean required, boolean hidden) {
            super(type, required, hidden);
        }
    }
}

