/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.skill;

import ai.toloka.client.v1.SearchRequest;
import ai.toloka.client.v1.skill.SkillFilterParam;
import ai.toloka.client.v1.skill.SkillRangeParam;
import ai.toloka.client.v1.skill.SkillSortParam;
import java.util.Date;
import java.util.Map;

public class SkillSearchRequest
extends SearchRequest {
    static final String ID_PARAMETER = "id";
    static final String OWNER_ID_PARAMETER = "owner_id";
    static final String OWNER_COMPANY_ID_PARAMETER = "owner_company_id";
    static final String CREATED_PARAMETER = "created";
    static final String GLOBAL_PARAMETER = "global";

    private SkillSearchRequest(Map<String, Object> filterParameters, Map<String, Object> rangeParameters, String sortParameter, Integer limit) {
        super(filterParameters, rangeParameters, sortParameter, limit);
    }

    public static SkillBuilder make() {
        return new SkillBuilder(new SkillFilterBuilder(), new SkillRangeBuilder(), new SkillSortBuilder());
    }

    public static class SkillSortBuilder
    extends SearchRequest.SortBuilder<SkillSortBuilder, SkillBuilder, SkillSortParam> {
        public SearchRequest.SortBuilder.SortItem<SkillSortBuilder> byId() {
            return this.by(SkillSortParam.id);
        }

        public SearchRequest.SortBuilder.SortItem<SkillSortBuilder> byCreated() {
            return this.by(SkillSortParam.created);
        }
    }

    public static class SkillRangeBuilder
    extends SearchRequest.RangeBuilder<SkillRangeBuilder, SkillBuilder, SkillRangeParam> {
        public SearchRequest.RangeBuilder.RangeItemBuilder<SkillRangeBuilder> byId(String id) {
            return this.by(SkillRangeParam.id, id);
        }

        public SearchRequest.RangeBuilder.RangeItemBuilder<SkillRangeBuilder> byCreated(Date date) {
            return this.by(SkillRangeParam.created, date);
        }
    }

    public static class SkillFilterBuilder
    extends SearchRequest.FilterBuilder<SkillFilterBuilder, SkillBuilder, SkillFilterParam> {
        public SkillFilterBuilder byOwnerId(String ownerId) {
            return (SkillFilterBuilder)this.by(SkillFilterParam.ownerId, ownerId);
        }

        public SkillFilterBuilder byOwnerCompanyId(String ownerCompanyId) {
            return (SkillFilterBuilder)this.by(SkillFilterParam.ownerCompanyId, ownerCompanyId);
        }

        public SkillFilterBuilder byGlobal(Boolean global) {
            return (SkillFilterBuilder)this.by(SkillFilterParam.global, global);
        }
    }

    public static class SkillBuilder
    extends SearchRequest.Builder<SkillSearchRequest, SkillBuilder, SkillFilterBuilder, SkillRangeBuilder, SkillSortBuilder> {
        private SkillBuilder(SkillFilterBuilder filterBuilder, SkillRangeBuilder rangeBuilder, SkillSortBuilder sortBuilder) {
            super(filterBuilder, rangeBuilder, sortBuilder);
        }

        @Override
        public SkillSearchRequest done() {
            return new SkillSearchRequest(((SkillFilterBuilder)this.filterBuilder).getFilterParameters(), ((SkillRangeBuilder)this.rangeBuilder).getRangeParameters(), ((SkillSortBuilder)this.sortBuilder).getSortParameter(), this.getLimit());
        }
    }
}

