/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.task;

import ai.toloka.client.v1.SearchRequest;
import ai.toloka.client.v1.task.TaskFilterParam;
import ai.toloka.client.v1.task.TaskRangeParam;
import ai.toloka.client.v1.task.TaskSortParam;
import java.util.Date;
import java.util.Map;

public class TaskSearchRequest
extends SearchRequest {
    static final String OWNER_ID_PARAMETER = "owner_id";
    static final String OWNER_COMPANY_ID_PARAMETER = "owner_company_id";
    static final String ID_PARAMETER = "id";
    static final String CREATED_PARAMETER = "created";
    static final String POOL_ID_PARAMETER = "pool_id";
    static final String OVERLAP = "overlap";

    private TaskSearchRequest(Map<String, Object> filterParameters, Map<String, Object> rangeParameters, String sortParameter, Integer limit) {
        super(filterParameters, rangeParameters, sortParameter, limit);
    }

    public static TaskBuilder make() {
        return new TaskBuilder(new TaskFilterBuilder(), new TaskRangeBuilder(), new TaskSortBuilder());
    }

    public static class TaskSortBuilder
    extends SearchRequest.SortBuilder<TaskSortBuilder, TaskBuilder, TaskSortParam> {
        public SearchRequest.SortBuilder.SortItem<TaskSortBuilder> byId() {
            return this.by(TaskSortParam.id);
        }

        public SearchRequest.SortBuilder.SortItem<TaskSortBuilder> byCreated() {
            return this.by(TaskSortParam.created);
        }
    }

    public static class TaskRangeBuilder
    extends SearchRequest.RangeBuilder<TaskRangeBuilder, TaskBuilder, TaskRangeParam> {
        public SearchRequest.RangeBuilder.RangeItemBuilder<TaskRangeBuilder> byId(String id) {
            return this.by(TaskRangeParam.id, id);
        }

        public SearchRequest.RangeBuilder.RangeItemBuilder<TaskRangeBuilder> byCreated(Date created) {
            return this.by(TaskRangeParam.created, created);
        }

        public SearchRequest.RangeBuilder.RangeItemBuilder<TaskRangeBuilder> byOverlap(Integer overlap) {
            return this.by(TaskRangeParam.overlap, overlap);
        }
    }

    public static class TaskFilterBuilder
    extends SearchRequest.FilterBuilder<TaskFilterBuilder, TaskBuilder, TaskFilterParam> {
        public TaskFilterBuilder byOwnerId(String ownerId) {
            return (TaskFilterBuilder)this.by(TaskFilterParam.ownerId, ownerId);
        }

        public TaskFilterBuilder byOwnerCompanyId(String companyId) {
            return (TaskFilterBuilder)this.by(TaskFilterParam.ownerCompanyId, companyId);
        }

        public TaskFilterBuilder byPoolId(String poolId) {
            return (TaskFilterBuilder)this.by(TaskFilterParam.poolId, poolId);
        }

        public TaskFilterBuilder byOverlap(Integer overlap) {
            return (TaskFilterBuilder)this.by(TaskFilterParam.overlap, overlap);
        }
    }

    public static class TaskBuilder
    extends SearchRequest.Builder<TaskSearchRequest, TaskBuilder, TaskFilterBuilder, TaskRangeBuilder, TaskSortBuilder> {
        private TaskBuilder(TaskFilterBuilder filterBuilder, TaskRangeBuilder rangeBuilder, TaskSortBuilder sortBuilder) {
            super(filterBuilder, rangeBuilder, sortBuilder);
        }

        @Override
        public TaskSearchRequest done() {
            return new TaskSearchRequest(((TaskFilterBuilder)this.filterBuilder).getFilterParameters(), ((TaskRangeBuilder)this.rangeBuilder).getRangeParameters(), ((TaskSortBuilder)this.sortBuilder).getSortParameter(), this.getLimit());
        }
    }
}

