/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.tasksuite;

import ai.toloka.client.v1.SearchRequest;
import ai.toloka.client.v1.tasksuite.TaskSuiteFilterParam;
import ai.toloka.client.v1.tasksuite.TaskSuiteRangeParam;
import ai.toloka.client.v1.tasksuite.TaskSuiteSortParam;
import java.util.Date;
import java.util.Map;

public class TaskSuiteSearchRequest
extends SearchRequest {
    static final String OWNER_ID_PARAMETER = "owner_id";
    static final String OWNER_COMPANY_ID_PARAMETER = "owner_company_id";
    static final String TASK_ID_PARAMETER = "task_id";
    static final String POOL_ID_PARAMETER = "pool_id";
    static final String OVERLAP = "overlap";
    static final String ID_PARAMETER = "id";
    static final String CREATED_PARAMETER = "created";

    private TaskSuiteSearchRequest(Map<String, Object> filterParameters, Map<String, Object> rangeParameters, String sortParameter, Integer limit) {
        super(filterParameters, rangeParameters, sortParameter, limit);
    }

    public static TaskSuiteBuilder make() {
        return new TaskSuiteBuilder(new TaskSuiteFilterBuilder(), new TaskSuiteRangeBuilder(), new TaskSuiteSortBuilder());
    }

    public static class TaskSuiteSortBuilder
    extends SearchRequest.SortBuilder<TaskSuiteSortBuilder, TaskSuiteBuilder, TaskSuiteSortParam> {
        public SearchRequest.SortBuilder.SortItem<TaskSuiteSortBuilder> byId() {
            return this.by(TaskSuiteSortParam.id);
        }

        public SearchRequest.SortBuilder.SortItem<TaskSuiteSortBuilder> byCreated() {
            return this.by(TaskSuiteSortParam.created);
        }
    }

    public static class TaskSuiteRangeBuilder
    extends SearchRequest.RangeBuilder<TaskSuiteRangeBuilder, TaskSuiteBuilder, TaskSuiteRangeParam> {
        public SearchRequest.RangeBuilder.RangeItemBuilder<TaskSuiteRangeBuilder> byId(String id) {
            return this.by(TaskSuiteRangeParam.id, id);
        }

        public SearchRequest.RangeBuilder.RangeItemBuilder<TaskSuiteRangeBuilder> byCreated(Date created) {
            return this.by(TaskSuiteRangeParam.created, created);
        }

        public SearchRequest.RangeBuilder.RangeItemBuilder<TaskSuiteRangeBuilder> byOverlap(Integer overlap) {
            return this.by(TaskSuiteRangeParam.overlap, overlap);
        }
    }

    public static class TaskSuiteFilterBuilder
    extends SearchRequest.FilterBuilder<TaskSuiteFilterBuilder, TaskSuiteBuilder, TaskSuiteFilterParam> {
        public TaskSuiteFilterBuilder byOwnerId(String ownerId) {
            return (TaskSuiteFilterBuilder)this.by(TaskSuiteFilterParam.owner_id, ownerId);
        }

        public TaskSuiteFilterBuilder byOwnerCompanyId(String companyId) {
            return (TaskSuiteFilterBuilder)this.by(TaskSuiteFilterParam.owner_company_id, companyId);
        }

        public TaskSuiteFilterBuilder byTaskId(String taskId) {
            return (TaskSuiteFilterBuilder)this.by(TaskSuiteFilterParam.task_id, taskId);
        }

        public TaskSuiteFilterBuilder byPoolId(String poolId) {
            return (TaskSuiteFilterBuilder)this.by(TaskSuiteFilterParam.pool_id, poolId);
        }

        public TaskSuiteFilterBuilder byOverlap(Integer overlap) {
            return (TaskSuiteFilterBuilder)this.by(TaskSuiteFilterParam.overlap, overlap);
        }
    }

    public static class TaskSuiteBuilder
    extends SearchRequest.Builder<TaskSuiteSearchRequest, TaskSuiteBuilder, TaskSuiteFilterBuilder, TaskSuiteRangeBuilder, TaskSuiteSortBuilder> {
        public TaskSuiteBuilder(TaskSuiteFilterBuilder filterBuilder, TaskSuiteRangeBuilder rangeBuilder, TaskSuiteSortBuilder sortBuilder) {
            super(filterBuilder, rangeBuilder, sortBuilder);
        }

        @Override
        public TaskSuiteSearchRequest done() {
            return new TaskSuiteSearchRequest(((TaskSuiteFilterBuilder)this.filterBuilder).getFilterParameters(), ((TaskSuiteRangeBuilder)this.rangeBuilder).getRangeParameters(), ((TaskSuiteSortBuilder)this.sortBuilder).getSortParameter(), this.getLimit());
        }
    }
}

