/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.training;

import ai.toloka.client.v1.SearchRequest;
import ai.toloka.client.v1.training.TrainingFilterParam;
import ai.toloka.client.v1.training.TrainingRangeParam;
import ai.toloka.client.v1.training.TrainingSortParam;
import ai.toloka.client.v1.training.TrainingStatus;
import java.util.Date;
import java.util.Map;

public class TrainingSearchRequest
extends SearchRequest {
    static final String OWNER_ID_PARAMETER = "owner_id";
    static final String OWNER_COMPANY_ID_PARAMETER = "owner_company_id";
    static final String STATUS_PARAMETER = "status";
    static final String PROJECT_ID_PARAMETER = "project_id";
    static final String ID_PARAMETER = "id";
    static final String CREATED_PARAMETER = "created";
    static final String LAST_STARTED_PARAMETER = "last_started";

    public TrainingSearchRequest(Map<String, Object> filterParameters, Map<String, Object> rangeParameters, String sortParameter, Integer limit) {
        super(filterParameters, rangeParameters, sortParameter, limit);
    }

    public static TrainingBuilder make() {
        return new TrainingBuilder(new TrainingFilterBuilder(), new TrainingRangeBuilder(), new TrainingSortBuilder());
    }

    public static class TrainingSortBuilder
    extends SearchRequest.SortBuilder<TrainingSortBuilder, TrainingBuilder, TrainingSortParam> {
        public SearchRequest.SortBuilder.SortItem<TrainingSortBuilder> byId() {
            return this.by(TrainingSortParam.id);
        }

        public SearchRequest.SortBuilder.SortItem<TrainingSortBuilder> byCreated() {
            return this.by(TrainingSortParam.created);
        }

        public SearchRequest.SortBuilder.SortItem<TrainingSortBuilder> byLastStarted() {
            return this.by(TrainingSortParam.lastStarted);
        }
    }

    public static class TrainingRangeBuilder
    extends SearchRequest.RangeBuilder<TrainingRangeBuilder, TrainingBuilder, TrainingRangeParam> {
        public SearchRequest.RangeBuilder.RangeItemBuilder<TrainingRangeBuilder> byId(String id) {
            return this.by(TrainingRangeParam.id, id);
        }

        public SearchRequest.RangeBuilder.RangeItemBuilder<TrainingRangeBuilder> byCreated(Date created) {
            return this.by(TrainingRangeParam.created, created);
        }

        public SearchRequest.RangeBuilder.RangeItemBuilder<TrainingRangeBuilder> byLastStarted(Date lastStarted) {
            return this.by(TrainingRangeParam.lastStarted, lastStarted);
        }
    }

    public static class TrainingFilterBuilder
    extends SearchRequest.FilterBuilder<TrainingFilterBuilder, TrainingBuilder, TrainingFilterParam> {
        public TrainingFilterBuilder byOwnerId(String ownerId) {
            return (TrainingFilterBuilder)this.by(TrainingFilterParam.ownerId, ownerId);
        }

        public TrainingFilterBuilder byOwnerCompanyId(String companyId) {
            return (TrainingFilterBuilder)this.by(TrainingFilterParam.ownerCompanyId, companyId);
        }

        public TrainingFilterBuilder byStatus(TrainingStatus status) {
            return (TrainingFilterBuilder)this.by(TrainingFilterParam.status, status);
        }

        public TrainingFilterBuilder byProjectId(String projectId) {
            return (TrainingFilterBuilder)this.by(TrainingFilterParam.projectId, projectId);
        }
    }

    public static class TrainingBuilder
    extends SearchRequest.Builder<TrainingSearchRequest, TrainingBuilder, TrainingFilterBuilder, TrainingRangeBuilder, TrainingSortBuilder> {
        public TrainingBuilder(TrainingFilterBuilder filterBuilder, TrainingRangeBuilder rangeBuilder, TrainingSortBuilder sortBuilder) {
            super(filterBuilder, rangeBuilder, sortBuilder);
        }

        @Override
        public TrainingSearchRequest done() {
            return new TrainingSearchRequest(((TrainingFilterBuilder)this.filterBuilder).getFilterParameters(), ((TrainingRangeBuilder)this.rangeBuilder).getRangeParameters(), ((TrainingSortBuilder)this.sortBuilder).getSortParameter(), this.getLimit());
        }
    }
}

