/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.userskill;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class UserSkill {
    private String id;
    @JsonProperty(value="skill_id")
    private String skillId;
    @JsonProperty(value="user_id")
    private String userId;
    private Integer value;
    @JsonProperty(value="exact_value")
    private BigDecimal exactValue;
    private Date created;
    private Date modified;

    @JsonCreator
    public UserSkill(@JsonProperty(value="skill_id") String skillId, @JsonProperty(value="user_id") String userId, @JsonProperty(value="value") Integer value) {
        this.skillId = skillId;
        this.userId = userId;
        this.setValue(value);
    }

    public void setValue(Integer value) {
        this.value = value;
        this.exactValue = value == null ? null : BigDecimal.valueOf(value.intValue());
    }

    public static UserSkill valueOf(String skillId, String userId, BigDecimal exactValue) {
        return new UserSkill(skillId, userId, exactValue);
    }

    private UserSkill(String skillId, String userId, BigDecimal exactValue) {
        this.skillId = skillId;
        this.userId = userId;
        this.setExactValue(exactValue);
    }

    public void setExactValue(BigDecimal exactValue) {
        this.value = exactValue == null ? null : Integer.valueOf(exactValue.setScale(0, RoundingMode.HALF_UP).intValueExact());
        this.exactValue = exactValue;
    }

    public String getId() {
        return this.id;
    }

    public String getSkillId() {
        return this.skillId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Integer getValue() {
        return this.value;
    }

    public BigDecimal getExactValue() {
        return this.exactValue;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getModified() {
        return this.modified;
    }
}

