/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.webhooksubscription.utils;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SignatureValidator {
    private static final String ALGORITHM = "HmacSHA256";

    public static String generateSignature(String secretKey, Long ts, Integer v, String requestPayload) throws NoSuchAlgorithmException, InvalidKeyException {
        String data = ts + "." + v + "." + requestPayload;
        return SignatureValidator.doHmac(secretKey, data);
    }

    private static String doHmac(String secretKey, String data) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac macAlgorithm = Mac.getInstance(ALGORITHM);
        SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getBytes(StandardCharsets.UTF_8), ALGORITHM);
        macAlgorithm.init(secretKeySpec);
        return SignatureValidator.encodeHex(macAlgorithm.doFinal(data.getBytes(StandardCharsets.UTF_8)));
    }

    private static String encodeHex(byte[] data) {
        return String.format("%040x", new BigInteger(1, data));
    }
}

