/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.execute;

import ai.tripl.arc.api.API;
import ai.tripl.arc.execute.CassandraExecute;
import ai.tripl.arc.execute.CassandraExecuteStage;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.SQLUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.CassandraConnector$;
import com.datastax.spark.connector.cql.CassandraConnectorConf;
import com.datastax.spark.connector.cql.CassandraConnectorConf$;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URI;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.mutable.Map;
import scala.util.control.NonFatal$;

public final class CassandraExecuteStage$
implements scala.Serializable {
    public static CassandraExecuteStage$ MODULE$;

    static {
        new CassandraExecuteStage$();
    }

    private Option<InetAddress> resolveHost(String hostName) {
        Some some;
        try {
            some = new Some((Object)InetAddress.getByName(hostName));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    public Option<Dataset<Row>> execute(CassandraExecuteStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        String sql = SQLUtils$.MODULE$.injectParameters(stage.sql(), stage.sqlParams(), false, logger);
        stage.stageDetail().put((Object)"sql", (Object)sql);
        try {
            SparkConf sparkConf = spark.sparkContext().getConf();
            stage.params().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                SparkConf sparkConf = sparkConf.set(key, value);
                return sparkConf;
            });
            CassandraConnectorConf cassandraConnectorConf = CassandraConnectorConf$.MODULE$.fromSparkConf(sparkConf);
            CassandraConnector connection = CassandraConnector$.MODULE$.apply(cassandraConnectorConf);
            connection.withSessionDo((Function1 & Serializable & scala.Serializable)session -> session.execute(sql));
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$1.stageDetail();
                }
            };
        }
        return None$.MODULE$;
    }

    public CassandraExecuteStage apply(CassandraExecute plugin, Option<String> id, String name, Option<String> description, URI inputURI, String sql, scala.collection.immutable.Map<String, String> sqlParams, scala.collection.immutable.Map<String, String> params) {
        return new CassandraExecuteStage(plugin, id, name, description, inputURI, sql, sqlParams, params);
    }

    public Option<Tuple8<CassandraExecute, Option<String>, String, Option<String>, URI, String, scala.collection.immutable.Map<String, String>, scala.collection.immutable.Map<String, String>>> unapply(CassandraExecuteStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple8((Object)x$0.plugin(), x$0.id(), (Object)x$0.name(), x$0.description(), (Object)x$0.inputURI(), (Object)x$0.sql(), x$0.sqlParams(), x$0.params()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CassandraExecuteStage$() {
        MODULE$ = this;
    }
}

