/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.jupyter;

import ai.tripl.arc.util.log.logger.Logger;
import almond.interpreter.api.OutputHandler;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.compat.Platform$;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001B\u0001\u0003\u0005-\u0011Q\u0003\u0015:pOJ,7o]*qCJ\\G*[:uK:,'O\u0003\u0002\u0004\t\u00059!.\u001e9zi\u0016\u0014(BA\u0003\u0007\u0003\r\t'o\u0019\u0006\u0003\u000f!\tQ\u0001\u001e:ja2T\u0011!C\u0001\u0003C&\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011QBF\u0007\u0002\u001d)\u0011q\u0002E\u0001\ng\u000eDW\rZ;mKJT!!\u0005\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005M!\u0012AB1qC\u000eDWMC\u0001\u0016\u0003\ry'oZ\u0005\u0003/9\u0011Qb\u00159be.d\u0015n\u001d;f]\u0016\u0014\b\u0002C\r\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u0017\u0015DXmY;uS>t\u0017\n\u001a\t\u00037\u0005r!\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0012$\u0005\u0019\u0019FO]5oO*\u0011\u0001%\b\u0005\tK\u0001\u0011\t\u0011)A\u0005M\u0005a\u0011n\u001d&vaf$XM\u001d'bEB\u0011AdJ\u0005\u0003Qu\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005+\u0001\t\u0005\t\u0015a\u0003,\u00035yW\u000f\u001e9vi\"\u000bg\u000e\u001a7feB\u0011AfM\u0007\u0002[)\u0011afL\u0001\u0004CBL'B\u0001\u00192\u0003-Ig\u000e^3saJ,G/\u001a:\u000b\u0003I\na!\u00197n_:$\u0017B\u0001\u001b.\u00055yU\u000f\u001e9vi\"\u000bg\u000e\u001a7fe\"Aa\u0007\u0001B\u0001B\u0003-q'\u0001\u0004m_\u001e<WM\u001d\t\u0003qyj\u0011!\u000f\u0006\u0003miR!a\u000f\u001f\u0002\u00071|wM\u0003\u0002>\t\u0005!Q\u000f^5m\u0013\ty\u0014H\u0001\u0004M_\u001e<WM\u001d\u0005\u0006\u0003\u0002!\tAQ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\rC\u0015\nF\u0002E\r\u001e\u0003\"!\u0012\u0001\u000e\u0003\tAQA\u000b!A\u0004-BQA\u000e!A\u0004]BQ!\u0007!A\u0002iAQ!\n!A\u0002\u0019Bqa\u0013\u0001C\u0002\u0013\u0005A*A\u0005sCR,G*[7jiV\tQ\n\u0005\u0002\u001d\u001d&\u0011q*\b\u0002\u0005\u0019>tw\r\u0003\u0004R\u0001\u0001\u0006I!T\u0001\u000be\u0006$X\rT5nSR\u0004\u0003bB*\u0001\u0001\u0004%\t\u0001V\u0001\nSN\u0014VO\u001c8j]\u001e,\u0012!\u0016\t\u0003-zk\u0011a\u0016\u0006\u00031f\u000ba!\u0019;p[&\u001c'B\u0001.\\\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003{qS\u0011!X\u0001\u0005U\u00064\u0018-\u0003\u0002`/\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:Dq!\u0019\u0001A\u0002\u0013\u0005!-A\u0007jgJ+hN\\5oO~#S-\u001d\u000b\u0003G\u001a\u0004\"\u0001\b3\n\u0005\u0015l\"\u0001B+oSRDqa\u001a1\u0002\u0002\u0003\u0007Q+A\u0002yIEBa!\u001b\u0001!B\u0013)\u0016AC5t%Vtg.\u001b8hA!91\u000e\u0001a\u0001\n\u0003a\u0015\u0001\u00047bgR\u001cFo\u001c9US6,\u0007bB7\u0001\u0001\u0004%\tA\\\u0001\u0011Y\u0006\u001cHo\u0015;paRKW.Z0%KF$\"aY8\t\u000f\u001dd\u0017\u0011!a\u0001\u001b\"1\u0011\u000f\u0001Q!\n5\u000bQ\u0002\\1tiN#x\u000e\u001d+j[\u0016\u0004\u0003bB:\u0001\u0005\u0004%\t\u0001^\u0001\t]VlG+Y:lgV\tQ\u000f\u0005\u0002Wm&\u0011qo\u0016\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\t\re\u0004\u0001\u0015!\u0003v\u0003%qW/\u001c+bg.\u001c\b\u0005C\u0004|\u0001\t\u0007I\u0011\u0001;\u0002\u0019M$\u0018M\u001d;fIR\u000b7o[:\t\ru\u0004\u0001\u0015!\u0003v\u00035\u0019H/\u0019:uK\u0012$\u0016m]6tA!9q\u0010\u0001b\u0001\n\u0003!\u0018!\u00033p]\u0016$\u0016m]6t\u0011\u001d\t\u0019\u0001\u0001Q\u0001\nU\f!\u0002Z8oKR\u000b7o[:!\u0011\u001d\t9\u0001\u0001C!\u0003\u0013\t\u0001c\u001c8Ti\u0006<WmU;c[&$H/\u001a3\u0015\u0007\r\fY\u0001\u0003\u0005\u0002\u000e\u0005\u0015\u0001\u0019AA\b\u00039\u0019H/Y4f'V\u0014W.\u001b;uK\u0012\u00042!DA\t\u0013\r\t\u0019B\u0004\u0002\u001c'B\f'o\u001b'jgR,g.\u001a:Ti\u0006<WmU;c[&$H/\u001a3\t\u000f\u0005]\u0001\u0001\"\u0011\u0002\u001a\u0005\u0001rN\\*uC\u001e,7i\\7qY\u0016$X\r\u001a\u000b\u0004G\u0006m\u0001\u0002CA\u000f\u0003+\u0001\r!a\b\u0002\u001dM$\u0018mZ3D_6\u0004H.\u001a;fIB\u0019Q\"!\t\n\u0007\u0005\rbBA\u000eTa\u0006\u00148\u000eT5ti\u0016tWM]*uC\u001e,7i\\7qY\u0016$X\r\u001a\u0005\b\u0003O\u0001A\u0011IA\u0015\u0003-yg\u000eV1tWN#\u0018M\u001d;\u0015\u0007\r\fY\u0003\u0003\u0005\u0002.\u0005\u0015\u0002\u0019AA\u0018\u0003%!\u0018m]6Ti\u0006\u0014H\u000fE\u0002\u000e\u0003cI1!a\r\u000f\u0005Y\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8feR\u000b7o[*uCJ$\bbBA\u001c\u0001\u0011\u0005\u0013\u0011H\u0001\n_:$\u0016m]6F]\u0012$2aYA\u001e\u0011!\ti$!\u000eA\u0002\u0005}\u0012a\u0002;bg.,e\u000e\u001a\t\u0004\u001b\u0005\u0005\u0013bAA\"\u001d\t!2\u000b]1sW2K7\u000f^3oKJ$\u0016m]6F]\u0012Dq!a\u0012\u0001\t\u0003\nI%\u0001\u0006p]*{'m\u0015;beR$2aYA&\u0011!\ti%!\u0012A\u0002\u0005=\u0013\u0001\u00036pEN#\u0018M\u001d;\u0011\u00075\t\t&C\u0002\u0002T9\u0011Qc\u00159be.d\u0015n\u001d;f]\u0016\u0014(j\u001c2Ti\u0006\u0014H\u000fC\u0004\u0002X\u0001!\t%!\u0017\u0002\u0011=t'j\u001c2F]\u0012$2aYA.\u0011!\ti&!\u0016A\u0002\u0005}\u0013A\u00026pE\u0016sG\rE\u0002\u000e\u0003CJ1!a\u0019\u000f\u0005M\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8fe*{'-\u00128e\u0011\u001d\t9\u0007\u0001C\u0001\u0003S\nA!\u001b8jiR\u0011\u00111\u000e\u000b\u0004G\u00065\u0004B\u0002\u0016\u0002f\u0001\u000f1\u0006C\u0004\u0002r\u0001!\t!a\u001d\u0002\u000b\u0015\u0014(o\u001c:\u0015\u0005\u0005UDcA2\u0002x!1!&a\u001cA\u0004-Bq!a\u001f\u0001\t\u0003\ti(\u0001\u0004va\u0012\fG/\u001a\u000b\u0007\u0003\u007f\n\u0019)!\"\u0015\u0007\r\f\t\t\u0003\u0004+\u0003s\u0002\u001da\u000b\u0005\b\u0003c\nI\b1\u0001'\u0011\u001d\t9)!\u001fA\u0002\u0019\naB]3n_Z,G*[:uK:,'\u000fC\u0004\u0002\f\u0002!\t!!$\u0002#I\fG/\u001a'j[&$X\rZ+qI\u0006$X\r\u0006\u0002\u0002\u0010R\u00191-!%\t\r)\nI\tq\u0001,\u0001")
public final class ProgressSparkListener
extends SparkListener {
    private final String executionId;
    private final boolean isJupyterLab;
    private final OutputHandler outputHandler;
    private final Logger logger;
    private final long rateLimit;
    private AtomicBoolean isRunning;
    private long lastStopTime;
    private final AtomicInteger numTasks;
    private final AtomicInteger startedTasks;
    private final AtomicInteger doneTasks;

    public long rateLimit() {
        return this.rateLimit;
    }

    public AtomicBoolean isRunning() {
        return this.isRunning;
    }

    public void isRunning_$eq(AtomicBoolean x$1) {
        this.isRunning = x$1;
    }

    public long lastStopTime() {
        return this.lastStopTime;
    }

    public void lastStopTime_$eq(long x$1) {
        this.lastStopTime = x$1;
    }

    public AtomicInteger numTasks() {
        return this.numTasks;
    }

    public AtomicInteger startedTasks() {
        return this.startedTasks;
    }

    public AtomicInteger doneTasks() {
        return this.doneTasks;
    }

    public void onStageSubmitted(SparkListenerStageSubmitted stageSubmitted) {
        this.logger.debug().message("onStageSubmitted").field("stageId", (Object)stageSubmitted.stageInfo().stageId()).field("numTasks", (Object)BoxesRunTime.boxToInteger((int)stageSubmitted.stageInfo().numTasks())).log();
        this.numTasks().addAndGet(stageSubmitted.stageInfo().numTasks());
        this.rateLimitedUpdate(this.outputHandler);
    }

    public void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
        this.logger.debug().message("onStageCompleted").field("stageId", (Object)stageCompleted.stageInfo().stageId()).log();
        this.rateLimitedUpdate(this.outputHandler);
    }

    public void onTaskStart(SparkListenerTaskStart taskStart) {
        this.logger.debug().message("taskStart").field("stageId", (Object)taskStart.stageId()).field("taskId", (Object)taskStart.taskInfo().taskId()).log();
        this.startedTasks().incrementAndGet();
        this.rateLimitedUpdate(this.outputHandler);
    }

    public void onTaskEnd(SparkListenerTaskEnd taskEnd) {
        this.logger.debug().message("taskEnd").field("stageId", (Object)taskEnd.stageId()).field("taskId", (Object)taskEnd.taskInfo().taskId()).log();
        this.doneTasks().incrementAndGet();
        this.rateLimitedUpdate(this.outputHandler);
    }

    public void onJobStart(SparkListenerJobStart jobStart) {
        this.logger.debug().message("onJobStart").field("jobId", (Object)jobStart.jobId()).log();
    }

    public void onJobEnd(SparkListenerJobEnd jobEnd) {
        this.logger.debug().message("onJobEnd").field("jobId", (Object)jobEnd.jobId()).log();
    }

    public void init(OutputHandler outputHandler) {
        outputHandler.html(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<div class=\"progress arc-background\">\n        |  <div class=\"progress-bar arc-complete\" style=\"width: 0%;\">0 / 0</div>\n        |</div>\n        |"})).s((Seq)Nil$.MODULE$))).stripMargin(), this.executionId);
    }

    public void error(OutputHandler outputHandler) {
        this.update(true, false, outputHandler);
    }

    public void update(boolean error, boolean removeListener, OutputHandler outputHandler) {
        String statusClass;
        int numTasksSnapshot = this.numTasks().get();
        int doneTasksSnapshot = this.doneTasks().get();
        int startedTasksSnapshot = this.startedTasks().get();
        if (removeListener) {
            doneTasksSnapshot = numTasksSnapshot;
            startedTasksSnapshot = 0;
        }
        int runningTasks = Math.max(startedTasksSnapshot - doneTasksSnapshot, 0);
        double donePct = Math.min(100.0 * (double)doneTasksSnapshot / (double)numTasksSnapshot, 100.0);
        double runningPct = Math.min(100.0 * (double)runningTasks / (double)numTasksSnapshot, 100.0);
        String statusText = doneTasksSnapshot == numTasksSnapshot || error ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)doneTasksSnapshot), BoxesRunTime.boxToInteger((int)numTasksSnapshot)})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", " (", " running)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)doneTasksSnapshot), BoxesRunTime.boxToInteger((int)numTasksSnapshot), BoxesRunTime.boxToInteger((int)runningTasks)}));
        String string = statusClass = error ? "error" : "";
        if (this.isJupyterLab) {
            if (removeListener) {
                if (error) {
                    outputHandler.updateHtml(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<div class=\"progress\">\n                |  <div class=\"progress-bar-danger\" style=\"width: ", "%;\">", "</div>\n                |</div>\n                |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)donePct), statusText})))).stripMargin(), this.executionId);
                } else {
                    outputHandler.updateHtml(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<div class=\"progress\">\n                |  <div class=\"progress-bar-success\" style=\"width: ", "%;\">", "</div>\n                |</div>\n                |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)donePct), statusText})))).stripMargin(), this.executionId);
                }
            } else {
                outputHandler.updateHtml(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<div class=\"progress\">\n              |  <div class=\"progress-bar-info\" style=\"width: ", "%;\">", "</div>\n              |</div>\n              |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)donePct), statusText})))).stripMargin(), this.executionId);
            }
        } else {
            outputHandler.updateHtml(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<div class=\"progress arc-background\">\n            |  <div class=\"progress-bar arc-complete ", "\" style=\"width: ", "%;\">", "</div>\n            |  <div class=\"progress-bar arc-running ", "\" style=\"width: ", "%;\"></div>\n            |</div>\n            |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{statusClass, BoxesRunTime.boxToDouble((double)donePct), statusText, statusClass, BoxesRunTime.boxToDouble((double)runningPct)})))).stripMargin(), this.executionId);
        }
    }

    public void rateLimitedUpdate(OutputHandler outputHandler) {
        boolean doneWaiting;
        boolean bl = doneWaiting = this.lastStopTime() + this.rateLimit() <= Platform$.MODULE$.currentTime();
        if (this.isRunning().compareAndSet(false, doneWaiting) && doneWaiting) {
            this.update(false, false, outputHandler);
        }
        return;
        finally {
            this.lastStopTime_$eq(Platform$.MODULE$.currentTime());
            this.isRunning().set(false);
        }
    }

    public ProgressSparkListener(String executionId, boolean isJupyterLab, OutputHandler outputHandler, Logger logger) {
        this.executionId = executionId;
        this.isJupyterLab = isJupyterLab;
        this.outputHandler = outputHandler;
        this.logger = logger;
        this.rateLimit = Duration$.MODULE$.apply(200L, TimeUnit.MILLISECONDS).toMillis();
        this.isRunning = new AtomicBoolean(false);
        this.lastStopTime = Long.MIN_VALUE;
        this.numTasks = new AtomicInteger();
        this.startedTasks = new AtomicInteger();
        this.doneTasks = new AtomicInteger();
    }
}

