/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.jupyter;

import almond.interpreter.api.OutputHandler;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.compat.Platform$;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\u0001\u0003\u0005-\u0011Q\u0003\u0015:pOJ,7o]*qCJ\\G*[:uK:,'O\u0003\u0002\u0004\t\u00059!.\u001e9zi\u0016\u0014(BA\u0003\u0007\u0003\r\t'o\u0019\u0006\u0003\u000f!\tQ\u0001\u001e:ja2T\u0011!C\u0001\u0003C&\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011QBF\u0007\u0002\u001d)\u0011q\u0002E\u0001\ng\u000eDW\rZ;mKJT!!\u0005\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005M!\u0012AB1qC\u000eDWMC\u0001\u0016\u0003\ry'oZ\u0005\u0003/9\u0011Qb\u00159be.d\u0015n\u001d;f]\u0016\u0014\b\u0002C\r\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u0017\u0015DXmY;uS>t\u0017\n\u001a\t\u00037\u0005r!\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0012$\u0005\u0019\u0019FO]5oO*\u0011\u0001%\b\u0005\tK\u0001\u0011\t\u0011)A\u0006M\u0005iq.\u001e;qkRD\u0015M\u001c3mKJ\u0004\"a\n\u0018\u000e\u0003!R!!\u000b\u0016\u0002\u0007\u0005\u0004\u0018N\u0003\u0002,Y\u0005Y\u0011N\u001c;feB\u0014X\r^3s\u0015\u0005i\u0013AB1m[>tG-\u0003\u00020Q\tiq*\u001e;qkRD\u0015M\u001c3mKJDQ!\r\u0001\u0005\u0002I\na\u0001P5oSRtDCA\u001a8)\t!d\u0007\u0005\u00026\u00015\t!\u0001C\u0003&a\u0001\u000fa\u0005C\u0003\u001aa\u0001\u0007!\u0004C\u0004:\u0001\t\u0007I\u0011\u0001\u001e\u0002\u0013I\fG/\u001a'j[&$X#A\u001e\u0011\u0005qa\u0014BA\u001f\u001e\u0005\u0011auN\\4\t\r}\u0002\u0001\u0015!\u0003<\u0003)\u0011\u0018\r^3MS6LG\u000f\t\u0005\b\u0003\u0002\u0001\r\u0011\"\u0001C\u0003%I7OU;o]&tw-F\u0001D!\t!U*D\u0001F\u0015\t1u)\u0001\u0004bi>l\u0017n\u0019\u0006\u0003\u0011&\u000b!bY8oGV\u0014(/\u001a8u\u0015\tQ5*\u0001\u0003vi&d'\"\u0001'\u0002\t)\fg/Y\u0005\u0003\u001d\u0016\u0013Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007b\u0002)\u0001\u0001\u0004%\t!U\u0001\u000eSN\u0014VO\u001c8j]\u001e|F%Z9\u0015\u0005I+\u0006C\u0001\u000fT\u0013\t!VD\u0001\u0003V]&$\bb\u0002,P\u0003\u0003\u0005\raQ\u0001\u0004q\u0012\n\u0004B\u0002-\u0001A\u0003&1)\u0001\u0006jgJ+hN\\5oO\u0002BqA\u0017\u0001A\u0002\u0013\u0005!(\u0001\u0007mCN$8\u000b^8q)&lW\rC\u0004]\u0001\u0001\u0007I\u0011A/\u0002!1\f7\u000f^*u_B$\u0016.\\3`I\u0015\fHC\u0001*_\u0011\u001d16,!AA\u0002mBa\u0001\u0019\u0001!B\u0013Y\u0014!\u00047bgR\u001cFo\u001c9US6,\u0007\u0005C\u0004c\u0001\t\u0007I\u0011A2\u0002\u00119,X\u000eV1tWN,\u0012\u0001\u001a\t\u0003\t\u0016L!AZ#\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0011\u0019A\u0007\u0001)A\u0005I\u0006Ia.^7UCN\\7\u000f\t\u0005\bU\u0002\u0011\r\u0011\"\u0001d\u00031\u0019H/\u0019:uK\u0012$\u0016m]6t\u0011\u0019a\u0007\u0001)A\u0005I\u0006i1\u000f^1si\u0016$G+Y:lg\u0002BqA\u001c\u0001C\u0002\u0013\u00051-A\u0005e_:,G+Y:lg\"1\u0001\u000f\u0001Q\u0001\n\u0011\f!\u0002Z8oKR\u000b7o[:!\u0011\u0015\u0011\b\u0001\"\u0011t\u0003Aygn\u0015;bO\u0016\u001cVOY7jiR,G\r\u0006\u0002Si\")Q/\u001da\u0001m\u0006q1\u000f^1hKN+(-\\5ui\u0016$\u0007CA\u0007x\u0013\tAhBA\u000eTa\u0006\u00148\u000eT5ti\u0016tWM]*uC\u001e,7+\u001e2nSR$X\r\u001a\u0005\u0006u\u0002!\te_\u0001\u0011_:\u001cF/Y4f\u0007>l\u0007\u000f\\3uK\u0012$\"A\u0015?\t\u000buL\b\u0019\u0001@\u0002\u001dM$\u0018mZ3D_6\u0004H.\u001a;fIB\u0011Qb`\u0005\u0004\u0003\u0003q!aG*qCJ\\G*[:uK:,'o\u0015;bO\u0016\u001cu.\u001c9mKR,G\rC\u0004\u0002\u0006\u0001!\t%a\u0002\u0002\u0017=tG+Y:l'R\f'\u000f\u001e\u000b\u0004%\u0006%\u0001\u0002CA\u0006\u0003\u0007\u0001\r!!\u0004\u0002\u0013Q\f7o[*uCJ$\bcA\u0007\u0002\u0010%\u0019\u0011\u0011\u0003\b\u0003-M\u0003\u0018M]6MSN$XM\\3s)\u0006\u001c8n\u0015;beRDq!!\u0006\u0001\t\u0003\n9\"A\u0005p]R\u000b7o[#oIR\u0019!+!\u0007\t\u0011\u0005m\u00111\u0003a\u0001\u0003;\tq\u0001^1tW\u0016sG\rE\u0002\u000e\u0003?I1!!\t\u000f\u0005Q\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8feR\u000b7o[#oI\"9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0012\u0001B5oSR$\"!!\u000b\u0015\u0007I\u000bY\u0003\u0003\u0004&\u0003G\u0001\u001dA\n\u0005\b\u0003_\u0001A\u0011AA\u0019\u0003\u0015)'O]8s)\t\t\u0019\u0004F\u0002S\u0003kAa!JA\u0017\u0001\b1\u0003bBA\u001d\u0001\u0011\u0005\u00111H\u0001\u0007kB$\u0017\r^3\u0015\t\u0005u\u0012\u0011\t\u000b\u0004%\u0006}\u0002BB\u0013\u00028\u0001\u000fa\u0005\u0003\u0005\u00020\u0005]\u0002\u0019AA\"!\ra\u0012QI\u0005\u0004\u0003\u000fj\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u0017\u0002A\u0011AA'\u0003E\u0011\u0018\r^3MS6LG/\u001a3Va\u0012\fG/\u001a\u000b\u0003\u0003\u001f\"2AUA)\u0011\u0019)\u0013\u0011\na\u0002M\u0001")
public final class ProgressSparkListener
extends SparkListener {
    private final String executionId;
    private final OutputHandler outputHandler;
    private final long rateLimit;
    private AtomicBoolean isRunning;
    private long lastStopTime;
    private final AtomicInteger numTasks;
    private final AtomicInteger startedTasks;
    private final AtomicInteger doneTasks;

    public long rateLimit() {
        return this.rateLimit;
    }

    public AtomicBoolean isRunning() {
        return this.isRunning;
    }

    public void isRunning_$eq(AtomicBoolean x$1) {
        this.isRunning = x$1;
    }

    public long lastStopTime() {
        return this.lastStopTime;
    }

    public void lastStopTime_$eq(long x$1) {
        this.lastStopTime = x$1;
    }

    public AtomicInteger numTasks() {
        return this.numTasks;
    }

    public AtomicInteger startedTasks() {
        return this.startedTasks;
    }

    public AtomicInteger doneTasks() {
        return this.doneTasks;
    }

    public void onStageSubmitted(SparkListenerStageSubmitted stageSubmitted) {
        this.numTasks().addAndGet(stageSubmitted.stageInfo().numTasks());
        this.update(false, this.outputHandler);
    }

    public void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
        this.update(false, this.outputHandler);
    }

    public void onTaskStart(SparkListenerTaskStart taskStart) {
        this.startedTasks().incrementAndGet();
        this.rateLimitedUpdate(this.outputHandler);
    }

    public void onTaskEnd(SparkListenerTaskEnd taskEnd) {
        this.doneTasks().incrementAndGet();
        this.rateLimitedUpdate(this.outputHandler);
    }

    public void init(OutputHandler outputHandler) {
        outputHandler.html(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<div class=\"progress arc-background\">\n        |  <div class=\"progress-bar arc-complete\" style=\"width: 0%;\">0 / 0</div>\n        |</div>\n        |"})).s((Seq)Nil$.MODULE$))).stripMargin(), this.executionId);
    }

    public void error(OutputHandler outputHandler) {
        this.update(true, outputHandler);
    }

    public void update(boolean error, OutputHandler outputHandler) {
        int numTasksSnapshot = this.numTasks().get();
        int doneTasksSnapshot = this.doneTasks().get();
        int startedTasksSnapshot = this.startedTasks().get();
        int runningTasks = startedTasksSnapshot - doneTasksSnapshot;
        double donePct = 100.0 * (double)doneTasksSnapshot / (double)numTasksSnapshot;
        double runningPct = 100.0 * (double)runningTasks / (double)numTasksSnapshot;
        String statusText = doneTasksSnapshot == numTasksSnapshot || error ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)doneTasksSnapshot), BoxesRunTime.boxToInteger((int)numTasksSnapshot)})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", " (", " running)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)doneTasksSnapshot), BoxesRunTime.boxToInteger((int)numTasksSnapshot), BoxesRunTime.boxToInteger((int)runningTasks)}));
        String statusClass = error ? "error" : "";
        outputHandler.updateHtml(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<div class=\"progress arc-background\">\n          |  <div class=\"progress-bar arc-complete ", "\" style=\"width: ", "%;\">", "</div>\n          |  <div class=\"progress-bar arc-running ", "\" style=\"width: ", "%;\"></div>\n          |</div>\n          |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{statusClass, BoxesRunTime.boxToDouble((double)donePct), statusText, statusClass, BoxesRunTime.boxToDouble((double)runningPct)})))).stripMargin(), this.executionId);
    }

    public void rateLimitedUpdate(OutputHandler outputHandler) {
        boolean doneWaiting;
        boolean bl = doneWaiting = this.lastStopTime() + this.rateLimit() <= Platform$.MODULE$.currentTime();
        if (this.isRunning().compareAndSet(false, doneWaiting) && doneWaiting) {
            this.update(false, outputHandler);
        }
        return;
        finally {
            this.lastStopTime_$eq(Platform$.MODULE$.currentTime());
            this.isRunning().set(false);
        }
    }

    public ProgressSparkListener(String executionId, OutputHandler outputHandler) {
        this.executionId = executionId;
        this.outputHandler = outputHandler;
        this.rateLimit = Duration$.MODULE$.apply(200L, TimeUnit.MILLISECONDS).toMillis();
        this.isRunning = new AtomicBoolean(false);
        this.lastStopTime = Long.MIN_VALUE;
        this.numTasks = new AtomicInteger();
        this.startedTasks = new AtomicInteger();
        this.doneTasks = new AtomicInteger();
    }
}

