/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.jupyter;

import ai.tripl.arc.api.API;
import ai.tripl.arc.jupyter.BuildInfo$;
import ai.tripl.arc.jupyter.Common$;
import ai.tripl.arc.plugins.DynamicConfigurationPlugin;
import ai.tripl.arc.plugins.PipelineStagePlugin;
import ai.tripl.arc.plugins.UDFPlugin;
import ai.tripl.arc.util.log.logger.Logger;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.util.Properties$;

public final class Common$ {
    public static final Common$ MODULE$;

    static {
        new Common$();
    }

    public Dataset<Row> createPrettyMetadataDataframe(Dataset<Row> input, SparkSession spark, Logger logger) {
        Dataset dataset;
        Dataset schemaDataframe = spark.implicits().rddToDatasetHolder(spark.sparkContext().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{input.schema().json()})), spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(String.class)), spark.implicits().newStringEncoder()).toDF().as(spark.implicits().newStringEncoder());
        Dataset parsedSchema = spark.read().json(schemaDataframe);
        Dataset schemaDF = parsedSchema.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.explode(functions$.MODULE$.col("fields"))})).select("col.*", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (Predef$.MODULE$.refArrayOps((Object[])schemaDF.columns()).contains((Object)"metadata")) {
            Column[] nonMetadataFields = (Column[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])schemaDF.schema().fields()).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(StructField field) {
                    String string = field.name();
                    String string2 = "metadata";
                    return string != null ? !string.equals(string2) : string2 != null;
                }
            })).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Column apply(StructField field) {
                    return functions$.MODULE$.col(field.name());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
            Column[] metadataFields = (Column[])Predef$.MODULE$.refArrayOps((Object[])((StructType)schemaDF.schema().fields()[schemaDF.schema().fieldIndex("metadata")].dataType()).fields()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Column apply(StructField field) {
                    return functions$.MODULE$.col(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"metadata.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{field.name()}))).as(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"metadata.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{field.name()})));
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
            dataset = schemaDF.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])nonMetadataFields).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])metadataFields), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))));
        } else {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Ai_tripl_arc_jupyter_Common$$typecreator10$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Map"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$)})));
                }

                public Ai_tripl_arc_jupyter_Common$$typecreator10$1() {
                }
            }
            dataset = schemaDF.withColumn("metadata", functions$.MODULE$.typedLit((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ai_tripl_arc_jupyter_Common$$typecreator10$1())));
        }
        Dataset output = dataset;
        output.cache().count();
        return output;
    }

    public String GetHelp() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n    |Commands:\n    |%arc\n    |Run the stage as an Arc stage. Useful if you want to override the config settings for an individual cell.\n    |Supported configuration parameters: numRows, truncate, monospace, streamingDuration\n    |\n    |%sql\n    |Run a SQL query. \n    |Supported configuration parameters: numRows, truncate, outputView, persist, monospace, streamingDuration\n    |\n    |%cypher\n    |Run a Cypher graph query. Scala 2.12 only.\n    |Supported configuration parameters: numRows, truncate, outputView, persist, monospace\n    |    \n    |%schema [view]\n    |Display a JSON formatted schema for the input view\n    |\n    |%printschema [view]\n    |Display a printable basic schema for the input view\n    |\n    |%metadata [view]\n    |Create an Arc metadata dataset for the input view\n    |Supported configuration parameters: numRows, truncate, outputView, persist, monospace\n    |\n    |%printmetadata [view]\n    |Display a JSON formatted Arc metadata schema for the input view\n    |\n    |%summary [view]\n    |Create an Summary statistics dataset for the input view\n    |Supported configuration parameters: numRows, truncate, outputView, persist, monospace\n    |\n    |%env\n    |Set variables for this session. E.g. ETL_CONF_BASE_DIR=/home/jovyan/tutorial\n    |Supported configuration parameters: numRows, truncate, outputView, persist, monospace, streamingDuration\n    |\n    |%secret\n    |Set secrets for this session. E.g. ETL_CONF_SECRET\n    |\n    |%conf\n    |Set global Configuration Parameters which will apply to all cells.\n    |\n    |%help\n    |Display this help text.\n    |\n    |Configuration Parameters:\n    |master:            The address of the Spark master (if connecting to a remote cluster)\n    |numRows:           The maximum number of rows to return in a dataset (integer)\n    |truncate:          The maximum number of characters displayed in a string result (integer)\n    |streaming:         Set the notebook into streaming mode (boolean)\n    |streamingDuration: How many seconds to execute a streaming stage before stopping (will stop if numRows is reached first).\n    |monospace:         Use a fixed-width font.\n    "})).s((Seq)Nil$.MODULE$))).stripMargin();
    }

    public String GetVersion(SparkSession spark, API.ARCContext arcContext) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n    |spark: ", "\n    |arc: ", "\n    |arc-jupyter: ", "\n    |scala: ", "\n    |java: ", "\n    |dynamicConfigurationPlugins: \n    |", "\n    |pipelinePlugins:\n    |", "\n    |udfPlugins: \n    |", "\n    "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{spark.version(), ai.tripl.arc.ArcBuildInfo.BuildInfo$.MODULE$.version(), BuildInfo$.MODULE$.version(), Properties$.MODULE$.versionNumberString(), System.getProperty("java.runtime.version"), ((TraversableOnce)((SeqLike)arcContext.dynamicConfigurationPlugins().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(DynamicConfigurationPlugin c) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" - ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c.getClass().getName(), c.version()}));
            }
        }, List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"), ((TraversableOnce)((SeqLike)arcContext.pipelineStagePlugins().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(PipelineStagePlugin c) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" - ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c.getClass().getName(), c.version()}));
            }
        }, List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"), ((TraversableOnce)((SeqLike)arcContext.udfPlugins().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(UDFPlugin c) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" - ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c.getClass().getName(), c.version()}));
            }
        }, List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")})))).stripMargin();
    }

    private Common$() {
        MODULE$ = this;
    }
}

