/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.jupyter;

import ai.tripl.arc.api.API;
import ai.tripl.arc.jupyter.BuildInfo$;
import ai.tripl.arc.jupyter.Common$;
import ai.tripl.arc.plugins.DynamicConfigurationPlugin;
import ai.tripl.arc.plugins.PipelineStagePlugin;
import ai.tripl.arc.plugins.UDFPlugin;
import ai.tripl.arc.util.log.logger.Logger;
import almond.interpreter.ExecuteResult;
import almond.interpreter.api.DisplayData$;
import almond.interpreter.api.OutputHandler;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.security.SecureRandom;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Properties$;
import scala.util.control.Breaks$;
import scala.xml.Utility$;

public final class Common$ {
    public static final Common$ MODULE$;
    private final String alpha;
    private final int size;
    private final SecureRandom secureRandom;

    static {
        new Common$();
    }

    public Dataset<Row> createPrettyMetadataDataframe(Dataset<Row> input, SparkSession spark, Logger logger) {
        Dataset dataset;
        Dataset schemaDataframe = spark.implicits().rddToDatasetHolder(spark.sparkContext().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{input.schema().json()})), spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(String.class)), spark.implicits().newStringEncoder()).toDF().as(spark.implicits().newStringEncoder());
        Dataset parsedSchema = spark.read().json(schemaDataframe);
        Dataset schemaDF = parsedSchema.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.explode(functions$.MODULE$.col("fields"))})).select("col.*", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (Predef$.MODULE$.refArrayOps((Object[])schemaDF.columns()).contains((Object)"metadata")) {
            Column[] nonMetadataFields = (Column[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])schemaDF.schema().fields()).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(StructField field) {
                    String string = field.name();
                    String string2 = "metadata";
                    return string != null ? !string.equals(string2) : string2 != null;
                }
            })).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Column apply(StructField field) {
                    return functions$.MODULE$.col(field.name());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
            Column[] metadataFields = (Column[])Predef$.MODULE$.refArrayOps((Object[])((StructType)schemaDF.schema().fields()[schemaDF.schema().fieldIndex("metadata")].dataType()).fields()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Column apply(StructField field) {
                    return functions$.MODULE$.col(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"metadata.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{field.name()}))).as(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"metadata.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{field.name()})));
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
            dataset = schemaDF.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])nonMetadataFields).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])metadataFields), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))));
        } else {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Ai_tripl_arc_jupyter_Common$$typecreator10$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Map"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$)})));
                }

                public Ai_tripl_arc_jupyter_Common$$typecreator10$1() {
                }
            }
            dataset = schemaDF.withColumn("metadata", functions$.MODULE$.typedLit((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ai_tripl_arc_jupyter_Common$$typecreator10$1())));
        }
        Dataset output = dataset;
        output.cache().count();
        return output;
    }

    public String getHelp() {
        return new StringOps(Predef$.MODULE$.augmentString("\n    |Commands:\n    |%arc\n    |Run the stage as an Arc stage. Useful if you want to override the config settings for an individual cell.\n    |Supported configuration parameters: numRows, truncate, monospace, streamingDuration\n    |\n    |%sql\n    |Run an inline SQLTransform stage. e.g.:\n    |%sql name=\"calculate weather\" outputView=weather environments=production,test persist=true\n    |\n    |%sqlvalidate\n    |Run an inline SQLValidate stage. e.g.:\n    |%sqlvalidate name=\"ensure no errors exist after data typing\" environments=production,test sqlParams=input_table=${ETL_CONF_TABLE}\n    |\n    |%cypher\n    |Run a Cypher graph query. Scala 2.12 only.\n    |Supported configuration parameters: numRows, truncate, outputView, persist, monospace\n    |\n    |%schema [view]\n    |Display a JSON formatted schema for the input view\n    |\n    |%printschema [view]\n    |Display a printable basic schema for the input view\n    |\n    |%metadata [view]\n    |Create an Arc metadata dataset for the input view\n    |Supported configuration parameters: numRows, truncate, outputView, persist, monospace\n    |\n    |%printmetadata [view]\n    |Display a JSON formatted Arc metadata schema for the input view\n    |\n    |%summary [view]\n    |Create an Summary statistics dataset for the input view\n    |Supported configuration parameters: numRows, truncate, outputView, persist, monospace\n    |\n    |%env\n    |Set variables for this session. E.g. ETL_CONF_BASE_DIR=/home/jovyan/tutorial\n    |Supported configuration parameters: numRows, truncate, outputView, persist, monospace, streamingDuration\n    |\n    |%secret\n    |Set secrets for this session. E.g. ETL_CONF_SECRET\n    |\n    |%conf\n    |Set global Configuration Parameters which will apply to all cells.\n    |\n    |%list\n    |Show a list of files in a target directory\n    |\n    |%help\n    |Display this help text.\n    |\n    |Configuration Parameters:\n    |master:            The address of the Spark master (if connecting to a remote cluster)\n    |streaming:         Set the notebook into streaming mode (boolean)\n    |streamingDuration: How many seconds to execute a streaming stage before stopping (will stop if numRows is reached first).\n    |\n    |Display Parameters:\n    |datasetLabels:     Display labels with the name of the registered table name\n    |leftAlign:         Left-align output datasets\n    |monospace:         Use a fixed-width font\n    |numRows:           The maximum number of rows to return in a dataset (integer)\n    |truncate:          The maximum number of characters displayed in a string result (integer)\n    ")).stripMargin();
    }

    public String getVersion(SparkSession spark, API.ARCContext arcContext) {
        long physicalMemory = ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize();
        long runtimeMemory = Runtime.getRuntime().maxMemory();
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n    |spark: ", "\n    |arc: ", "\n    |arc-jupyter: ", "\n    |scala: ", "\n    |java: ", "\n    |runtimeMemory: ", "B\n    |physicalMemory: ", "B\n    |dynamicConfigurationPlugins:\n    |", "\n    |pipelinePlugins:\n    |", "\n    |udfPlugins:\n    |", "\n    "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{spark.version(), ai.tripl.arc.ArcBuildInfo.BuildInfo$.MODULE$.version(), BuildInfo$.MODULE$.version(), Properties$.MODULE$.versionNumberString(), System.getProperty("java.runtime.version"), BoxesRunTime.boxToLong((long)runtimeMemory), BoxesRunTime.boxToLong((long)physicalMemory), ((TraversableOnce)((SeqLike)arcContext.dynamicConfigurationPlugins().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(DynamicConfigurationPlugin c) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" - ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c.getClass().getName(), c.version()}));
            }
        }, List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"), ((TraversableOnce)((SeqLike)arcContext.pipelineStagePlugins().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(PipelineStagePlugin c) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" - ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c.getClass().getName(), c.version()}));
            }
        }, List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"), ((TraversableOnce)((SeqLike)arcContext.udfPlugins().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(UDFPlugin c) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" - ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c.getClass().getName(), c.version()}));
            }
        }, List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")})))).stripMargin();
    }

    /*
     * WARNING - void declaration
     */
    public String injectParameters(String sql, Map<String, String> params) {
        void var3_3;
        String stmt = (String)params.foldLeft((Object)sql, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x0$1, Tuple2<String, String> x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)x0$1, x1$1);
                if (tuple2 != null) {
                    String stmt = (String)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        String k = (String)tuple22._1();
                        String v = (String)tuple22._2();
                        String matchPlaceholderRegex = new StringBuilder().append((Object)"[$][{]\\s*").append((Object)k).append((Object)"\\s*(?:=[^}]+)?[}]").toString();
                        String string = new StringOps(Predef$.MODULE$.augmentString(matchPlaceholderRegex)).r().replaceAllIn((CharSequence)stmt, v);
                        return string;
                    }
                }
                throw new MatchError((Object)tuple2);
            }
        });
        return var3_3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExecuteResult renderResult(SparkSession spark, Option<OutputHandler> outputHandler, Option<API.PipelineStage> stage, Dataset<Row> df, int numRows, int truncate, boolean monospace, boolean leftAlign, boolean datasetLabels, int streamingDuration, int confStreamingFrequency) {
        ExecuteResult.Success success;
        if (df.isStreaming()) {
            ExecuteResult.Error error;
            Option<OutputHandler> option = outputHandler;
            if (option instanceof Some) {
                Some some = (Some)option;
                OutputHandler outputHandler2 = (OutputHandler)some.x();
                String outputElementHandle = this.randStr(32);
                String queryName = this.randStr(32);
                StreamingQuery writeStream = df.writeStream().format("memory").outputMode("append").queryName(queryName).start();
                long endTime = System.currentTimeMillis() + (long)(streamingDuration * 1000);
                BooleanRef initial = BooleanRef.create((boolean)true);
                Breaks$.MODULE$.breakable((Function0)new Serializable(spark, numRows, truncate, monospace, leftAlign, datasetLabels, confStreamingFrequency, outputHandler2, outputElementHandle, queryName, endTime, initial){
                    public static final long serialVersionUID = 0L;
                    private final SparkSession spark$1;
                    private final int numRows$1;
                    private final int truncate$1;
                    private final boolean monospace$1;
                    private final boolean leftAlign$1;
                    private final boolean datasetLabels$1;
                    private final int confStreamingFrequency$1;
                    private final OutputHandler outputHandler$1;
                    private final String outputElementHandle$1;
                    private final String queryName$1;
                    private final long endTime$1;
                    private final BooleanRef initial$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        while (System.currentTimeMillis() <= this.endTime$1) {
                            Dataset df = this.spark$1.table(this.queryName$1);
                            df.persist();
                            long count = df.count();
                            if (this.initial$1.elem) {
                                this.outputHandler$1.html(Common$.MODULE$.renderHTML((Dataset<Row>)df, (Option<API.PipelineStage>)None$.MODULE$, this.numRows$1, this.truncate$1, this.monospace$1, this.leftAlign$1, this.datasetLabels$1), this.outputElementHandle$1);
                                this.initial$1.elem = false;
                            } else {
                                this.outputHandler$1.updateHtml(Common$.MODULE$.renderHTML((Dataset<Row>)df, (Option<API.PipelineStage>)None$.MODULE$, this.numRows$1, this.truncate$1, this.monospace$1, this.leftAlign$1, this.datasetLabels$1), this.outputElementHandle$1);
                            }
                            df.unpersist();
                            if (count > (long)this.numRows$1) {
                                throw Breaks$.MODULE$.break();
                            }
                            Thread.sleep(this.confStreamingFrequency$1);
                        }
                    }
                    {
                        this.spark$1 = spark$1;
                        this.numRows$1 = numRows$1;
                        this.truncate$1 = truncate$1;
                        this.monospace$1 = monospace$1;
                        this.leftAlign$1 = leftAlign$1;
                        this.datasetLabels$1 = datasetLabels$1;
                        this.confStreamingFrequency$1 = confStreamingFrequency$1;
                        this.outputHandler$1 = outputHandler$1;
                        this.outputElementHandle$1 = outputElementHandle$1;
                        this.queryName$1 = queryName$1;
                        this.endTime$1 = endTime$1;
                        this.initial$1 = initial$1;
                    }
                });
                writeStream.stop();
                outputHandler2.html("", outputElementHandle);
                error = new ExecuteResult.Success(DisplayData$.MODULE$.html(this.renderHTML((Dataset<Row>)spark.table(queryName), (Option<API.PipelineStage>)None$.MODULE$, numRows, truncate, monospace, leftAlign, datasetLabels)));
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                error = ExecuteResult.Error$.MODULE$.apply("No result.");
            }
            success = error;
            return success;
        } else {
            success = new ExecuteResult.Success(DisplayData$.MODULE$.html(this.renderHTML(df, stage, numRows, truncate, monospace, leftAlign, datasetLabels)));
        }
        return success;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String renderHTML(Dataset<Row> df, Option<API.PipelineStage> stage, int numRows, int truncate, boolean monospace, boolean leftAlign, boolean datasetLabels) {
        String string;
        String leftAlignClass;
        String[] header = df.columns();
        Dataset renamedDF = df.toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])df.columns()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x0$2) {
                Tuple2<String, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    String col = (String)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{col, BoxesRunTime.boxToInteger((int)idx)}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))));
        Seq castCols = (Seq)renamedDF.schema().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(StructField field) {
                Column column;
                String fieldName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{field.name()}));
                DataType dataType = field.dataType();
                if (BinaryType$.MODULE$.equals(dataType)) {
                    column = functions$.MODULE$.col(fieldName);
                } else if (DoubleType$.MODULE$.equals(dataType)) {
                    column = functions$.MODULE$.regexp_replace(functions$.MODULE$.regexp_replace(functions$.MODULE$.regexp_replace(functions$.MODULE$.format_number(functions$.MODULE$.col(fieldName), 10), ",", ""), "(?<=.[0-9]{2})0+$", ""), "^\\.", "0.");
                } else if (dataType instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)dataType;
                    column = functions$.MODULE$.regexp_replace(functions$.MODULE$.format_number(functions$.MODULE$.col(fieldName), decimalType.scale()), ",", "");
                } else {
                    column = TimestampType$.MODULE$.equals(dataType) ? functions$.MODULE$.date_format(functions$.MODULE$.col(fieldName), "yyyy-MM-dd'T'HH:mm:ss'Z'") : (DateType$.MODULE$.equals(dataType) ? functions$.MODULE$.date_format(functions$.MODULE$.col(fieldName), "yyyy-MM-dd") : functions$.MODULE$.col(fieldName).cast((DataType)StringType$.MODULE$));
                }
                return column;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Row[] data = (Row[])renamedDF.select(castCols).take(numRows);
        Seq[] rows = (Seq[])Predef$.MODULE$.refArrayOps((Object[])data).map((Function1)new Serializable(truncate){
            public static final long serialVersionUID = 0L;
            public final int truncate$2;

            public final Seq<String> apply(Row row) {
                return (Seq)row.toSeq().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.7 $outer;

                    public final String apply(Object cell) {
                        String string;
                        Object object = cell;
                        if (object == null) {
                            string = "null";
                        } else if (object instanceof byte[]) {
                            byte[] byArray = (byte[])object;
                            string = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.byteArrayOps(byArray).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(byte x$1) {
                                    return new StringOps(Predef$.MODULE$.augmentString("%02X")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)x$1)}));
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("[", " ", "]");
                        } else {
                            string = cell.toString();
                        }
                        String str = string;
                        return this.$outer.truncate$2 > 0 && str.length() > this.$outer.truncate$2 ? (this.$outer.truncate$2 < 4 ? str.substring(0, this.$outer.truncate$2) : new StringBuilder().append((Object)str.substring(0, this.$outer.truncate$2 - 3)).append((Object)"...").toString()) : str;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.truncate$2 = truncate$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)));
        String monospaceClass = monospace ? "monospace" : "";
        String string2 = leftAlignClass = leftAlign ? "leftalign" : "";
        if (datasetLabels) {
            Object object;
            String string3;
            Object object2;
            Object outputView;
            Object outputView2;
            String string4;
            Option<API.PipelineStage> option = stage;
            if (option instanceof Some) {
                Some some = (Some)option;
                API.PipelineStage stage2 = (API.PipelineStage)some.x();
                Option inputView = this.liftedTree1$1(stage2);
                Option outputView3 = this.liftedTree2$1(stage2);
                string4 = new Tuple2((Object)inputView, (Object)outputView3);
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                string4 = "";
            }
            String string5 = string4;
            if (!(string5 instanceof Tuple2)) throw new MatchError((Object)string5);
            Tuple2 tuple2 = (Tuple2)string5;
            Object inputView = tuple2._1();
            Tuple2 tuple22 = new Tuple2(inputView, outputView2 = tuple2._2());
            Tuple2 tuple23 = tuple22;
            Object inputView2 = tuple23._1();
            Tuple2 tuple24 = new Tuple2(inputView2, outputView = tuple23._2());
            if (tuple24 != null && (object2 = tuple24._2()) instanceof Some) {
                Some some = (Some)object2;
                Object ouputView = some.x();
                string3 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<div class=\"table_name ", "\">", "</div>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{monospace ? "monospace" : "", ouputView}));
            } else if (tuple24 != null && (object = tuple24._1()) instanceof Some) {
                Some some = (Some)object;
                Object inputView3 = some.x();
                string3 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<div class=\"table_name ", "\">", "</div>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{monospace ? "monospace" : "", inputView3}));
            } else {
                string3 = "";
            }
            string = string3;
        } else {
            string = "";
        }
        String label = string;
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "<table class=\"tex2jax_ignore ", " ", "\"><thead><tr>", "</tr></thead><tbody>", "</tbody></table>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{label, monospaceClass, leftAlignClass, Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])header).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String h) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<th>", "</th>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utility$.MODULE$.escape(h)}));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(), Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])rows).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Seq<String> row) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<tr>", "</tr>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)row.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String cell) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<td>", "</td>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utility$.MODULE$.escape(cell)}));
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString()}));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString()}));
    }

    public String alpha() {
        return this.alpha;
    }

    public int size() {
        return this.size;
    }

    public SecureRandom secureRandom() {
        return this.secureRandom;
    }

    public String randStr(int n) {
        return ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), n).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final char apply(int x) {
                return StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(Common$.MODULE$.alpha()), RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(Common$.MODULE$.secureRandom().nextInt())) % Common$.MODULE$.size());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString();
    }

    private final Option liftedTree1$1(API.PipelineStage stage$1) {
        None$ none$;
        try {
            None$ none$2;
            Some some;
            Object stageName;
            Object object = stage$1.getClass().getMethod("inputView", new Class[0]).invoke((Object)stage$1, new Object[0]);
            if (object instanceof Some && (stageName = (some = (Some)object).x()) instanceof String) {
                String string = (String)stageName;
                none$2 = Option$.MODULE$.apply((Object)string);
            } else if (object instanceof String) {
                String string = (String)object;
                none$2 = Option$.MODULE$.apply((Object)string);
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        catch (Exception exception) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private final Option liftedTree2$1(API.PipelineStage stage$1) {
        None$ none$;
        try {
            None$ none$2;
            Some some;
            Object stageName;
            Object object = stage$1.getClass().getMethod("outputView", new Class[0]).invoke((Object)stage$1, new Object[0]);
            if (object instanceof Some && (stageName = (some = (Some)object).x()) instanceof String) {
                String string = (String)stageName;
                none$2 = Option$.MODULE$.apply((Object)string);
            } else if (object instanceof String) {
                String string = (String)object;
                none$2 = Option$.MODULE$.apply((Object)string);
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        catch (Exception exception) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Common$() {
        MODULE$ = this;
        this.alpha = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        this.size = new StringOps(Predef$.MODULE$.augmentString(this.alpha())).size();
        this.secureRandom = new SecureRandom();
    }
}

