/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.jupyter;

import almond.interpreter.api.OutputHandler;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.compat.Platform$;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001\u0002\u000e\u001c\u0005\u0011B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\t\u007f\u0001\u0011\t\u0011)A\u0006\u0001\")!\n\u0001C\u0001\u0017\"9\u0011\u000b\u0001b\u0001\n\u0003\u0011\u0006BB,\u0001A\u0003%1\u000bC\u0004Y\u0001\u0001\u0007I\u0011A-\t\u000f\u0019\u0004\u0001\u0019!C\u0001O\"1Q\u000e\u0001Q!\niCqA\u001c\u0001A\u0002\u0013\u0005!\u000bC\u0004p\u0001\u0001\u0007I\u0011\u00019\t\rI\u0004\u0001\u0015)\u0003T\u0011\u001d\u0019\bA1A\u0005\u0002QDa\u0001\u001f\u0001!\u0002\u0013)\bbB=\u0001\u0005\u0004%\t\u0001\u001e\u0005\u0007u\u0002\u0001\u000b\u0011B;\t\u000fm\u0004!\u0019!C\u0001i\"1A\u0010\u0001Q\u0001\nUDQ! \u0001\u0005ByDq!!\u0003\u0001\t\u0003\nY\u0001C\u0004\u0002\u0018\u0001!\t%!\u0007\t\u000f\u0005\u0015\u0002\u0001\"\u0011\u0002(!9\u00111\u0007\u0001\u0005\u0002\u0005U\u0002bBA\u001e\u0001\u0011\u0005\u0011Q\b\u0005\b\u0003\u0007\u0002A\u0011AA#\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+\u0012Q\u0003\u0015:pOJ,7o]*qCJ\\G*[:uK:,'O\u0003\u0002\u001d;\u00059!.\u001e9zi\u0016\u0014(B\u0001\u0010 \u0003\r\t'o\u0019\u0006\u0003A\u0005\nQ\u0001\u001e:ja2T\u0011AI\u0001\u0003C&\u001c\u0001a\u0005\u0002\u0001KA\u0011aeL\u0007\u0002O)\u0011\u0001&K\u0001\ng\u000eDW\rZ;mKJT!AK\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u00051j\u0013AB1qC\u000eDWMC\u0001/\u0003\ry'oZ\u0005\u0003a\u001d\u0012Qb\u00159be.d\u0015n\u001d;f]\u0016\u0014\u0018aC3yK\u000e,H/[8o\u0013\u0012\u0004\"a\r\u001f\u000f\u0005QR\u0004CA\u001b9\u001b\u00051$BA\u001c$\u0003\u0019a$o\\8u})\t\u0011(A\u0003tG\u0006d\u0017-\u0003\u0002<q\u00051\u0001K]3eK\u001aL!!\u0010 \u0003\rM#(/\u001b8h\u0015\tY\u0004(A\u0007pkR\u0004X\u000f\u001e%b]\u0012dWM\u001d\t\u0003\u0003\"k\u0011A\u0011\u0006\u0003\u0007\u0012\u000b1!\u00199j\u0015\t)e)A\u0006j]R,'\u000f\u001d:fi\u0016\u0014(\"A$\u0002\r\u0005dWn\u001c8e\u0013\tI%IA\u0007PkR\u0004X\u000f\u001e%b]\u0012dWM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00051\u0003FCA'P!\tq\u0005!D\u0001\u001c\u0011\u0015y4\u0001q\u0001A\u0011\u0015\t4\u00011\u00013\u0003%\u0011\u0018\r^3MS6LG/F\u0001T!\t!V+D\u00019\u0013\t1\u0006H\u0001\u0003M_:<\u0017A\u0003:bi\u0016d\u0015.\\5uA\u0005I\u0011n\u001d*v]:LgnZ\u000b\u00025B\u00111\fZ\u0007\u00029*\u0011QLX\u0001\u0007CR|W.[2\u000b\u0005}\u0003\u0017AC2p]\u000e,(O]3oi*\u0011\u0011MY\u0001\u0005kRLGNC\u0001d\u0003\u0011Q\u0017M^1\n\u0005\u0015d&!D!u_6L7MQ8pY\u0016\fg.A\u0007jgJ+hN\\5oO~#S-\u001d\u000b\u0003Q.\u0004\"\u0001V5\n\u0005)D$\u0001B+oSRDq\u0001\\\u0004\u0002\u0002\u0003\u0007!,A\u0002yIE\n!\"[:Sk:t\u0017N\\4!\u00031a\u0017m\u001d;Ti>\u0004H+[7f\u0003Aa\u0017m\u001d;Ti>\u0004H+[7f?\u0012*\u0017\u000f\u0006\u0002ic\"9ANCA\u0001\u0002\u0004\u0019\u0016!\u00047bgR\u001cFo\u001c9US6,\u0007%\u0001\u0005ok6$\u0016m]6t+\u0005)\bCA.w\u0013\t9HLA\u0007Bi>l\u0017nY%oi\u0016<WM]\u0001\n]VlG+Y:lg\u0002\nAb\u001d;beR,G\rV1tWN\fQb\u001d;beR,G\rV1tWN\u0004\u0013!\u00033p]\u0016$\u0016m]6t\u0003)!wN\\3UCN\\7\u000fI\u0001\u0011_:\u001cF/Y4f'V\u0014W.\u001b;uK\u0012$\"\u0001[@\t\u000f\u0005\u0005!\u00031\u0001\u0002\u0004\u0005q1\u000f^1hKN+(-\\5ui\u0016$\u0007c\u0001\u0014\u0002\u0006%\u0019\u0011qA\u0014\u00037M\u0003\u0018M]6MSN$XM\\3s'R\fw-Z*vE6LG\u000f^3e\u0003Aygn\u0015;bO\u0016\u001cu.\u001c9mKR,G\rF\u0002i\u0003\u001bAq!a\u0004\u0014\u0001\u0004\t\t\"\u0001\bti\u0006<WmQ8na2,G/\u001a3\u0011\u0007\u0019\n\u0019\"C\u0002\u0002\u0016\u001d\u00121d\u00159be.d\u0015n\u001d;f]\u0016\u00148\u000b^1hK\u000e{W\u000e\u001d7fi\u0016$\u0017aC8o)\u0006\u001c8n\u0015;beR$2\u0001[A\u000e\u0011\u001d\ti\u0002\u0006a\u0001\u0003?\t\u0011\u0002^1tWN#\u0018M\u001d;\u0011\u0007\u0019\n\t#C\u0002\u0002$\u001d\u0012ac\u00159be.d\u0015n\u001d;f]\u0016\u0014H+Y:l'R\f'\u000f^\u0001\n_:$\u0016m]6F]\u0012$2\u0001[A\u0015\u0011\u001d\tY#\u0006a\u0001\u0003[\tq\u0001^1tW\u0016sG\rE\u0002'\u0003_I1!!\r(\u0005Q\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8feR\u000b7o[#oI\u0006!\u0011N\\5u)\t\t9\u0004F\u0002i\u0003sAQa\u0010\fA\u0004\u0001\u000bQ!\u001a:s_J$\"!a\u0010\u0015\u0007!\f\t\u0005C\u0003@/\u0001\u000f\u0001)\u0001\u0004va\u0012\fG/\u001a\u000b\u0005\u0003\u000f\nY\u0005F\u0002i\u0003\u0013BQa\u0010\rA\u0004\u0001Cq!a\u000f\u0019\u0001\u0004\ti\u0005E\u0002U\u0003\u001fJ1!!\u00159\u0005\u001d\u0011un\u001c7fC:\f\u0011C]1uK2KW.\u001b;fIV\u0003H-\u0019;f)\t\t9\u0006F\u0002i\u00033BQaP\rA\u0004\u0001\u0003")
public final class ProgressSparkListener
extends SparkListener {
    private final String executionId;
    private final OutputHandler outputHandler;
    private final long rateLimit;
    private AtomicBoolean isRunning;
    private long lastStopTime;
    private final AtomicInteger numTasks;
    private final AtomicInteger startedTasks;
    private final AtomicInteger doneTasks;

    public long rateLimit() {
        return this.rateLimit;
    }

    public AtomicBoolean isRunning() {
        return this.isRunning;
    }

    public void isRunning_$eq(AtomicBoolean x$1) {
        this.isRunning = x$1;
    }

    public long lastStopTime() {
        return this.lastStopTime;
    }

    public void lastStopTime_$eq(long x$1) {
        this.lastStopTime = x$1;
    }

    public AtomicInteger numTasks() {
        return this.numTasks;
    }

    public AtomicInteger startedTasks() {
        return this.startedTasks;
    }

    public AtomicInteger doneTasks() {
        return this.doneTasks;
    }

    public void onStageSubmitted(SparkListenerStageSubmitted stageSubmitted) {
        this.numTasks().addAndGet(stageSubmitted.stageInfo().numTasks());
        this.update(false, this.outputHandler);
    }

    public void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
        this.update(false, this.outputHandler);
    }

    public void onTaskStart(SparkListenerTaskStart taskStart) {
        this.startedTasks().incrementAndGet();
        this.rateLimitedUpdate(this.outputHandler);
    }

    public void onTaskEnd(SparkListenerTaskEnd taskEnd) {
        this.doneTasks().incrementAndGet();
        this.rateLimitedUpdate(this.outputHandler);
    }

    public void init(OutputHandler outputHandler) {
        outputHandler.html(new StringOps(Predef$.MODULE$.augmentString("<div class=\"progress arc-background\">\n        |  <div class=\"progress-bar arc-complete\" style=\"width: 0%;\">0 / 0</div>\n        |</div>\n        |")).stripMargin(), this.executionId);
    }

    public void error(OutputHandler outputHandler) {
        this.update(true, outputHandler);
    }

    public void update(boolean error, OutputHandler outputHandler) {
        int numTasksSnapshot = this.numTasks().get();
        int doneTasksSnapshot = this.doneTasks().get();
        int startedTasksSnapshot = this.startedTasks().get();
        int runningTasks = startedTasksSnapshot - doneTasksSnapshot;
        double donePct = 100.0 * (double)doneTasksSnapshot / (double)numTasksSnapshot;
        double runningPct = 100.0 * (double)runningTasks / (double)numTasksSnapshot;
        String statusText = doneTasksSnapshot == numTasksSnapshot || error ? new StringBuilder(1).append(doneTasksSnapshot).append("/").append(numTasksSnapshot).toString() : new StringBuilder(12).append(doneTasksSnapshot).append("/").append(numTasksSnapshot).append(" (").append(runningTasks).append(" running)").toString();
        String statusClass = error ? "error" : "";
        outputHandler.updateHtml(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(222).append("<div class=\"progress arc-background\">\n          |  <div class=\"progress-bar arc-complete ").append(statusClass).append("\" style=\"width: ").append(donePct).append("%;\">").append(statusText).append("</div>\n          |  <div class=\"progress-bar arc-running ").append(statusClass).append("\" style=\"width: ").append(runningPct).append("%;\"></div>\n          |</div>\n          |").toString())).stripMargin(), this.executionId);
    }

    public void rateLimitedUpdate(OutputHandler outputHandler) {
        boolean doneWaiting;
        boolean bl = doneWaiting = this.lastStopTime() + this.rateLimit() <= Platform$.MODULE$.currentTime();
        if (this.isRunning().compareAndSet(false, doneWaiting) && doneWaiting) {
            try {
                this.update(false, outputHandler);
            }
            finally {
                this.lastStopTime_$eq(Platform$.MODULE$.currentTime());
                this.isRunning().set(false);
            }
        }
    }

    public ProgressSparkListener(String executionId, OutputHandler outputHandler) {
        this.executionId = executionId;
        this.outputHandler = outputHandler;
        this.rateLimit = Duration$.MODULE$.apply(200L, TimeUnit.MILLISECONDS).toMillis();
        this.isRunning = new AtomicBoolean(false);
        this.lastStopTime = Long.MIN_VALUE;
        this.numTasks = new AtomicInteger();
        this.startedTasks = new AtomicInteger();
        this.doneTasks = new AtomicInteger();
    }
}

