/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.jupyter;

import ai.tripl.arc.util.log.logger.Logger;
import almond.interpreter.api.OutputHandler;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.compat.Platform$;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001\u0002\u0010 \u0005!B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\"A\u0001\n\u0001B\u0001B\u0003-\u0011\n\u0003\u0005T\u0001\t\u0005\t\u0015a\u0003U\u0011\u0015i\u0006\u0001\"\u0001_\u0011\u001d1\u0007A1A\u0005\u0002\u001dDaa\u001b\u0001!\u0002\u0013A\u0007b\u00027\u0001\u0001\u0004%\t!\u001c\u0005\bs\u0002\u0001\r\u0011\"\u0001{\u0011\u001d\t\t\u0001\u0001Q!\n9D\u0001\"a\u0001\u0001\u0001\u0004%\ta\u001a\u0005\n\u0003\u000b\u0001\u0001\u0019!C\u0001\u0003\u000fAq!a\u0003\u0001A\u0003&\u0001\u000eC\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0001\u0002\u0010!A\u0011q\u0003\u0001!\u0002\u0013\t\t\u0002C\u0005\u0002\u001a\u0001\u0011\r\u0011\"\u0001\u0002\u0010!A\u00111\u0004\u0001!\u0002\u0013\t\t\u0002C\u0005\u0002\u001e\u0001\u0011\r\u0011\"\u0001\u0002\u0010!A\u0011q\u0004\u0001!\u0002\u0013\t\t\u0002C\u0004\u0002\"\u0001!\t%a\t\t\u000f\u0005=\u0002\u0001\"\u0011\u00022!9\u0011Q\b\u0001\u0005B\u0005}\u0002bBA&\u0001\u0011\u0005\u0013Q\n\u0005\b\u00033\u0002A\u0011IA.\u0011\u001d\t9\u0007\u0001C!\u0003SBq!!\u001e\u0001\t\u0003\t9\bC\u0004\u0002~\u0001!\t!a \t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002\b\"9\u00111\u0013\u0001\u0005\u0002\u0005U%!\u0006)s_\u001e\u0014Xm]:Ta\u0006\u00148\u000eT5ti\u0016tWM\u001d\u0006\u0003A\u0005\nqA[;qsR,'O\u0003\u0002#G\u0005\u0019\u0011M]2\u000b\u0005\u0011*\u0013!\u0002;sSBd'\"\u0001\u0014\u0002\u0005\u0005L7\u0001A\n\u0003\u0001%\u0002\"AK\u001a\u000e\u0003-R!\u0001L\u0017\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(B\u0001\u00180\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0014'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002e\u0005\u0019qN]4\n\u0005QZ#!D*qCJ\\G*[:uK:,'/A\u0006fq\u0016\u001cW\u000f^5p]&#\u0007CA\u001cA\u001d\tAd\b\u0005\u0002:y5\t!H\u0003\u0002<O\u00051AH]8pizR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\na\u0001\u0015:fI\u00164\u0017BA!C\u0005\u0019\u0019FO]5oO*\u0011q\bP\u0001\rSNTU\u000f]=uKJd\u0015M\u0019\t\u0003\u000b\u001ak\u0011\u0001P\u0005\u0003\u000fr\u0012qAQ8pY\u0016\fg.A\u0007pkR\u0004X\u000f\u001e%b]\u0012dWM\u001d\t\u0003\u0015Fk\u0011a\u0013\u0006\u0003\u00196\u000b1!\u00199j\u0015\tqu*A\u0006j]R,'\u000f\u001d:fi\u0016\u0014(\"\u0001)\u0002\r\u0005dWn\u001c8e\u0013\t\u00116JA\u0007PkR\u0004X\u000f\u001e%b]\u0012dWM]\u0001\u0007Y><w-\u001a:\u0011\u0005U[V\"\u0001,\u000b\u0005M;&B\u0001-Z\u0003\rawn\u001a\u0006\u00035\u0006\nA!\u001e;jY&\u0011AL\u0016\u0002\u0007\u0019><w-\u001a:\u0002\rqJg.\u001b;?)\ryF-\u001a\u000b\u0004A\n\u001c\u0007CA1\u0001\u001b\u0005y\u0002\"\u0002%\u0006\u0001\bI\u0005\"B*\u0006\u0001\b!\u0006\"B\u001b\u0006\u0001\u00041\u0004\"B\"\u0006\u0001\u0004!\u0015!\u0003:bi\u0016d\u0015.\\5u+\u0005A\u0007CA#j\u0013\tQGH\u0001\u0003M_:<\u0017A\u0003:bi\u0016d\u0015.\\5uA\u0005I\u0011n\u001d*v]:LgnZ\u000b\u0002]B\u0011qn^\u0007\u0002a*\u0011\u0011O]\u0001\u0007CR|W.[2\u000b\u0005M$\u0018AC2p]\u000e,(O]3oi*\u0011!,\u001e\u0006\u0002m\u0006!!.\u0019<b\u0013\tA\bOA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\u000eSN\u0014VO\u001c8j]\u001e|F%Z9\u0015\u0005mt\bCA#}\u0013\tiHH\u0001\u0003V]&$\bbB@\n\u0003\u0003\u0005\rA\\\u0001\u0004q\u0012\n\u0014AC5t%Vtg.\u001b8hA\u0005aA.Y:u'R|\u0007\u000fV5nK\u0006\u0001B.Y:u'R|\u0007\u000fV5nK~#S-\u001d\u000b\u0004w\u0006%\u0001bB@\r\u0003\u0003\u0005\r\u0001[\u0001\u000eY\u0006\u001cHo\u0015;paRKW.\u001a\u0011\u0002\u00119,X\u000eV1tWN,\"!!\u0005\u0011\u0007=\f\u0019\"C\u0002\u0002\u0016A\u0014Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\u0018!\u00038v[R\u000b7o[:!\u00031\u0019H/\u0019:uK\u0012$\u0016m]6t\u00035\u0019H/\u0019:uK\u0012$\u0016m]6tA\u0005IAm\u001c8f)\u0006\u001c8n]\u0001\u000bI>tW\rV1tWN\u0004\u0013\u0001E8o'R\fw-Z*vE6LG\u000f^3e)\rY\u0018Q\u0005\u0005\b\u0003O!\u0002\u0019AA\u0015\u00039\u0019H/Y4f'V\u0014W.\u001b;uK\u0012\u00042AKA\u0016\u0013\r\tic\u000b\u0002\u001c'B\f'o\u001b'jgR,g.\u001a:Ti\u0006<WmU;c[&$H/\u001a3\u0002!=t7\u000b^1hK\u000e{W\u000e\u001d7fi\u0016$GcA>\u00024!9\u0011QG\u000bA\u0002\u0005]\u0012AD:uC\u001e,7i\\7qY\u0016$X\r\u001a\t\u0004U\u0005e\u0012bAA\u001eW\tY2\u000b]1sW2K7\u000f^3oKJ\u001cF/Y4f\u0007>l\u0007\u000f\\3uK\u0012\f1b\u001c8UCN\\7\u000b^1siR\u001910!\u0011\t\u000f\u0005\rc\u00031\u0001\u0002F\u0005IA/Y:l'R\f'\u000f\u001e\t\u0004U\u0005\u001d\u0013bAA%W\t12\u000b]1sW2K7\u000f^3oKJ$\u0016m]6Ti\u0006\u0014H/A\u0005p]R\u000b7o[#oIR\u001910a\u0014\t\u000f\u0005Es\u00031\u0001\u0002T\u00059A/Y:l\u000b:$\u0007c\u0001\u0016\u0002V%\u0019\u0011qK\u0016\u0003)M\u0003\u0018M]6MSN$XM\\3s)\u0006\u001c8.\u00128e\u0003)ygNS8c'R\f'\u000f\u001e\u000b\u0004w\u0006u\u0003bBA01\u0001\u0007\u0011\u0011M\u0001\tU>\u00147\u000b^1siB\u0019!&a\u0019\n\u0007\u0005\u00154FA\u000bTa\u0006\u00148\u000eT5ti\u0016tWM\u001d&pEN#\u0018M\u001d;\u0002\u0011=t'j\u001c2F]\u0012$2a_A6\u0011\u001d\ti'\u0007a\u0001\u0003_\naA[8c\u000b:$\u0007c\u0001\u0016\u0002r%\u0019\u00111O\u0016\u0003'M\u0003\u0018M]6MSN$XM\\3s\u0015>\u0014WI\u001c3\u0002\t%t\u0017\u000e\u001e\u000b\u0003\u0003s\"2a_A>\u0011\u0015A%\u0004q\u0001J\u0003\u0015)'O]8s)\t\t\t\tF\u0002|\u0003\u0007CQ\u0001S\u000eA\u0004%\u000ba!\u001e9eCR,GCBAE\u0003\u001b\u000by\tF\u0002|\u0003\u0017CQ\u0001\u0013\u000fA\u0004%Ca!! \u001d\u0001\u0004!\u0005BBAI9\u0001\u0007A)\u0001\bsK6|g/\u001a'jgR,g.\u001a:\u0002#I\fG/\u001a'j[&$X\rZ+qI\u0006$X\r\u0006\u0002\u0002\u0018R\u001910!'\t\u000b!k\u00029A%")
public final class ProgressSparkListener
extends SparkListener {
    private final String executionId;
    private final boolean isJupyterLab;
    private final OutputHandler outputHandler;
    private final Logger logger;
    private final long rateLimit;
    private AtomicBoolean isRunning;
    private long lastStopTime;
    private final AtomicInteger numTasks;
    private final AtomicInteger startedTasks;
    private final AtomicInteger doneTasks;

    public long rateLimit() {
        return this.rateLimit;
    }

    public AtomicBoolean isRunning() {
        return this.isRunning;
    }

    public void isRunning_$eq(AtomicBoolean x$1) {
        this.isRunning = x$1;
    }

    public long lastStopTime() {
        return this.lastStopTime;
    }

    public void lastStopTime_$eq(long x$1) {
        this.lastStopTime = x$1;
    }

    public AtomicInteger numTasks() {
        return this.numTasks;
    }

    public AtomicInteger startedTasks() {
        return this.startedTasks;
    }

    public AtomicInteger doneTasks() {
        return this.doneTasks;
    }

    public void onStageSubmitted(SparkListenerStageSubmitted stageSubmitted) {
        this.logger.debug().message("onStageSubmitted").field("stageId", (Object)stageSubmitted.stageInfo().stageId()).field("numTasks", (Object)BoxesRunTime.boxToInteger((int)stageSubmitted.stageInfo().numTasks())).log();
        this.numTasks().addAndGet(stageSubmitted.stageInfo().numTasks());
        this.rateLimitedUpdate(this.outputHandler);
    }

    public void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
        this.logger.debug().message("onStageCompleted").field("stageId", (Object)stageCompleted.stageInfo().stageId()).log();
        this.rateLimitedUpdate(this.outputHandler);
    }

    public void onTaskStart(SparkListenerTaskStart taskStart) {
        this.logger.debug().message("taskStart").field("stageId", (Object)taskStart.stageId()).field("taskId", (Object)taskStart.taskInfo().taskId()).log();
        this.startedTasks().incrementAndGet();
        this.rateLimitedUpdate(this.outputHandler);
    }

    public void onTaskEnd(SparkListenerTaskEnd taskEnd) {
        this.logger.debug().message("taskEnd").field("stageId", (Object)taskEnd.stageId()).field("taskId", (Object)taskEnd.taskInfo().taskId()).log();
        this.doneTasks().incrementAndGet();
        this.rateLimitedUpdate(this.outputHandler);
    }

    public void onJobStart(SparkListenerJobStart jobStart) {
        this.logger.debug().message("onJobStart").field("jobId", (Object)jobStart.jobId()).log();
    }

    public void onJobEnd(SparkListenerJobEnd jobEnd) {
        this.logger.debug().message("onJobEnd").field("jobId", (Object)jobEnd.jobId()).log();
    }

    public void init(OutputHandler outputHandler) {
        outputHandler.html(new StringOps(Predef$.MODULE$.augmentString("<div class=\"progress arc-background\">\n        |  <div class=\"progress-bar arc-complete\" style=\"width: 0%;\">0 / 0</div>\n        |</div>\n        |")).stripMargin(), this.executionId);
    }

    public void error(OutputHandler outputHandler) {
        this.update(true, false, outputHandler);
    }

    public void update(boolean error, boolean removeListener, OutputHandler outputHandler) {
        String statusClass;
        int numTasksSnapshot = this.numTasks().get();
        int doneTasksSnapshot = this.doneTasks().get();
        int startedTasksSnapshot = this.startedTasks().get();
        if (removeListener) {
            doneTasksSnapshot = numTasksSnapshot;
            startedTasksSnapshot = 0;
        }
        int runningTasks = Math.max(startedTasksSnapshot - doneTasksSnapshot, 0);
        double donePct = Math.min(100.0 * (double)doneTasksSnapshot / (double)numTasksSnapshot, 100.0);
        double runningPct = Math.min(100.0 * (double)runningTasks / (double)numTasksSnapshot, 100.0);
        String statusText = doneTasksSnapshot == numTasksSnapshot || error ? new StringBuilder(1).append(doneTasksSnapshot).append("/").append(numTasksSnapshot).toString() : new StringBuilder(12).append(doneTasksSnapshot).append("/").append(numTasksSnapshot).append(" (").append(runningTasks).append(" running)").toString();
        String string = statusClass = error ? "error" : "";
        if (this.isJupyterLab) {
            if (removeListener) {
                if (error) {
                    outputHandler.updateHtml(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(141).append("<div class=\"progress\">\n                |  <div class=\"progress-bar-danger\" style=\"width: ").append(!Predef$.MODULE$.double2Double(donePct).isNaN() ? (Number)BoxesRunTime.boxToDouble((double)donePct) : (Number)BoxesRunTime.boxToInteger((int)100)).append("%;\">").append(statusText).append("</div>\n                |</div>\n                |").toString())).stripMargin(), this.executionId);
                } else {
                    outputHandler.updateHtml(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(142).append("<div class=\"progress\">\n                |  <div class=\"progress-bar-success\" style=\"width: ").append(!Predef$.MODULE$.double2Double(donePct).isNaN() ? (Number)BoxesRunTime.boxToDouble((double)donePct) : (Number)BoxesRunTime.boxToInteger((int)100)).append("%;\">").append(statusText).append("</div>\n                |</div>\n                |").toString())).stripMargin(), this.executionId);
                }
            } else {
                outputHandler.updateHtml(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(133).append("<div class=\"progress\">\n              |  <div class=\"progress-bar-info\" style=\"width: ").append(!Predef$.MODULE$.double2Double(donePct).isNaN() ? (Number)BoxesRunTime.boxToDouble((double)donePct) : (Number)BoxesRunTime.boxToInteger((int)100)).append("%;\">").append(statusText).append("</div>\n              |</div>\n              |").toString())).stripMargin(), this.executionId);
            }
        } else {
            outputHandler.updateHtml(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(230).append("<div class=\"progress arc-background\">\n            |  <div class=\"progress-bar arc-complete ").append(statusClass).append("\" style=\"width: ").append(!Predef$.MODULE$.double2Double(donePct).isNaN() ? (Number)BoxesRunTime.boxToDouble((double)donePct) : (Number)BoxesRunTime.boxToInteger((int)100)).append("%;\">").append(statusText).append("</div>\n            |  <div class=\"progress-bar arc-running ").append(statusClass).append("\" style=\"width: ").append(runningPct).append("%;\"></div>\n            |</div>\n            |").toString())).stripMargin(), this.executionId);
        }
    }

    public void rateLimitedUpdate(OutputHandler outputHandler) {
        boolean doneWaiting;
        boolean bl = doneWaiting = this.lastStopTime() + this.rateLimit() <= Platform$.MODULE$.currentTime();
        if (this.isRunning().compareAndSet(false, doneWaiting) && doneWaiting) {
            try {
                this.update(false, false, outputHandler);
            }
            finally {
                this.lastStopTime_$eq(Platform$.MODULE$.currentTime());
                this.isRunning().set(false);
            }
        }
    }

    public ProgressSparkListener(String executionId, boolean isJupyterLab, OutputHandler outputHandler, Logger logger) {
        this.executionId = executionId;
        this.isJupyterLab = isJupyterLab;
        this.outputHandler = outputHandler;
        this.logger = logger;
        this.rateLimit = Duration$.MODULE$.apply(200L, TimeUnit.MILLISECONDS).toMillis();
        this.isRunning = new AtomicBoolean(false);
        this.lastStopTime = Long.MIN_VALUE;
        this.numTasks = new AtomicInteger();
        this.startedTasks = new AtomicInteger();
        this.doneTasks = new AtomicInteger();
    }
}

