/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.jupyter;

import ai.tripl.arc.api.API;
import ai.tripl.arc.jupyter.BuildInfo$;
import ai.tripl.arc.jupyter.Common;
import ai.tripl.arc.jupyter.Common$;
import ai.tripl.arc.jupyter.InMemoryLoggerAppender;
import ai.tripl.arc.plugins.LifecyclePlugin;
import ai.tripl.arc.plugins.PipelineStagePlugin;
import ai.tripl.arc.util.Utils$;
import ai.tripl.arc.util.log.LoggerFactory;
import ai.tripl.arc.util.log.logger.Logger;
import almond.interpreter.Completion;
import almond.interpreter.ExecuteResult;
import almond.interpreter.api.DisplayData$;
import almond.interpreter.api.OutputHandler;
import almond.protocol.RawJson;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Properties$;
import scala.util.control.Breaks$;
import scala.util.matching.Regex;
import scala.xml.Utility$;

public final class Common$ {
    public static Common$ MODULE$;
    private final String TABLE_COMPLETIONS_KEY;
    private final ObjectMapper objectMapper;
    private final String alpha;
    private final int size;
    private final SecureRandom secureRandom;
    private final Regex notAllowed;
    private List<Common.Completer> pipelinePluginCompletions;
    private List<Common.Completer> lifecyclePluginCompletions;

    static {
        new Common$();
    }

    public String TABLE_COMPLETIONS_KEY() {
        return this.TABLE_COMPLETIONS_KEY;
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    public Dataset<Row> createPrettyMetadataDataframe(Dataset<Row> input, SparkSession spark, Logger logger) {
        Dataset dataset;
        Dataset schemaDataframe = spark.implicits().rddToDatasetHolder(spark.sparkContext().parallelize((Seq)new .colon.colon((Object)input.schema().json(), (List)Nil$.MODULE$), spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(String.class)), spark.implicits().newStringEncoder()).toDF().as(spark.implicits().newStringEncoder());
        Dataset parsedSchema = spark.read().json(schemaDataframe);
        Dataset schemaDF = parsedSchema.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.explode(functions$.MODULE$.col("fields"))})).select("col.*", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schemaDF.columns())).contains((Object)"metadata")) {
            Column[] nonMetadataFields = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schemaDF.schema().fields())).filter((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)Common$.$anonfun$createPrettyMetadataDataframe$1(field))))).map((Function1 & Serializable & scala.Serializable)field -> functions$.MODULE$.col(field.name()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
            Column[] metadataFields = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((StructType)schemaDF.schema().fields()[schemaDF.schema().fieldIndex("metadata")].dataType()).fields())).map((Function1 & Serializable & scala.Serializable)field -> functions$.MODULE$.col(new StringBuilder(9).append("metadata.").append(field.name()).toString()).as(new StringBuilder(9).append("metadata.").append(field.name()).toString()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
            dataset = schemaDF.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nonMetadataFields)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metadataFields)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))));
        } else {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Ai_tripl_arc_jupyter_Common$$typecreator10$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Map"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)));
                }

                public Ai_tripl_arc_jupyter_Common$$typecreator10$1() {
                }
            }
            dataset = schemaDF.withColumn("metadata", functions$.MODULE$.typedLit((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ai_tripl_arc_jupyter_Common$$typecreator10$1())));
        }
        Dataset output = dataset;
        output.cache().count();
        return output;
    }

    public String getHelp() {
        return new StringOps(Predef$.MODULE$.augmentString("\n    |Commands:\n    |\n    |%conf\n    |Set global Configuration Parameters which will apply to all cells.\n    |\n    |%env\n    |Set variables for this session. E.g. ETL_CONF_BASE_DIR=/home/jovyan/tutorial\n    |\n    |%help\n    |Display this help text.\n    |\n    |%list\n    |Show a list of files in a target directory\n    |\n    |%metadata\n    |[view]\n    |Create an Arc metadata dataset for the input view\n    |\n    |%printmetadata\n    |[view]\n    |Display a JSON formatted Arc metadata schema for the input view\n    |\n    |%printschema\n    |[view]\n    |Display a printable basic schema for the input view\n    |\n    |%schema\n    |[view]\n    |Display a JSON formatted schema for the input view\n    |\n    |%secret\n    |Set secrets for this session. E.g. ETL_CONF_SECRET\n    |\n    |%version\n    |Display Arc and Arc-Jupyter version information.\n    |\n    |\n    |Configuration Parameters:\n    |master:            The address of the Spark master (if connecting to a remote cluster)\n    |streaming:         Set the notebook into streaming mode (boolean)\n    |streamingDuration: How many seconds to execute a streaming stage before stopping (will stop if numRows is reached first).\n    |\n    |Display Parameters:\n    |datasetLabels:     Display labels with the name of the registered table name\n    |extendedErrors:    Show more verbose errors.\n    |leftAlign:         Left-align output datasets\n    |logger:            Show Arc logs as part of the result set.\n    |monospace:         Use a fixed-width font\n    |numRows:           The maximum number of rows to return in a dataset (integer)\n    |truncate:          The maximum number of characters displayed in a string result (integer)\n    ")).stripMargin();
    }

    public String getVersion(SparkSession spark, API.ARCContext arcContext) {
        long physicalMemory = ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize();
        long runtimeMemory = Runtime.getRuntime().maxMemory();
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(238).append("\n    |spark: ").append(spark.version()).append("\n    |arc: ").append(ai.tripl.arc.ArcBuildInfo.BuildInfo$.MODULE$.version()).append("\n    |arc-jupyter: ").append(BuildInfo$.MODULE$.version()).append("\n    |scala: ").append(Properties$.MODULE$.versionNumberString()).append("\n    |java: ").append(System.getProperty("java.runtime.version")).append("\n    |runtimeMemory: ").append(runtimeMemory).append("B\n    |physicalMemory: ").append(physicalMemory).append("B\n    |dynamicConfigurationPlugins:\n    |").append(((TraversableOnce)((SeqLike)arcContext.dynamicConfigurationPlugins().map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(4).append(" - ").append(c.getClass().getName()).append(":").append(c.version()).toString(), List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).append("\n    |pipelinePlugins:\n    |").append(((TraversableOnce)((SeqLike)arcContext.pipelineStagePlugins().map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(4).append(" - ").append(c.getClass().getName()).append(":").append(c.version()).toString(), List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).append("\n    |lifecyclePlugins:\n    |").append(((TraversableOnce)((SeqLike)arcContext.lifecyclePlugins().map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(4).append(" - ").append(c.getClass().getName()).append(":").append(c.version()).toString(), List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).append("\n    |udfPlugins:\n    |").append(((TraversableOnce)((SeqLike)arcContext.udfPlugins().map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(4).append(" - ").append(c.getClass().getName()).append(":").append(c.version()).toString(), List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).append("\n    ").toString())).stripMargin();
    }

    /*
     * WARNING - void declaration
     */
    public String injectParameters(String sql, Map<String, String> params) {
        void var3_3;
        String stmt = (String)params.foldLeft((Object)sql, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            String stmt;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    stmt = (String)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String matchPlaceholderRegex = new StringBuilder(26).append("[$][{]\\s*").append(k).append("\\s*(?:=[^}]+)?[}]").toString();
            String string = new StringOps(Predef$.MODULE$.augmentString(matchPlaceholderRegex)).r().replaceAllIn((CharSequence)stmt, v);
            return string;
        });
        return var3_3;
    }

    public ExecuteResult renderResult(SparkSession spark, Option<OutputHandler> outputHandler, Option<API.PipelineStage> stage, Dataset<Row> df, InMemoryLoggerAppender inMemoryLoggerAppender, int numRows, int maxNumRows, int truncate, boolean monospace, boolean leftAlign, boolean datasetLabels, int streamingDuration, int confStreamingFrequency, boolean confShowLog) {
        ExecuteResult.Success success;
        if (!df.isStreaming()) {
            success = new ExecuteResult.Success(DisplayData$.MODULE$.html(this.renderHTML(df, (Option<InMemoryLoggerAppender>)Option$.MODULE$.apply((Object)inMemoryLoggerAppender), stage, numRows, maxNumRows, truncate, monospace, leftAlign, datasetLabels, confShowLog)));
        } else {
            ExecuteResult.Error error;
            Option<OutputHandler> option = outputHandler;
            if (option instanceof Some) {
                Some some = (Some)option;
                OutputHandler outputHandler2 = (OutputHandler)some.value();
                String outputElementHandle = this.randStr(32);
                String queryName = this.randStr(32);
                StreamingQuery writeStream = df.writeStream().format("memory").outputMode("append").queryName(queryName).start();
                long endTime = System.currentTimeMillis() + (long)(streamingDuration * 1000);
                BooleanRef initial = BooleanRef.create((boolean)true);
                Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    while (System.currentTimeMillis() <= endTime) {
                        Dataset df = spark.table(queryName);
                        df.persist();
                        long count = df.count();
                        if (initial$1.elem) {
                            outputHandler2.html(MODULE$.renderHTML((Dataset<Row>)df, (Option<InMemoryLoggerAppender>)None$.MODULE$, (Option<API.PipelineStage>)None$.MODULE$, numRows, maxNumRows, truncate, monospace, leftAlign, datasetLabels, confShowLog), outputElementHandle);
                            initial$1.elem = false;
                        } else {
                            outputHandler2.updateHtml(MODULE$.renderHTML((Dataset<Row>)df, (Option<InMemoryLoggerAppender>)None$.MODULE$, (Option<API.PipelineStage>)None$.MODULE$, numRows, maxNumRows, truncate, monospace, leftAlign, datasetLabels, confShowLog), outputElementHandle);
                        }
                        df.unpersist();
                        if (count > (long)numRows) {
                            throw Breaks$.MODULE$.break();
                        }
                        Thread.sleep(confStreamingFrequency);
                    }
                });
                writeStream.stop();
                outputHandler2.html("", outputElementHandle);
                error = new ExecuteResult.Success(DisplayData$.MODULE$.html(this.renderHTML((Dataset<Row>)spark.table(queryName), (Option<InMemoryLoggerAppender>)Option$.MODULE$.apply((Object)inMemoryLoggerAppender), (Option<API.PipelineStage>)None$.MODULE$, numRows, maxNumRows, truncate, monospace, leftAlign, datasetLabels, confShowLog)));
            } else if (None$.MODULE$.equals(option)) {
                error = ExecuteResult.Error$.MODULE$.apply("No result.");
            } else {
                throw new MatchError(option);
            }
            success = error;
        }
        return success;
    }

    public String renderText(String text, InMemoryLoggerAppender inMemoryLoggerAppender, boolean confShowLog) {
        String string;
        String html = new StringBuilder(11).append("<pre>").append(text).append("</pre>").toString();
        if (confShowLog) {
            HashMap message = (HashMap)this.objectMapper().readValue((String)inMemoryLoggerAppender.getResult().last(), HashMap.class);
            String reformatted = this.objectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)message).replaceAll("\n", " ").replaceAll("\\s\\s+", " ").replaceAll("\" :", "\":").replaceAll("\\{ ", "{").replaceAll(" \\}", "}").replaceAll("\\[ ", "[").replaceAll(" \\]", "]");
            string = new StringBuilder(49).append(html).append("<div class=\"log tex2jax_ignore\"><div>").append(reformatted).append("</div></div>").toString();
        } else {
            string = html;
        }
        return string;
    }

    public String renderHTML(Dataset<Row> df, Option<InMemoryLoggerAppender> inMemoryLoggerAppender, Option<API.PipelineStage> stage, int numRows, int maxNumRows, int truncate, boolean monospace, boolean leftAlign, boolean datasetLabels, boolean confShowLog) {
        String string;
        String string2;
        String leftAlignClass;
        String[] header = df.columns();
        Dataset renamedDF = df.toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.columns())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String col = (String)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            String string = new StringBuilder(0).append(col).append(idx).toString();
            return string;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))));
        Seq castCols = (Seq)renamedDF.schema().map((Function1 & Serializable & scala.Serializable)field -> {
            Column column;
            String fieldName = new StringBuilder(2).append("`").append(field.name()).append("`").toString();
            DataType dataType = field.dataType();
            if (BinaryType$.MODULE$.equals(dataType)) {
                column = functions$.MODULE$.col(fieldName);
            } else if (DoubleType$.MODULE$.equals(dataType)) {
                column = functions$.MODULE$.regexp_replace(functions$.MODULE$.regexp_replace(functions$.MODULE$.regexp_replace(functions$.MODULE$.format_number(functions$.MODULE$.col(fieldName), 10), ",", ""), "(?<=.[0-9]{2})0+$", ""), "^\\.", "0.");
            } else if (dataType instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)dataType;
                column = functions$.MODULE$.regexp_replace(functions$.MODULE$.format_number(functions$.MODULE$.col(fieldName), decimalType.scale()), ",", "");
            } else {
                column = TimestampType$.MODULE$.equals(dataType) ? functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(fieldName).cast((DataType)StringType$.MODULE$), functions$.MODULE$.lit((Object)"Z")})) : (DateType$.MODULE$.equals(dataType) ? functions$.MODULE$.date_format(functions$.MODULE$.col(fieldName), "yyyy-MM-dd") : functions$.MODULE$.col(fieldName).cast((DataType)StringType$.MODULE$));
            }
            return column;
        }, Seq$.MODULE$.canBuildFrom());
        Row[] data = (Row[])renamedDF.select(castCols).take(Math.min(numRows, maxNumRows));
        Seq[] rows = (Seq[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data)).map((Function1 & Serializable & scala.Serializable)row -> (Seq)row.toSeq().map((Function1 & Serializable & scala.Serializable)cell -> {
            void var3_5;
            String string;
            Object object = cell;
            if (object == null) {
                string = "null";
            } else if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                string = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(byArray)).map((Function1 & Serializable & scala.Serializable)x$1 -> Common$.$anonfun$renderHTML$5(BoxesRunTime.unboxToByte((Object)x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("[", " ", "]");
            } else {
                string = cell.toString();
            }
            String str = string;
            return truncate > 0 && str.length() > truncate ? (truncate < 4 ? str.substring(0, truncate) : new StringBuilder(3).append(str.substring(0, truncate - 3)).append("...").toString()) : var3_5;
        }, Seq$.MODULE$.canBuildFrom()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)));
        String monospaceClass = monospace ? "monospace" : "";
        String string3 = leftAlignClass = leftAlign ? "leftalign" : "";
        if (datasetLabels) {
            Object object;
            String string4;
            Object object2;
            String string5;
            Option<API.PipelineStage> option = stage;
            if (option instanceof Some) {
                Some some = (Some)option;
                API.PipelineStage stage2 = (API.PipelineStage)some.value();
                Option inputView = Common$.liftedTree1$1(stage2);
                Option outputView = Common$.liftedTree2$1(stage2);
                string5 = new Tuple2((Object)inputView, (Object)outputView);
            } else if (None$.MODULE$.equals(option)) {
                string5 = "";
            } else {
                throw new MatchError(option);
            }
            String string6 = string5;
            if (!(string6 instanceof Tuple2)) {
                throw new MatchError((Object)string6);
            }
            Tuple2 tuple2 = (Tuple2)string6;
            Object inputView = tuple2._1();
            Object outputView = tuple2._2();
            Tuple2 tuple22 = new Tuple2(inputView, outputView);
            Tuple2 tuple23 = tuple22;
            Object inputView2 = tuple23._1();
            Object outputView2 = tuple23._2();
            Tuple2 tuple24 = new Tuple2(inputView2, outputView2);
            if (tuple24 != null && (object2 = tuple24._2()) instanceof Some) {
                Some some = (Some)object2;
                Object ouputView = some.value();
                string4 = new StringBuilder(31).append("<div class=\"table_name ").append((Object)(monospace ? "monospace" : "")).append("\">").append(ouputView).append("</div>").toString();
            } else if (tuple24 != null && (object = tuple24._1()) instanceof Some) {
                Some some = (Some)object;
                Object inputView3 = some.value();
                string4 = new StringBuilder(31).append("<div class=\"table_name ").append((Object)(monospace ? "monospace" : "")).append("\">").append(inputView3).append("</div>").toString();
            } else {
                string4 = "";
            }
            string2 = string4;
        } else {
            string2 = "";
        }
        String label = string2;
        String table = new StringBuilder(79).append(label).append("<table class=\"tex2jax_ignore ").append(monospaceClass).append(" ").append(leftAlignClass).append("\"><thead><tr>").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])header)).map((Function1 & Serializable & scala.Serializable)h -> new StringBuilder(9).append("<th>").append(Utility$.MODULE$.escape(h)).append("</th>").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString()).append("</tr></thead><tbody>").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).map((Function1 & Serializable & scala.Serializable)row -> new StringBuilder(9).append("<tr>").append(((TraversableOnce)row.map((Function1 & Serializable & scala.Serializable)cell -> new StringBuilder(9).append("<td>").append(Utility$.MODULE$.escape(cell)).append("</td>").toString(), Seq$.MODULE$.canBuildFrom())).mkString()).append("</tr>").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString()).append("</tbody></table>").toString();
        if (confShowLog && inMemoryLoggerAppender.isDefined()) {
            HashMap message = (HashMap)this.objectMapper().readValue((String)((InMemoryLoggerAppender)((Object)inMemoryLoggerAppender.get())).getResult().last(), HashMap.class);
            String reformatted = this.objectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)message).replaceAll("\n", " ").replaceAll("\\s\\s+", " ").replaceAll("\" :", "\":").replaceAll("\\{ ", "{").replaceAll(" \\}", "}").replaceAll("\\[ ", "[").replaceAll(" \\]", "]");
            string = new StringBuilder(49).append(table).append("<div class=\"log tex2jax_ignore\"><div>").append(reformatted).append("</div></div>").toString();
        } else {
            string = table;
        }
        return string;
    }

    public String alpha() {
        return this.alpha;
    }

    public int size() {
        return this.size;
    }

    public SecureRandom secureRandom() {
        return this.secureRandom;
    }

    public String randStr(int n) {
        return ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), n).map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(Common$.MODULE$.alpha()), RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(Common$.MODULE$.secureRandom().nextInt())) % Common$.MODULE$.size())), IndexedSeq$.MODULE$.canBuildFrom())).mkString();
    }

    public Regex notAllowed() {
        return this.notAllowed;
    }

    public Seq<Seq<String>> flattenSchema(StructType schema, Seq<String> parents) {
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StructField structField = x0$1;
            if (structField != null) {
                String name = structField.name();
                DataType inner = structField.dataType();
                if (inner instanceof StructType) {
                    StructType structType = (StructType)inner;
                    return (Seq)((TraversableLike)new .colon.colon((Object)((Seq)parents.$plus$plus((GenTraversableOnce)new .colon.colon((Object)this.escape$1(name), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())), (List)Nil$.MODULE$)).$plus$plus(MODULE$.flattenSchema(structType, (Seq<String>)((Seq)parents.$plus$plus((GenTraversableOnce)new .colon.colon((Object)this.escape$1(name), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom()))), Seq$.MODULE$.canBuildFrom());
                }
            }
            if (structField == null) throw new MatchError((Object)structField);
            String name = structField.name();
            return (Seq)new .colon.colon((Object)((Seq)parents.$plus$plus((GenTraversableOnce)new .colon.colon((Object)this.escape$1(name), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())), (List)Nil$.MODULE$);
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Seq<String> flattenSchema$default$2() {
        return (Seq)Nil$.MODULE$;
    }

    public List<Common.Completer> pipelinePluginCompletions() {
        return this.pipelinePluginCompletions;
    }

    public void pipelinePluginCompletions_$eq(List<Common.Completer> x$1) {
        this.pipelinePluginCompletions = x$1;
    }

    public List<Common.Completer> lifecyclePluginCompletions() {
        return this.lifecyclePluginCompletions;
    }

    public void lifecyclePluginCompletions_$eq(List<Common.Completer> x$1) {
        this.lifecyclePluginCompletions = x$1;
    }

    public Seq<Common.Completer> makeJupyterCompletions(String completionEnvironments) {
        return (Seq)new .colon.colon((Object)new Common.Completer("%log", "execute", new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(161).append("%log name=\"log\" environments=").append(completionEnvironments).append("\n        |SELECT\n        |  TO_JSON(\n        |    NAMED_STRUCT(\n        |      'key', 'value'\n        |    )\n        |  ) AS message").toString())).stripMargin(), "sql", "https://arc.tripl.ai/execute/#logexecute"), (List)new .colon.colon((Object)new Common.Completer("%configexecute", "execute", new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(184).append("%configexecute name=\"configexecute\" environments=").append(completionEnvironments).append("\n        |SELECT\n        |  TO_JSON(\n        |    NAMED_STRUCT(\n        |      'key', 'value'\n        |    )\n        |  ) AS parameters").toString())).stripMargin(), "sql", "https://arc.tripl.ai/execute/#configexecute"), (List)new .colon.colon((Object)new Common.Completer("%metadatafilter", "transform", new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(154).append("%metadatafilter name=\"metadatafiltertransform\" inputView=inputView outputView=outputView environments=").append(completionEnvironments).append("\n        |SELECT\n        |  *\n        |FROM metadata").toString())).stripMargin(), "sql", "https://arc.tripl.ai/transform/#metadatafiltertransform"), (List)new .colon.colon((Object)new Common.Completer("%metadatavalidate", "validate", new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(391).append("%metadatavalidate name=\"metadatavalidate\" inputView=inputView environments=").append(completionEnvironments).append("\n        |SELECT\n        |  SUM(test) = 0\n        |  ,TO_JSON(\n        |    NAMED_STRUCT(\n        |      'columns', COUNT(*),\n        |      'test', SUM(test)\n        |    )\n        |  )\n        |FROM (\n        |  SELECT\n        |    CASE WHEN TRUE THEN 1 ELSE 0 END AS test\n        |  FROM metadata\n        |) valid").toString())).stripMargin(), "sql", "https://arc.tripl.ai/validate/#metadatavalidate"), (List)new .colon.colon((Object)new Common.Completer("%sql", "transform", new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(113).append("%sql name=\"sqltransform\" outputView=outputView environments=").append(completionEnvironments).append("\n        |SELECT\n        |  *\n        |FROM inputView").toString())).stripMargin(), "sql", "https://arc.tripl.ai/transform/#sqltransform"), (List)new .colon.colon((Object)new Common.Completer("%sqlvalidate", "validate", new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(203).append("%sqlvalidate name=\"sqlvalidate\" environments=").append(completionEnvironments).append("\n        |SELECT\n        |  TRUE AS valid\n        |  ,TO_JSON(\n        |    NAMED_STRUCT(\n        |      'key', 'value'\n        |    )\n        |  ) AS message").toString())).stripMargin(), "sql", "https://arc.tripl.ai/validate/#sqlvalidate"), (List)new .colon.colon((Object)new Common.Completer("%version", "arc", new StringOps(Predef$.MODULE$.augmentString("%version")).stripMargin(), "shell", ""), (List)Nil$.MODULE$)))))));
    }

    public Completion getCompletions(int pos, int length, Map<String, Common.ConfigValue> commandLineArgs, boolean confDatasetLabels, boolean confExtendedErrors, boolean confLeftAlign, boolean confShowLog, boolean confMonospace, int confNumRows, int confTruncate, boolean confStreaming, int confStreamingDuration, String confCompletionEnvironments, SparkSession spark, API.ARCContext arcContext) {
        Seq seq;
        Seq jupyterCompletions = this.makeJupyterCompletions(confCompletionEnvironments);
        if (arcContext == null) {
            seq = jupyterCompletions;
        } else {
            if (this.pipelinePluginCompletions().length() == 0) {
                this.pipelinePluginCompletions_$eq((List<Common.Completer>)((List)arcContext.pipelineStagePlugins().flatMap((Function1 & Serializable & scala.Serializable)stage -> {
                    Iterable iterable;
                    PipelineStagePlugin pipelineStagePlugin = stage;
                    if (pipelineStagePlugin instanceof API.JupyterCompleter) {
                        PipelineStagePlugin pipelineStagePlugin2 = pipelineStagePlugin;
                        iterable = Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)new Common.Completer(pipelineStagePlugin2.getClass().getSimpleName(), (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pipelineStagePlugin2.getClass().getPackage().getName().split("\\."))).last(), ((API.JupyterCompleter)pipelineStagePlugin2).snippet(arcContext), ((API.JupyterCompleter)pipelineStagePlugin2).mimetype(), ((API.JupyterCompleter)pipelineStagePlugin2).documentationURI().toString())));
                    } else {
                        iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    return iterable;
                }, List$.MODULE$.canBuildFrom())));
            }
            if (this.lifecyclePluginCompletions().length() == 0) {
                this.lifecyclePluginCompletions_$eq((List<Common.Completer>)((List)arcContext.lifecyclePlugins().flatMap((Function1 & Serializable & scala.Serializable)stage -> {
                    Iterable iterable;
                    LifecyclePlugin lifecyclePlugin = stage;
                    if (lifecyclePlugin instanceof API.JupyterCompleter) {
                        LifecyclePlugin lifecyclePlugin2 = lifecyclePlugin;
                        iterable = Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)new Common.Completer(lifecyclePlugin2.getClass().getSimpleName(), (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lifecyclePlugin2.getClass().getPackage().getName().split("\\."))).last(), ((API.JupyterCompleter)lifecyclePlugin2).snippet(arcContext), ((API.JupyterCompleter)lifecyclePlugin2).mimetype(), ((API.JupyterCompleter)lifecyclePlugin2).documentationURI().toString())));
                    } else {
                        iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    return iterable;
                }, List$.MODULE$.canBuildFrom())));
            }
            .colon.colon dynamicCompletions = new .colon.colon((Object)new Common.Completer("%conf", "arc", new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(214).append("%conf\n          |datasetLabels=").append(confDatasetLabels).append("\n          |extendedErrors=").append(confExtendedErrors).append("\n          |leftAlign=").append(confLeftAlign).append("\n          |logger=").append(confShowLog).append("\n          |monospace=").append(confMonospace).append("\n          |numRows=").append(confNumRows).append("\n          |streaming=").append(confStreaming).append("\n          |streamingDuration=").append(confStreamingDuration).append("\n          |truncate=").append(confTruncate).toString())).stripMargin(), "shell", ""), (List)new .colon.colon((Object)new Common.Completer("%env", "arc", new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(16).append("%env\n          |").append(((TraversableOnce)((TraversableOnce)commandLineArgs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                Common.ConfigValue configValue = (Common.ConfigValue)tuple2._2();
                String string = new StringBuilder(1).append(key).append("=").append((Object)(configValue.secret() ? new StringOps(Predef$.MODULE$.augmentString("*")).$times(configValue.value().length()) : configValue.value())).toString();
                return string;
            }, Iterable$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).toString())).stripMargin(), "shell", ""), (List)Nil$.MODULE$));
            if (arcContext.userData().contains((Object)this.TABLE_COMPLETIONS_KEY())) {
                List tableCompletions = (List)arcContext.userData().get((Object)this.TABLE_COMPLETIONS_KEY()).get();
                seq = (Seq)((List)((List)((List)this.pipelinePluginCompletions().$plus$plus(this.lifecyclePluginCompletions(), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)jupyterCompletions, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)dynamicCompletions, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)tableCompletions, List$.MODULE$.canBuildFrom());
            } else {
                seq = (Seq)((List)((List)this.pipelinePluginCompletions().$plus$plus(this.lifecyclePluginCompletions(), List$.MODULE$.canBuildFrom())).$plus$plus(jupyterCompletions, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)dynamicCompletions, List$.MODULE$.canBuildFrom());
            }
        }
        Seq completions = seq;
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNodeFactory jsonNodeFactory = new JsonNodeFactory(true);
        ObjectNode node = jsonNodeFactory.objectNode();
        ArrayNode jupyterTypesArray = node.putArray("_jupyter_types_experimental");
        completions.foreach((Function1 & Serializable & scala.Serializable)completion -> {
            ObjectNode completionNode = jsonNodeFactory.objectNode();
            completionNode.set("text", (JsonNode)jsonNodeFactory.textNode(completion.text()));
            completionNode.set("type", (JsonNode)jsonNodeFactory.textNode(completion.textType()));
            completionNode.set("replaceText", (JsonNode)jsonNodeFactory.textNode(completion.replaceText()));
            completionNode.set("language", (JsonNode)jsonNodeFactory.textNode(completion.language()));
            completionNode.set("documentation", (JsonNode)jsonNodeFactory.textNode(completion.documentation()));
            completionNode.set("sortBy", (JsonNode)jsonNodeFactory.textNode(new StringBuilder(1).append(completion.textType()).append(":").append(completion.text()).toString()));
            return jupyterTypesArray.add((JsonNode)completionNode);
        });
        return new Completion(0, length, (Seq)completions.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.text(), Seq$.MODULE$.canBuildFrom()), new RawJson(objectMapper.writeValueAsString((Object)node).getBytes(StandardCharsets.UTF_8)));
    }

    public Map<String, String> getPropertiesFromFile(String filename) {
        Map map;
        File file = new File(filename);
        Predef$.MODULE$.require(file.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Properties file ").append(file).append(" does not exist").toString());
        Predef$.MODULE$.require(file.isFile(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Properties file ").append(file).append(" is not a normal file").toString());
        try (InputStreamReader inReader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            try {
                Properties properties = new Properties();
                properties.load(inReader);
                map = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(properties.stringPropertyNames()).asScala()).map((Function1 & Serializable & scala.Serializable)k -> new Tuple2(k, (Object)MODULE$.trimExceptCRLF(properties.getProperty((String)k))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            }
            catch (IOException e) {
                throw new Exception(new StringBuilder(42).append("Failed when loading Spark properties from ").append(filename).toString(), e);
            }
        }
        return map;
    }

    public String trimExceptCRLF(String str) {
        Function1 & Serializable & scala.Serializable nonSpaceOrNaturalLineDelimiter = (Function1 & Serializable & scala.Serializable)ch -> BoxesRunTime.boxToBoolean((boolean)Common$.$anonfun$trimExceptCRLF$1(BoxesRunTime.unboxToChar((Object)ch)));
        int firstPos = new StringOps(Predef$.MODULE$.augmentString(str)).indexWhere((Function1)nonSpaceOrNaturalLineDelimiter);
        int lastPos = new StringOps(Predef$.MODULE$.augmentString(str)).lastIndexWhere((Function1)nonSpaceOrNaturalLineDelimiter);
        return firstPos >= 0 && lastPos >= 0 ? str.substring(firstPos, lastPos + 1) : "";
    }

    public Logger getLogger(Option<InMemoryLoggerAppender> appender, SparkSession spark) {
        ClassLoader loader = Utils$.MODULE$.getContextOrSparkClassLoader();
        Logger logger = LoggerFactory.getLogger((String)spark.sparkContext().applicationId());
        org.apache.log4j.Logger.getLogger((String)"org").setLevel(Level.ERROR);
        org.apache.log4j.Logger.getLogger((String)"breeze").setLevel(Level.ERROR);
        appender.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            Common$.$anonfun$getLogger$1(spark, x$4);
            return BoxedUnit.UNIT;
        });
        return logger;
    }

    public Option<InMemoryLoggerAppender> getLogger$default$1() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$createPrettyMetadataDataframe$1(StructField field) {
        String string = field.name();
        String string2 = "metadata";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ String $anonfun$renderHTML$5(byte x$1) {
        return new StringOps(Predef$.MODULE$.augmentString("%02X")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)x$1)}));
    }

    private static final /* synthetic */ Option liftedTree1$1(API.PipelineStage stage$1) {
        None$ none$;
        try {
            None$ none$2;
            Some some;
            Object stageName;
            Object object = stage$1.getClass().getMethod("inputView", new Class[0]).invoke((Object)stage$1, new Object[0]);
            if (object instanceof Some && (stageName = (some = (Some)object).value()) instanceof String) {
                String string = (String)stageName;
                none$2 = Option$.MODULE$.apply((Object)string);
            } else if (object instanceof String) {
                String string = (String)object;
                none$2 = Option$.MODULE$.apply((Object)string);
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        catch (Exception e) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private static final /* synthetic */ Option liftedTree2$1(API.PipelineStage stage$1) {
        None$ none$;
        try {
            None$ none$2;
            Some some;
            Object stageName;
            Object object = stage$1.getClass().getMethod("outputView", new Class[0]).invoke((Object)stage$1, new Object[0]);
            if (object instanceof Some && (stageName = (some = (Some)object).value()) instanceof String) {
                String string = (String)stageName;
                none$2 = Option$.MODULE$.apply((Object)string);
            } else if (object instanceof String) {
                String string = (String)object;
                none$2 = Option$.MODULE$.apply((Object)string);
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        catch (Exception e) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private final String escape$1(String name) {
        return this.notAllowed().findFirstMatchIn((CharSequence)name).isEmpty() ? name : new StringBuilder(2).append("`").append(name).append("`").toString();
    }

    public static final /* synthetic */ boolean $anonfun$trimExceptCRLF$1(char ch) {
        return ch > ' ' || ch == '\r' || ch == '\n';
    }

    public static final /* synthetic */ void $anonfun$getLogger$1(SparkSession spark$2, InMemoryLoggerAppender x$4) {
        org.apache.log4j.Logger.getLogger((String)spark$2.sparkContext().applicationId()).addAppender((Appender)x$4);
    }

    private Common$() {
        MODULE$ = this;
        this.TABLE_COMPLETIONS_KEY = "ai.tripl.arc.jupyter.tableCompletions";
        this.objectMapper = new ObjectMapper();
        this.alpha = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        this.size = new StringOps(Predef$.MODULE$.augmentString(this.alpha())).size();
        this.secureRandom = new SecureRandom();
        this.notAllowed = new StringOps(Predef$.MODULE$.augmentString("([^abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_])")).r();
        this.pipelinePluginCompletions = List$.MODULE$.empty();
        this.lifecyclePluginCompletions = List$.MODULE$.empty();
    }
}

