/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.execute;

import ai.tripl.arc.api.API;
import ai.tripl.arc.execute.KafkaCommitExecute;
import ai.tripl.arc.execute.KafkaCommitExecuteStage;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.log.logger.Logger;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple7;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;

public final class KafkaCommitExecuteStage$
implements scala.Serializable {
    public static KafkaCommitExecuteStage$ MODULE$;

    static {
        new KafkaCommitExecuteStage$();
    }

    public Option<Dataset<Row>> execute(KafkaCommitExecuteStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        Dataset df = spark.table(stage.inputView());
        HashMap offsetsLogMap = new HashMap();
        try {
            Dataset offset = df.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{df.apply("topic"), df.apply("partition")})).agg(functions$.MODULE$.max(df.apply("offset")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{df.apply("topic"), df.apply("partition")})).limit(10000);
            Properties props = new Properties();
            props.put("bootstrap.servers", stage.bootstrapServers());
            props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
            props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
            props.put("enable.auto.commit", "false");
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])offset.collect())).foreach((Function1 & Serializable & scala.Serializable)row -> {
                Option option;
                String topic = row.getString(0);
                int partitionId = row.getInt(1);
                long offset = row.getLong(2) + 1L;
                props.put("group.id", new StringBuilder(1).append(stage.groupID()).append("-").append(partitionId).toString());
                try (KafkaConsumer kafkaConsumer = new KafkaConsumer(props);){
                    HashMap<TopicPartition, OffsetAndMetadata> offsetsMap = new HashMap<TopicPartition, OffsetAndMetadata>();
                    offsetsMap.put(new TopicPartition(topic, partitionId), new OffsetAndMetadata(offset));
                    kafkaConsumer.commitSync(offsetsMap);
                    offsetsLogMap.put(new StringBuilder(1).append(stage.groupID()).append("-").append(partitionId).toString(), offset);
                    option = stage.stageDetail().put((Object)"offsets", (Object)offsetsLogMap);
                }
                return option;
            });
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$1.stageDetail();
                }
            };
        }
        return None$.MODULE$;
    }

    public KafkaCommitExecuteStage apply(KafkaCommitExecute plugin, String name, Option<String> description, String inputView, String bootstrapServers, String groupID, scala.collection.immutable.Map<String, String> params) {
        return new KafkaCommitExecuteStage(plugin, name, description, inputView, bootstrapServers, groupID, params);
    }

    public Option<Tuple7<KafkaCommitExecute, String, Option<String>, String, String, String, scala.collection.immutable.Map<String, String>>> unapply(KafkaCommitExecuteStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7((Object)x$0.plugin(), (Object)x$0.name(), x$0.description(), (Object)x$0.inputView(), (Object)x$0.bootstrapServers(), (Object)x$0.groupID(), x$0.params()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private KafkaCommitExecuteStage$() {
        MODULE$ = this;
    }
}

