/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.extract;

import ai.tripl.arc.api.API;
import ai.tripl.arc.extract.MongoDBExtract;
import ai.tripl.arc.extract.MongoDBExtractStage;
import ai.tripl.arc.util.CloudUtils$;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.ExtractUtils$;
import ai.tripl.arc.util.MetadataUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import com.mongodb.spark.config.ReadConfig;
import com.mongodb.spark.config.ReadConfig$;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple12;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public final class MongoDBExtractStage$
implements scala.Serializable {
    public static MongoDBExtractStage$ MODULE$;

    static {
        new MongoDBExtractStage$();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Option<Dataset<Row>> execute(MongoDBExtractStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        BoxedUnit boxedUnit;
        Dataset repartitionedDF;
        Dataset dataset;
        Dataset dataset2;
        Dataset dataset3;
        Dataset dataset4;
        Option option;
        if (arcContext.isStreaming()) {
            throw new DetailException(stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$1.stageDetail();
                }
            };
        }
        try {
            option = ExtractUtils$.MODULE$.getSchema(stage.schema(), spark, logger);
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$1.stageDetail();
                }
            };
        }
        Option optionSchema = option;
        CloudUtils$.MODULE$.setHadoopConfiguration(stage.authentication(), spark, logger, arcContext);
        try {
            dataset4 = spark.read().format("com.mongodb.spark.sql").options(((ReadConfig)ReadConfig$.MODULE$.apply(stage.options())).asOptions()).load();
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$1.stageDetail();
                }
            };
        }
        Dataset df = dataset4;
        try {
            if (df.schema().length() == 0) {
                stage.stageDetail().put((Object)"records", (Object)0);
                Option option2 = optionSchema;
                if (!(option2 instanceof Some)) {
                    if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
                    throw new Exception("MongoDBExtract has produced 0 columns and no schema has been provided to create an empty dataframe.");
                }
                Some some = (Some)option2;
                StructType s = (StructType)some.value();
                dataset3 = spark.createDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), s);
            } else {
                dataset3 = df;
            }
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$1.stageDetail();
                }
            };
        }
        Dataset emptyDataframeHandlerDF = dataset3;
        Option option3 = optionSchema;
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            StructType schema = (StructType)some.value();
            dataset2 = MetadataUtils$.MODULE$.setMetadata(emptyDataframeHandlerDF, schema, spark, logger);
        } else {
            if (!None$.MODULE$.equals(option3)) throw new MatchError((Object)option3);
            dataset2 = emptyDataframeHandlerDF;
        }
        Dataset enrichedDF = dataset2;
        List<String> list = stage.partitionBy();
        if (Nil$.MODULE$.equals(list)) {
            Option<Object> option4 = stage.numPartitions();
            if (option4 instanceof Some) {
                Some some = (Some)option4;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset = enrichedDF.repartition(numPartitions);
            } else {
                if (!None$.MODULE$.equals(option4)) throw new MatchError(option4);
                dataset = enrichedDF;
            }
        } else {
            List partitionCols = (List)list.map((Function1 & Serializable & scala.Serializable)col -> df.apply(col), List$.MODULE$.canBuildFrom());
            Option<Object> option5 = stage.numPartitions();
            if (option5 instanceof Some) {
                Some some = (Some)option5;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset = enrichedDF.repartition(numPartitions, (Seq)partitionCols);
            } else {
                if (!None$.MODULE$.equals(option5)) throw new MatchError(option5);
                dataset = repartitionedDF = enrichedDF.repartition((Seq)partitionCols);
            }
        }
        if (arcContext.immutableViews()) {
            repartitionedDF.createTempView(stage.outputView());
        } else {
            repartitionedDF.createOrReplaceTempView(stage.outputView());
        }
        if (repartitionedDF.isStreaming()) {
            boxedUnit = BoxedUnit.UNIT;
            return Option$.MODULE$.apply((Object)repartitionedDF);
        }
        stage.stageDetail().put((Object)"inputFiles", (Object)repartitionedDF.inputFiles().length);
        stage.stageDetail().put((Object)"outputColumns", (Object)repartitionedDF.schema().length());
        stage.stageDetail().put((Object)"numPartitions", (Object)repartitionedDF.rdd().partitions().length);
        if (stage.persist()) {
            repartitionedDF.persist(arcContext.storageLevel());
            boxedUnit = stage.stageDetail().put((Object)"records", (Object)repartitionedDF.count());
            return Option$.MODULE$.apply((Object)repartitionedDF);
        }
        boxedUnit = BoxedUnit.UNIT;
        return Option$.MODULE$.apply((Object)repartitionedDF);
    }

    public MongoDBExtractStage apply(MongoDBExtract plugin, Option<String> id, String name, Option<String> description, Either<String, List<API.ExtractColumn>> schema, String outputView, Option<API.Authentication> authentication, scala.collection.immutable.Map<String, String> options, scala.collection.immutable.Map<String, String> params, boolean persist, Option<Object> numPartitions, List<String> partitionBy) {
        return new MongoDBExtractStage(plugin, id, name, description, schema, outputView, authentication, options, params, persist, numPartitions, partitionBy);
    }

    public Option<Tuple12<MongoDBExtract, Option<String>, String, Option<String>, Either<String, List<API.ExtractColumn>>, String, Option<API.Authentication>, scala.collection.immutable.Map<String, String>, scala.collection.immutable.Map<String, String>, Object, Option<Object>, List<String>>> unapply(MongoDBExtractStage x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple12((Object)x$0.plugin(), x$0.id(), (Object)x$0.name(), x$0.description(), x$0.schema(), (Object)x$0.outputView(), x$0.authentication(), x$0.options(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist()), x$0.numPartitions(), x$0.partitionBy()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MongoDBExtractStage$() {
        MODULE$ = this;
    }
}

