/*
 * Decompiled with CFR 0.152.
 */
package com.github.saurfang.sas.mapreduce;

import com.github.saurfang.sas.parso.ParsoWrapper$;
import com.github.saurfang.sas.parso.SasFileParserWrapper;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.LazyBoolean;

@ScalaSignature(bytes="\u0006\u0001\t-b\u0001\u0002\u001d:\u0001\u0011C\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I!\u001a\u0005\tQ\u0002\u0011\t\u0011)A\u0005S\")A\u000e\u0001C\u0001[\"A!\u000f\u0001EC\u0002\u0013\u00051\u000fC\u0004\u007f\u0001\t\u0007I\u0011B@\t\u0011\u0005E\u0001\u0001)A\u0005\u0003\u0003A\u0011\"a\u0005\u0001\u0005\u0004%I!!\u0006\t\u0011\u0005\r\u0002\u0001)A\u0005\u0003/A\u0011\"!\n\u0001\u0005\u0004%I!a\n\t\u0011\u0005U\u0002\u0001)A\u0005\u0003SA\u0011\"a\u000e\u0001\u0005\u0004%I!!\u000f\t\u0011\u00055\u0003\u0001)A\u0005\u0003wA\u0011\"a\u0014\u0001\u0005\u0004%I!!\u0015\t\u0011\u0005e\u0003\u0001)A\u0005\u0003'B\u0011\"a\u0017\u0001\u0001\u0004%I!!\u0018\t\u0013\u0005\u0015\u0004\u00011A\u0005\n\u0005\u001d\u0004\u0002CA:\u0001\u0001\u0006K!a\u0018\t\u0017\u0005U\u0004\u00011AA\u0002\u0013%\u0011q\u000f\u0005\f\u0003s\u0002\u0001\u0019!a\u0001\n\u0013\tY\b\u0003\u0006\u0002\u0000\u0001\u0001\r\u0011!Q!\nYC\u0011\"!\b\u0001\u0005\u0004%I!!!\t\u0011\u0005%\u0005\u0001)A\u0005\u0003\u0007C\u0011\"a#\u0001\u0005\u0004%I!!$\t\u0011\u0005U\u0005\u0001)A\u0005\u0003\u001fC\u0011\"a&\u0001\u0005\u0004%I!!'\t\u0011\u0005E\u0006\u0001)A\u0005\u00037C\u0011\"a-\u0001\u0005\u0004%I!!.\t\u0011\u0005\u001d\u0007\u0001)A\u0005\u0003oC\u0011\"!3\u0001\u0005\u0004%I!a3\t\u0011\u0005e\u0007\u0001)A\u0005\u0003\u001bD\u0011\"a7\u0001\u0005\u0004%I!!\u0018\t\u0011\u0005u\u0007\u0001)A\u0005\u0003?B\u0011\"a8\u0001\u0005\u0004%I!!\u0018\t\u0011\u0005\u0005\b\u0001)A\u0005\u0003?B\u0011\"a9\u0001\u0005\u0004%I!!\u0018\t\u0011\u0005\u0015\b\u0001)A\u0005\u0003?B\u0011\"a:\u0001\u0005\u0004%I!!\u0018\t\u0011\u0005%\b\u0001)A\u0005\u0003?B\u0011\"a;\u0001\u0005\u0004%I!!\u0018\t\u0011\u00055\b\u0001)A\u0005\u0003?B\u0011\"a<\u0001\u0005\u0004%I!!\u0018\t\u0011\u0005E\b\u0001)A\u0005\u0003?B\u0011\"a=\u0001\u0001\u0004%I!!\u0018\t\u0013\u0005U\b\u00011A\u0005\n\u0005]\b\u0002CA~\u0001\u0001\u0006K!a\u0018\t\u0013\u0005u\b\u00011A\u0005\n\u0005u\u0003\"CA\u0000\u0001\u0001\u0007I\u0011\u0002B\u0001\u0011!\u0011)\u0001\u0001Q!\n\u0005}\u0003b\u0002B\u0004\u0001\u0011\u0005#\u0011\u0002\u0005\b\u0005\u001f\u0001A\u0011\tB\t\u0011\u001d\u0011\u0019\u0002\u0001C!\u0005+AqAa\u0006\u0001\t\u0003\u0012I\u0002C\u0004\u0003\u001c\u0001!\tE!\b\t\u000f\t\u0015\u0002\u0001\"\u0011\u0003(!9!\u0011\u0006\u0001\u0005\n\u0005u#aD*bgJ+7m\u001c:e%\u0016\fG-\u001a:\u000b\u0005iZ\u0014!C7baJ,G-^2f\u0015\taT(A\u0002tCNT!AP \u0002\u0011M\fWO\u001d4b]\u001eT!\u0001Q!\u0002\r\u001dLG\u000f[;c\u0015\u0005\u0011\u0015aA2p[\u000e\u00011C\u0001\u0001F!\u00111e\n\u0015,\u000e\u0003\u001dS!A\u000f%\u000b\u0005%S\u0015A\u00025bI>|\u0007O\u0003\u0002L\u0019\u00061\u0011\r]1dQ\u0016T\u0011!T\u0001\u0004_J<\u0017BA(H\u00051\u0011VmY8sIJ+\u0017\rZ3s!\t\tF+D\u0001S\u0015\t\u0019\u0006*\u0001\u0002j_&\u0011QK\u0015\u0002\r\u001dVdGn\u0016:ji\u0006\u0014G.\u001a\t\u0004/jcV\"\u0001-\u000b\u0003e\u000bQa]2bY\u0006L!a\u0017-\u0003\u000b\u0005\u0013(/Y=\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017\u0001\u00027b]\u001eT\u0011!Y\u0001\u0005U\u00064\u0018-\u0003\u0002d=\n1qJ\u00196fGR\fQa\u001d9mSR\u0004\"A\u00124\n\u0005\u001d<%AC%oaV$8\u000b\u001d7ji\u000691m\u001c8uKb$\bC\u0001$k\u0013\tYwI\u0001\nUCN\\\u0017\t\u001e;f[B$8i\u001c8uKb$\u0018A\u0002\u001fj]&$h\bF\u0002oaF\u0004\"a\u001c\u0001\u000e\u0003eBQ\u0001Z\u0002A\u0002\u0015DQ\u0001[\u0002A\u0002%\f1\u0001\\8h+\u0005!\bCA;y\u001b\u00051(BA<K\u0003\u0015awn\u001a\u001bk\u0013\tIhO\u0001\u0004M_\u001e<WM\u001d\u0015\u0003\tm\u0004\"a\u0016?\n\u0005uD&!\u0003;sC:\u001c\u0018.\u001a8u\u0003%1\u0017\u000e\\3Ta2LG/\u0006\u0002\u0002\u0002A!\u00111AA\u0007\u001b\t\t)A\u0003\u0003\u0002\b\u0005%\u0011!B5oaV$(bAA\u0006\u000f\u0006\u0019A.\u001b2\n\t\u0005=\u0011Q\u0001\u0002\n\r&dWm\u00159mSR\f!BZ5mKN\u0003H.\u001b;!\u0003!1\u0017\u000e\\3QCRDWCAA\f!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000f\u0011\u0006\u0011am]\u0005\u0005\u0003C\tYB\u0001\u0003QCRD\u0017!\u00034jY\u0016\u0004\u0016\r\u001e5!\u0003\u001dQwNY\"p]\u001a,\"!!\u000b\u0011\t\u0005-\u0012\u0011G\u0007\u0003\u0003[Q1!a\fI\u0003\u0011\u0019wN\u001c4\n\t\u0005M\u0012Q\u0006\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u0011)|'mQ8oM\u0002\nQaY8eK\u000e,\"!a\u000f\u0011\u000b]\u000bi$!\u0011\n\u0007\u0005}\u0002L\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u0007\nI%\u0004\u0002\u0002F)\u0019\u0011q\t*\u0002\u0011\r|W\u000e\u001d:fgNLA!a\u0013\u0002F\t\u00012i\\7qe\u0016\u001c8/[8o\u0007>$WmY\u0001\u0007G>$Wm\u0019\u0011\u0002\u0019%\u001c8\u000b\u001d7jiR\f'\r\\3\u0016\u0005\u0005M\u0003cA,\u0002V%\u0019\u0011q\u000b-\u0003\u000f\t{w\u000e\\3b]\u0006i\u0011n]*qY&$H/\u00192mK\u0002\n1B]3d_J$7i\\;oiV\u0011\u0011q\f\t\u0004/\u0006\u0005\u0014bAA21\n!Aj\u001c8h\u0003=\u0011XmY8sI\u000e{WO\u001c;`I\u0015\fH\u0003BA5\u0003_\u00022aVA6\u0013\r\ti\u0007\u0017\u0002\u0005+:LG\u000fC\u0005\u0002rA\t\t\u00111\u0001\u0002`\u0005\u0019\u0001\u0010J\u0019\u0002\u0019I,7m\u001c:e\u0007>,h\u000e\u001e\u0011\u0002%\r,(O]3oiJ+7m\u001c:e-\u0006dW/Z\u000b\u0002-\u000612-\u001e:sK:$(+Z2pe\u00124\u0016\r\\;f?\u0012*\u0017\u000f\u0006\u0003\u0002j\u0005u\u0004\u0002CA9'\u0005\u0005\t\u0019\u0001,\u0002'\r,(O]3oiJ+7m\u001c:e-\u0006dW/\u001a\u0011\u0016\u0005\u0005\r\u0005\u0003BA\r\u0003\u000bKA!a\"\u0002\u001c\tQa)\u001b7f'f\u001cH/Z7\u0002\u0007\u0019\u001c\b%\u0001\bsC^Le\u000e];u'R\u0014X-Y7\u0016\u0005\u0005=\u0005\u0003BA\r\u0003#KA!a%\u0002\u001c\t\tbi\u0015#bi\u0006Le\u000e];u'R\u0014X-Y7\u0002\u001fI\fw/\u00138qkR\u001cFO]3b[\u0002\nqBZ5mK&s\u0007/\u001e;TiJ,\u0017-\\\u000b\u0003\u00037\u0013b!!(\u0002\"\u0006-fABAP\u0001\u0001\tYJ\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0005\u0003\u0002$\u0006\u001dVBAAS\u0015\t\u0019\u0006-\u0003\u0003\u0002*\u0006\u0015&aC%oaV$8\u000b\u001e:fC6\u0004B!!\u0007\u0002.&!\u0011qVA\u000e\u0005!\u0019V-Z6bE2,\u0017\u0001\u00054jY\u0016Le\u000e];u'R\u0014X-Y7!\u0003M\u0019w.\u001e8uS:<\u0017J\u001c9viN#(/Z1n+\t\t9\f\u0005\u0003\u0002:\u0006\rWBAA^\u0015\u0011\t9!!0\u000b\u0007M\u000byLC\u0002\u0002B*\u000bqaY8n[>t7/\u0003\u0003\u0002F\u0006m&aE\"pk:$\u0018N\\4J]B,Ho\u0015;sK\u0006l\u0017\u0001F2pk:$\u0018N\\4J]B,Ho\u0015;sK\u0006l\u0007%A\u0007tCN4\u0015\u000e\\3SK\u0006$WM]\u000b\u0003\u0003\u001b\u0004B!a4\u0002V6\u0011\u0011\u0011\u001b\u0006\u0004\u0003'\\\u0014!\u00029beN|\u0017\u0002BAl\u0003#\u0014AcU1t\r&dW\rU1sg\u0016\u0014xK]1qa\u0016\u0014\u0018AD:bg\u001aKG.\u001a*fC\u0012,'\u000fI\u0001\rQ\u0016\fG-\u001a:MK:<G\u000f[\u0001\u000eQ\u0016\fG-\u001a:MK:<G\u000f\u001b\u0011\u0002\u0015A\fw-\u001a'f]\u001e$\b.A\u0006qC\u001e,G*\u001a8hi\"\u0004\u0013!\u00039bO\u0016\u001cu.\u001e8u\u0003)\u0001\u0018mZ3D_VtG\u000fI\u0001\fG>dW/\u001c8D_VtG/\u0001\u0007d_2,XN\\\"pk:$\b%\u0001\u0005s_^\u001cu.\u001e8u\u0003%\u0011xn^\"pk:$\b%\u0001\u0006gS2,G*\u001a8hi\"\f1BZ5mK2+gn\u001a;iA\u0005Q1\u000f\u001d7jiN#\u0018M\u001d;\u0002\u001dM\u0004H.\u001b;Ti\u0006\u0014Ho\u0018\u0013fcR!\u0011\u0011NA}\u0011%\t\t\bLA\u0001\u0002\u0004\ty&A\u0006ta2LGo\u0015;beR\u0004\u0013\u0001C:qY&$XI\u001c3\u0002\u0019M\u0004H.\u001b;F]\u0012|F%Z9\u0015\t\u0005%$1\u0001\u0005\n\u0003cz\u0013\u0011!a\u0001\u0003?\n\u0011b\u001d9mSR,e\u000e\u001a\u0011\u0002\u0015%t\u0017\u000e^5bY&TX\r\u0006\u0004\u0002j\t-!Q\u0002\u0005\u0006IF\u0002\r!\u001a\u0005\u0006QF\u0002\r![\u0001\u000eO\u0016$8)\u001e:sK:$8*Z=\u0015\u0003A\u000bqbZ3u\u0007V\u0014(/\u001a8u-\u0006dW/\u001a\u000b\u0002-\u0006)1\r\\8tKR\u0011\u0011\u0011N\u0001\fO\u0016$\bK]8he\u0016\u001c8\u000f\u0006\u0002\u0003 A\u0019qK!\t\n\u0007\t\r\u0002LA\u0003GY>\fG/\u0001\u0007oKb$8*Z=WC2,X\r\u0006\u0002\u0002T\u00051q-\u001a;Q_N\u0004")
public class SasRecordReader
extends RecordReader<NullWritable, Object[]> {
    private transient Logger log;
    private final FileSplit fileSplit;
    private final Path filePath;
    private final Configuration jobConf;
    private final Option<CompressionCodec> codec;
    private final boolean isSplittable;
    private long recordCount;
    private Object[] currentRecordValue;
    private final FileSystem fs;
    private final FSDataInputStream rawInputStream;
    private final InputStream fileInputStream;
    private final CountingInputStream countingInputStream;
    private final SasFileParserWrapper sasFileReader;
    private final long headerLength;
    private final long pageLength;
    private final long pageCount;
    private final long columnCount;
    private final long rowCount;
    private final long fileLength;
    private long splitStart;
    private long splitEnd;
    private volatile transient boolean bitmap$trans$0;

    private Logger log$lzycompute() {
        SasRecordReader sasRecordReader = this;
        synchronized (sasRecordReader) {
            if (!this.bitmap$trans$0) {
                this.log = LogManager.getLogger((String)this.getClass().getName());
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    private FileSplit fileSplit() {
        return this.fileSplit;
    }

    private Path filePath() {
        return this.filePath;
    }

    private Configuration jobConf() {
        return this.jobConf;
    }

    private Option<CompressionCodec> codec() {
        return this.codec;
    }

    private boolean isSplittable() {
        return this.isSplittable;
    }

    private long recordCount() {
        return this.recordCount;
    }

    private void recordCount_$eq(long x$1) {
        this.recordCount = x$1;
    }

    private Object[] currentRecordValue() {
        return this.currentRecordValue;
    }

    private void currentRecordValue_$eq(Object[] x$1) {
        this.currentRecordValue = x$1;
    }

    private FileSystem fs() {
        return this.fs;
    }

    private FSDataInputStream rawInputStream() {
        return this.rawInputStream;
    }

    private InputStream fileInputStream() {
        return this.fileInputStream;
    }

    private CountingInputStream countingInputStream() {
        return this.countingInputStream;
    }

    private SasFileParserWrapper sasFileReader() {
        return this.sasFileReader;
    }

    private long headerLength() {
        return this.headerLength;
    }

    private long pageLength() {
        return this.pageLength;
    }

    private long pageCount() {
        return this.pageCount;
    }

    private long columnCount() {
        return this.columnCount;
    }

    private long rowCount() {
        return this.rowCount;
    }

    private long fileLength() {
        return this.fileLength;
    }

    private long splitStart() {
        return this.splitStart;
    }

    private void splitStart_$eq(long x$1) {
        this.splitStart = x$1;
    }

    private long splitEnd() {
        return this.splitEnd;
    }

    private void splitEnd_$eq(long x$1) {
        this.splitEnd = x$1;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) {
    }

    public NullWritable getCurrentKey() {
        return NullWritable.get();
    }

    public Object[] getCurrentValue() {
        return this.currentRecordValue();
    }

    public void close() {
        block1: {
            this.log().debug((Object)new StringBuilder(25).append("Read ").append(this.getPos()).append(" bytes and ").append(this.recordCount()).append(" records.").toString());
            if (this.countingInputStream() != null) {
                this.countingInputStream().close();
            }
            if (this.fileInputStream() == null) break block1;
            this.fileInputStream().close();
        }
    }

    public float getProgress() {
        long l = this.splitStart();
        float f = l == this.splitEnd() ? 0.0f : Math.min((float)(this.getPos() / (this.splitEnd() - this.splitStart())), 1.0f);
        return f;
    }

    public boolean nextKeyValue() {
        LazyBoolean readNext$lzy = new LazyBoolean();
        return this.getPos() <= this.splitEnd() - this.splitStart() ? this.readNext$1(readNext$lzy) : false;
    }

    private long getPos() {
        return this.countingInputStream().getByteCount();
    }

    private final /* synthetic */ boolean readNext$lzycompute$1(LazyBoolean readNext$lzy$1) {
        boolean bl;
        LazyBoolean lazyBoolean = readNext$lzy$1;
        synchronized (lazyBoolean) {
            boolean bl2;
            if (readNext$lzy$1.initialized()) {
                bl2 = readNext$lzy$1.value();
            } else {
                boolean bl3;
                this.currentRecordValue_$eq(new Object[(int)this.columnCount()]);
                Option recordValue = Option$.MODULE$.apply((Object)this.sasFileReader().readNext());
                if (recordValue.isDefined()) {
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])recordValue.get())).copyToArray((Object)this.currentRecordValue());
                    this.recordCount_$eq(this.recordCount() + 1L);
                    bl3 = true;
                } else {
                    bl3 = false;
                }
                bl2 = readNext$lzy$1.initialize(bl3);
            }
            bl = bl2;
        }
        return bl;
    }

    private final boolean readNext$1(LazyBoolean readNext$lzy$1) {
        return readNext$lzy$1.initialized() ? readNext$lzy$1.value() : this.readNext$lzycompute$1(readNext$lzy$1);
    }

    public SasRecordReader(InputSplit split, TaskAttemptContext context) {
        block4: {
            this.fileSplit = (FileSplit)split;
            this.filePath = this.fileSplit().getPath();
            this.jobConf = context.getConfiguration();
            this.codec = Option$.MODULE$.apply((Object)new CompressionCodecFactory(this.jobConf()).getCodec(this.filePath()));
            this.isSplittable = this.codec().isEmpty();
            this.recordCount = 0L;
            this.fs = this.filePath().getFileSystem(this.jobConf());
            this.rawInputStream = this.fs().open(this.filePath());
            this.fileInputStream = (InputStream)this.codec().map((Function1 & Serializable & scala.Serializable)codec -> codec.createInputStream((InputStream)this.rawInputStream())).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.rawInputStream());
            this.countingInputStream = new CountingInputStream(this.fileInputStream());
            this.sasFileReader = ParsoWrapper$.MODULE$.createSasFileParser((InputStream)this.countingInputStream());
            this.headerLength = this.sasFileReader().getSasFileProperties().getHeaderLength();
            this.pageLength = this.sasFileReader().getSasFileProperties().getPageLength();
            this.pageCount = this.sasFileReader().getSasFileProperties().getPageCount();
            this.columnCount = this.sasFileReader().getSasFileProperties().getColumnsCount();
            this.rowCount = this.sasFileReader().getSasFileProperties().getRowCount();
            this.fileLength = this.isSplittable() ? this.fs().getFileStatus(this.filePath()).getLen() : this.headerLength() + this.pageLength() * this.pageCount();
            this.splitStart = this.isSplittable() ? this.fileSplit().getStart() : 0L;
            this.splitEnd = this.isSplittable() ? this.splitStart() + this.fileSplit().getLength() : this.splitStart() + this.fileLength();
            this.log().debug((Object)new StringBuilder(56).append("Reading file of length ").append(this.fileLength()).append(" between ").append(this.splitStart()).append(" and ").append(this.splitEnd()).append(". (").append(this.rowCount()).append(" rows, ").append(this.columnCount()).append(" columns)").toString());
            if (this.splitStart() > 0L) {
                long partialPageLength = (this.splitStart() - this.headerLength()) % this.pageLength();
                this.splitStart_$eq(this.splitStart() - partialPageLength);
                if (partialPageLength != 0L) {
                    this.log().debug((Object)new StringBuilder(77).append("Expanded splitStart by ").append(partialPageLength).append(" bytes to start on page boundary, splitStart is now: ").append(this.splitStart()).append(".").toString());
                }
            }
            if (this.splitEnd() != this.fileLength()) {
                long partialPageLength = (this.splitEnd() - this.headerLength()) % this.pageLength();
                this.splitEnd_$eq(this.splitEnd() - partialPageLength);
                if (partialPageLength != 0L) {
                    this.log().debug((Object)new StringBuilder(69).append("Shrunk splitEnd by ").append(partialPageLength).append(" bytes to end on page boundary, splitEnd is now: ").append(this.splitEnd()).append(".").toString());
                }
            }
            if (((Seekable)this.fileInputStream()).getPos() == this.splitStart() || this.splitStart() <= 0L) break block4;
            long originalPos = ((Seekable)this.fileInputStream()).getPos();
            ((Seekable)this.fileInputStream()).seek(this.splitStart());
            this.log().debug((Object)new StringBuilder(41).append("Shifted fileInputStream to ").append(this.splitStart()).append(" offset from ").append(originalPos).append(".").toString());
            this.countingInputStream().resetByteCount();
            this.sasFileReader().readNextPage();
        }
    }
}

