/*
 * Decompiled with CFR 0.152.
 */
package com.github.saurfang.sas.spark;

import com.epam.parso.ColumnFormat;
import com.epam.parso.impl.SasFileReaderImpl;
import com.github.saurfang.sas.mapreduce.SasInputFormat;
import com.github.saurfang.sas.parso.ParsoWrapper$;
import com.github.saurfang.sas.spark.SasRelation$;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.TableScan;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple13;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r=c\u0001B-[\u0001\u0016D\u0011b \u0001\u0003\u0016\u0004%\t!!\u0001\t\u0015\u0005e\u0001A!E!\u0002\u0013\t\u0019\u0001\u0003\u0006\u0002\u001c\u0001\u0011)\u001a!C\u0001\u0003;A!\"a\u000b\u0001\u0005#\u0005\u000b\u0011BA\u0010\u0011)\ti\u0003\u0001BK\u0002\u0013\u0005\u0011q\u0006\u0005\u000b\u0003o\u0001!\u0011#Q\u0001\n\u0005E\u0002BCA\u001d\u0001\tU\r\u0011\"\u0001\u00020!Q\u00111\b\u0001\u0003\u0012\u0003\u0006I!!\r\t\u0015\u0005u\u0002A!f\u0001\n\u0003\ty\u0003\u0003\u0006\u0002@\u0001\u0011\t\u0012)A\u0005\u0003cA!\"!\u0011\u0001\u0005+\u0007I\u0011AA\"\u0011)\t\t\u0006\u0001B\tB\u0003%\u0011Q\t\u0005\u000b\u0003'\u0002!Q3A\u0005\u0002\u0005=\u0002BCA+\u0001\tE\t\u0015!\u0003\u00022!Q\u0011q\u000b\u0001\u0003\u0016\u0004%\t!a\f\t\u0015\u0005e\u0003A!E!\u0002\u0013\t\t\u0004\u0003\u0006\u0002\\\u0001\u0011)\u001a!C\u0001\u0003_A!\"!\u0018\u0001\u0005#\u0005\u000b\u0011BA\u0019\u0011)\ty\u0006\u0001BK\u0002\u0013\u0005\u0011q\u0006\u0005\u000b\u0003C\u0002!\u0011#Q\u0001\n\u0005E\u0002BCA2\u0001\tU\r\u0011\"\u0001\u0002f!Q\u0011q\r\u0001\u0003\u0012\u0003\u0006I!a\u0013\t\u0015\u0005%\u0004A!f\u0001\n\u0003\tY\u0007\u0003\u0006\u0002v\u0001\u0011\t\u0012)A\u0005\u0003[B!\"a\u001e\u0001\u0005+\u0007I\u0011AA6\u0011)\tI\b\u0001B\tB\u0003%\u0011Q\u000e\u0005\u000b\u0003w\u0002!Q1A\u0005\u0002\u0005u\u0004BCAD\u0001\t\u0005\t\u0015!\u0003\u0002\u0000!A\u0011\u0011\u0013\u0001\u0005\u0012i\u000b\u0019\n\u0003\u0006\u00028\u0002A)\u0019!C\u0001\u0003sC\u0011\"!3\u0001\u0005\u0004%\t!!\b\t\u0011\u0005-\u0007\u0001)A\u0005\u0003?Aq!!4\u0001\t\u0003\ny\rC\u0004\u0002d\u0002!I!!:\t\u000f\t\u0015\u0002\u0001\"\u0003\u0003(!I!1\b\u0001\u0002\u0002\u0013\u0005!Q\b\u0005\n\u0005;\u0002\u0011\u0013!C\u0001\u0005?B\u0011B!\u001e\u0001#\u0003%\tAa\u001e\t\u0013\tm\u0004!%A\u0005\u0002\tu\u0004\"\u0003BA\u0001E\u0005I\u0011\u0001B?\u0011%\u0011\u0019\tAI\u0001\n\u0003\u0011i\bC\u0005\u0003\u0006\u0002\t\n\u0011\"\u0001\u0003\b\"I!1\u0012\u0001\u0012\u0002\u0013\u0005!Q\u0010\u0005\n\u0005\u001b\u0003\u0011\u0013!C\u0001\u0005{B\u0011Ba$\u0001#\u0003%\tA! \t\u0013\tE\u0005!%A\u0005\u0002\tu\u0004\"\u0003BJ\u0001E\u0005I\u0011\u0001BK\u0011%\u0011I\nAI\u0001\n\u0003\u0011Y\nC\u0005\u0003 \u0002\t\n\u0011\"\u0001\u0003\u001c\"I!\u0011\u0015\u0001\u0002\u0002\u0013\u0005#1\u0015\u0005\n\u0005S\u0003\u0011\u0011!C\u0001\u0003KB\u0011Ba+\u0001\u0003\u0003%\tA!,\t\u0013\te\u0006!!A\u0005B\tm\u0006\"\u0003Bd\u0001\u0005\u0005I\u0011\u0001Be\u0011%\u0011i\rAA\u0001\n\u0003\u0012y\rC\u0005\u0003R\u0002\t\t\u0011\"\u0011\u0003T\"I!Q\u001b\u0001\u0002\u0002\u0013\u0005#q[\u0004\n\u00057T\u0016\u0011!E\u0001\u0005;4\u0001\"\u0017.\u0002\u0002#\u0005!q\u001c\u0005\b\u0003#[D\u0011\u0001Bt\u0011%\u0011\tnOA\u0001\n\u000b\u0012\u0019\u000eC\u0005\u0003jn\n\t\u0011\"!\u0003l\"I11B\u001e\u0012\u0002\u0013\u0005!q\u000f\u0005\n\u0007\u001bY\u0014\u0013!C\u0001\u0005{B\u0011ba\u0004<#\u0003%\tA! \t\u0013\rE1(%A\u0005\u0002\tu\u0004\"CB\nwE\u0005I\u0011\u0001BD\u0011%\u0019)bOI\u0001\n\u0003\u0011i\bC\u0005\u0004\u0018m\n\n\u0011\"\u0001\u0003~!I1\u0011D\u001e\u0012\u0002\u0013\u0005!Q\u0010\u0005\n\u00077Y\u0014\u0013!C\u0001\u0005{B\u0011b!\b<#\u0003%\tA!&\t\u0013\r}1(%A\u0005\u0002\tm\u0005\"CB\u0011wE\u0005I\u0011\u0001BN\u0011%\u0019\u0019cOA\u0001\n\u0003\u001b)\u0003\u0003\u0006\u00044m\n\n\u0011\"\u0005[\u0005oB!b!\u000e<#\u0003%\tB\u0017B?\u0011)\u00199dOI\u0001\n#Q&Q\u0010\u0005\u000b\u0007sY\u0014\u0013!C\t5\nu\u0004BCB\u001ewE\u0005I\u0011\u0003.\u0003\b\"Q1QH\u001e\u0012\u0002\u0013E!L! \t\u0015\r}2(%A\u0005\u0012i\u0013i\b\u0003\u0006\u0004Bm\n\n\u0011\"\u0005[\u0005{B!ba\u0011<#\u0003%\tB\u0017B?\u0011)\u0019)eOI\u0001\n#Q&Q\u0013\u0005\u000b\u0007\u000fZ\u0014\u0013!C\t5\nm\u0005BCB%wE\u0005I\u0011\u0003.\u0003\u001c\"I11J\u001e\u0002\u0002\u0013%1Q\n\u0002\f'\u0006\u001c(+\u001a7bi&|gN\u0003\u0002\\9\u0006)1\u000f]1sW*\u0011QLX\u0001\u0004g\u0006\u001c(BA0a\u0003!\u0019\u0018-\u001e:gC:<'BA1c\u0003\u00199\u0017\u000e\u001e5vE*\t1-A\u0002d_6\u001c\u0001aE\u0003\u0001MN4H\u0010\u0005\u0002hc6\t\u0001N\u0003\u0002jU\u000691o\\;sG\u0016\u001c(BA6m\u0003\r\u0019\u0018\u000f\u001c\u0006\u000376T!A\\8\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0018aA8sO&\u0011!\u000f\u001b\u0002\r\u0005\u0006\u001cXMU3mCRLwN\u001c\t\u0003ORL!!\u001e5\u0003\u0013Q\u000b'\r\\3TG\u0006t\u0007CA<{\u001b\u0005A(\"A=\u0002\u000bM\u001c\u0017\r\\1\n\u0005mD(a\u0002)s_\u0012,8\r\u001e\t\u0003ovL!A =\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u00111|7-\u0019;j_:,\"!a\u0001\u0011\t\u0005\u0015\u00111\u0003\b\u0005\u0003\u000f\ty\u0001E\u0002\u0002\nal!!a\u0003\u000b\u0007\u00055A-\u0001\u0004=e>|GOP\u0005\u0004\u0003#A\u0018A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0016\u0005]!AB*ue&twMC\u0002\u0002\u0012a\f\u0011\u0002\\8dCRLwN\u001c\u0011\u0002\u0015U\u001cXM]*dQ\u0016l\u0017-\u0006\u0002\u0002 A!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&)\fQ\u0001^=qKNLA!!\u000b\u0002$\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u0017U\u001cXM]*dQ\u0016l\u0017\rI\u0001\rKb$(/Y2u\u0019\u0006\u0014W\r\\\u000b\u0003\u0003c\u00012a^A\u001a\u0013\r\t)\u0004\u001f\u0002\b\u0005>|G.Z1o\u00035)\u0007\u0010\u001e:bGRd\u0015MY3mA\u0005\u0019bm\u001c:dK2{w/\u001a:dCN,g*Y7fg\u0006!bm\u001c:dK2{w/\u001a:dCN,g*Y7fg\u0002\nA\"\u001b8gKJ$UmY5nC2\fQ\"\u001b8gKJ$UmY5nC2\u0004\u0013!E5oM\u0016\u0014H)Z2j[\u0006d7kY1mKV\u0011\u0011Q\t\t\u0006o\u0006\u001d\u00131J\u0005\u0004\u0003\u0013B(AB(qi&|g\u000eE\u0002x\u0003\u001bJ1!a\u0014y\u0005\rIe\u000e^\u0001\u0013S:4WM\u001d#fG&l\u0017\r\\*dC2,\u0007%\u0001\u0006j]\u001a,'O\u00127pCR\f1\"\u001b8gKJ4En\\1uA\u0005A\u0011N\u001c4fe&sG/A\u0005j]\u001a,'/\u00138uA\u0005I\u0011N\u001c4fe2{gnZ\u0001\u000bS:4WM\u001d'p]\u001e\u0004\u0013AC5oM\u0016\u00148\u000b[8si\u0006Y\u0011N\u001c4feNCwN\u001d;!\u0003=iW\r^1eCR\fG+[7f_V$XCAA&\u0003AiW\r^1eCR\fG+[7f_V$\b%\u0001\u0007nS:\u001c\u0006\u000f\\5u'&TX-\u0006\u0002\u0002nA)q/a\u0012\u0002pA\u0019q/!\u001d\n\u0007\u0005M\u0004P\u0001\u0003M_:<\u0017!D7j]N\u0003H.\u001b;TSj,\u0007%\u0001\u0007nCb\u001c\u0006\u000f\\5u'&TX-A\u0007nCb\u001c\u0006\u000f\\5u'&TX\rI\u0001\u000bgFd7i\u001c8uKb$XCAA@!\u0011\t\t)a!\u000e\u0003)L1!!\"k\u0005)\u0019\u0016\u000bT\"p]R,\u0007\u0010^\u0001\fgFd7i\u001c8uKb$\b\u0005K\u0002\u001d\u0003\u0017\u00032a^AG\u0013\r\ty\t\u001f\u0002\niJ\fgn]5f]R\fa\u0001P5oSRtD\u0003HAK\u0003;\u000by*!)\u0002$\u0006\u0015\u0016qUAU\u0003W\u000bi+a,\u00022\u0006M\u0016Q\u0017\u000b\u0005\u0003/\u000bY\nE\u0002\u0002\u001a\u0002i\u0011A\u0017\u0005\b\u0003wj\u0002\u0019AA@\u0011\u0019yX\u00041\u0001\u0002\u0004!I\u00111D\u000f\u0011\u0002\u0003\u0007\u0011q\u0004\u0005\n\u0003[i\u0002\u0013!a\u0001\u0003cA\u0011\"!\u000f\u001e!\u0003\u0005\r!!\r\t\u0013\u0005uR\u0004%AA\u0002\u0005E\u0002\"CA!;A\u0005\t\u0019AA#\u0011%\t\u0019&\bI\u0001\u0002\u0004\t\t\u0004C\u0005\u0002Xu\u0001\n\u00111\u0001\u00022!I\u00111L\u000f\u0011\u0002\u0003\u0007\u0011\u0011\u0007\u0005\n\u0003?j\u0002\u0013!a\u0001\u0003cA\u0011\"a\u0019\u001e!\u0003\u0005\r!a\u0013\t\u0013\u0005%T\u0004%AA\u0002\u00055\u0004\"CA<;A\u0005\t\u0019AA7\u0003\rawnZ\u000b\u0003\u0003w\u0003B!!0\u0002D6\u0011\u0011q\u0018\u0006\u0004\u0003\u0003l\u0017!\u00027pORR\u0017\u0002BAc\u0003\u007f\u0013a\u0001T8hO\u0016\u0014\bf\u0001\u0010\u0002\f\u000611o\u00195f[\u0006\fqa]2iK6\f\u0007%A\u0005ck&dGmU2b]R\u0011\u0011\u0011\u001b\t\u0007\u0003'\fI.!8\u000e\u0005\u0005U'bAAlY\u0006\u0019!\u000f\u001a3\n\t\u0005m\u0017Q\u001b\u0002\u0004%\u0012#\u0005\u0003BAA\u0003?L1!!9k\u0005\r\u0011vn^\u0001\ta\u0006\u00148/Z*B'R1\u0011q]A}\u0005+\u0001b!!;\u0002t\u0006ug\u0002BAv\u0003_tA!!\u0003\u0002n&\t\u00110C\u0002\u0002rb\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002v\u0006](\u0001C%uKJ\fGo\u001c:\u000b\u0007\u0005E\b\u0010C\u0004\u0002|\n\u0002\r!!@\u0002\u0017I|w/\u0013;fe\u0006$xN\u001d\t\u0007\u0003S\f\u00190a@\u0011\u000b]\u0014\tA!\u0002\n\u0007\t\r\u0001PA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0003\b\tEQB\u0001B\u0005\u0015\u0011\u0011YA!\u0004\u0002\t1\fgn\u001a\u0006\u0003\u0005\u001f\tAA[1wC&!!1\u0003B\u0005\u0005\u0019y%M[3di\"9!q\u0003\u0012A\u0002\te\u0011\u0001D:dQ\u0016l\u0017MR5fY\u0012\u001c\bCBAu\u00057\u0011y\"\u0003\u0003\u0003\u001e\u0005](aA*fcB!\u0011\u0011\u0005B\u0011\u0013\u0011\u0011\u0019#a\t\u0003\u0017M#(/^2u\r&,G\u000eZ\u0001\fS:4WM]*dQ\u0016l\u0017\r\u0006\u000b\u0002 \t%\"1\u0006B\u0017\u0005_\u0011\tDa\r\u00036\t]\"\u0011\b\u0005\b\u0003[\u0019\u0003\u0019AA\u0019\u0011\u001d\tId\ta\u0001\u0003cAq!!\u0010$\u0001\u0004\t\t\u0004C\u0004\u0002B\r\u0002\r!!\u0012\t\u000f\u0005M3\u00051\u0001\u00022!9\u0011qK\u0012A\u0002\u0005E\u0002bBA.G\u0001\u0007\u0011\u0011\u0007\u0005\b\u0003?\u001a\u0003\u0019AA\u0019\u0011\u001d\t\u0019g\ta\u0001\u0003\u0017\nAaY8qsRa\"q\bB\"\u0005\u000b\u00129E!\u0013\u0003L\t5#q\nB)\u0005'\u0012)Fa\u0016\u0003Z\tmC\u0003BAL\u0005\u0003Bq!a\u001f%\u0001\u0004\ty\b\u0003\u0005\u0000IA\u0005\t\u0019AA\u0002\u0011%\tY\u0002\nI\u0001\u0002\u0004\ty\u0002C\u0005\u0002.\u0011\u0002\n\u00111\u0001\u00022!I\u0011\u0011\b\u0013\u0011\u0002\u0003\u0007\u0011\u0011\u0007\u0005\n\u0003{!\u0003\u0013!a\u0001\u0003cA\u0011\"!\u0011%!\u0003\u0005\r!!\u0012\t\u0013\u0005MC\u0005%AA\u0002\u0005E\u0002\"CA,IA\u0005\t\u0019AA\u0019\u0011%\tY\u0006\nI\u0001\u0002\u0004\t\t\u0004C\u0005\u0002`\u0011\u0002\n\u00111\u0001\u00022!I\u00111\r\u0013\u0011\u0002\u0003\u0007\u00111\n\u0005\n\u0003S\"\u0003\u0013!a\u0001\u0003[B\u0011\"a\u001e%!\u0003\u0005\r!!\u001c\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!\u0011\r\u0016\u0005\u0003\u0007\u0011\u0019g\u000b\u0002\u0003fA!!q\rB9\u001b\t\u0011IG\u0003\u0003\u0003l\t5\u0014!C;oG\",7m[3e\u0015\r\u0011y\u0007_\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B:\u0005S\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"A!\u001f+\t\u0005}!1M\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011yH\u000b\u0003\u00022\t\r\u0014AD2paf$C-\u001a4bk2$H\u0005N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIY*\"A!#+\t\u0005\u0015#1M\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00138\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIa\nabY8qs\u0012\"WMZ1vYR$\u0013(A\bd_BLH\u0005Z3gCVdG\u000fJ\u00191\u0003=\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE\nTC\u0001BLU\u0011\tYEa\u0019\u0002\u001f\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cI*\"A!(+\t\u00055$1M\u0001\u0010G>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"A!*\u0011\t\t\u001d!qU\u0005\u0005\u0003+\u0011I!\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t=&Q\u0017\t\u0004o\nE\u0016b\u0001BZq\n\u0019\u0011I\\=\t\u0013\t]F'!AA\u0002\u0005-\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003>B1!q\u0018Bc\u0005_k!A!1\u000b\u0007\t\r\u00070\u0001\u0006d_2dWm\u0019;j_:LA!!>\u0003B\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u00022\t-\u0007\"\u0003B\\m\u0005\u0005\t\u0019\u0001BX\u0003!A\u0017m\u001d5D_\u0012,GCAA&\u0003!!xn\u0015;sS:<GC\u0001BS\u0003\u0019)\u0017/^1mgR!\u0011\u0011\u0007Bm\u0011%\u00119,OA\u0001\u0002\u0004\u0011y+A\u0006TCN\u0014V\r\\1uS>t\u0007cAAMwM!1H!9}!\r9(1]\u0005\u0004\u0005KD(AB!osJ+g\r\u0006\u0002\u0003^\u0006)\u0011\r\u001d9msRa\"Q\u001eBy\u0005g\u0014)Pa>\u0003z\nm(Q B\u0000\u0007\u0003\u0019\u0019a!\u0002\u0004\b\r%A\u0003BAL\u0005_Dq!a\u001f?\u0001\u0004\ty\b\u0003\u0004\u0000}\u0001\u0007\u00111\u0001\u0005\n\u00037q\u0004\u0013!a\u0001\u0003?A\u0011\"!\f?!\u0003\u0005\r!!\r\t\u0013\u0005eb\b%AA\u0002\u0005E\u0002\"CA\u001f}A\u0005\t\u0019AA\u0019\u0011%\t\tE\u0010I\u0001\u0002\u0004\t)\u0005C\u0005\u0002Ty\u0002\n\u00111\u0001\u00022!I\u0011q\u000b \u0011\u0002\u0003\u0007\u0011\u0011\u0007\u0005\n\u00037r\u0004\u0013!a\u0001\u0003cA\u0011\"a\u0018?!\u0003\u0005\r!!\r\t\u0013\u0005\rd\b%AA\u0002\u0005-\u0003\"CA5}A\u0005\t\u0019AA7\u0011%\t9H\u0010I\u0001\u0002\u0004\ti'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIU\nq\"\u00199qYf$C-\u001a4bk2$HEN\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%o\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0003(A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u0013:\u0003A\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\n\u0004'\u0001\tbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00132c\u0005\u0001\u0012\r\u001d9ms\u0012\"WMZ1vYR$\u0013GM\u0001\u0011CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%cM\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004(\r=\u0002#B<\u0002H\r%\u0002#H<\u0004,\u0005\r\u0011qDA\u0019\u0003c\t\t$!\u0012\u00022\u0005E\u0012\u0011GA\u0019\u0003\u0017\ni'!\u001c\n\u0007\r5\u0002PA\u0004UkBdW-M\u001a\t\u0013\rE2*!AA\u0002\u0005]\u0015a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00138\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%q\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIe\nA\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n\u0004'\u0001\u000f%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u0019\u00029\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132e\u0005aB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE\u001a\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\u0002")
public class SasRelation
extends BaseRelation
implements TableScan,
Product,
scala.Serializable {
    private transient Logger log;
    private final String location;
    private final StructType userSchema;
    private final boolean extractLabel;
    private final boolean forceLowercaseNames;
    private final boolean inferDecimal;
    private final Option<Object> inferDecimalScale;
    private final boolean inferFloat;
    private final boolean inferInt;
    private final boolean inferLong;
    private final boolean inferShort;
    private final int metadataTimeout;
    private final Option<Object> minSplitSize;
    private final Option<Object> maxSplitSize;
    private final transient SQLContext sqlContext;
    private final StructType schema;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple13<String, StructType, Object, Object, Object, Option<Object>, Object, Object, Object, Object, Object, Option<Object>, Option<Object>>> unapply(SasRelation sasRelation) {
        return SasRelation$.MODULE$.unapply(sasRelation);
    }

    public static Option<Object> apply$default$13() {
        return SasRelation$.MODULE$.apply$default$13();
    }

    public static Option<Object> apply$default$12() {
        return SasRelation$.MODULE$.apply$default$12();
    }

    public static int apply$default$11() {
        return SasRelation$.MODULE$.apply$default$11();
    }

    public static boolean apply$default$10() {
        return SasRelation$.MODULE$.apply$default$10();
    }

    public static boolean apply$default$9() {
        return SasRelation$.MODULE$.apply$default$9();
    }

    public static boolean apply$default$8() {
        return SasRelation$.MODULE$.apply$default$8();
    }

    public static boolean apply$default$7() {
        return SasRelation$.MODULE$.apply$default$7();
    }

    public static Option<Object> apply$default$6() {
        return SasRelation$.MODULE$.apply$default$6();
    }

    public static boolean apply$default$5() {
        return SasRelation$.MODULE$.apply$default$5();
    }

    public static boolean apply$default$4() {
        return SasRelation$.MODULE$.apply$default$4();
    }

    public static boolean apply$default$3() {
        return SasRelation$.MODULE$.apply$default$3();
    }

    public static StructType apply$default$2() {
        return SasRelation$.MODULE$.apply$default$2();
    }

    public static SasRelation apply(String string, StructType structType, boolean bl, boolean bl2, boolean bl3, Option<Object> option, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n, Option<Object> option2, Option<Object> option3, SQLContext sQLContext) {
        return SasRelation$.MODULE$.apply(string, structType, bl, bl2, bl3, option, bl4, bl5, bl6, bl7, n, option2, option3, sQLContext);
    }

    public String location() {
        return this.location;
    }

    public StructType userSchema() {
        return this.userSchema;
    }

    public boolean extractLabel() {
        return this.extractLabel;
    }

    public boolean forceLowercaseNames() {
        return this.forceLowercaseNames;
    }

    public boolean inferDecimal() {
        return this.inferDecimal;
    }

    public Option<Object> inferDecimalScale() {
        return this.inferDecimalScale;
    }

    public boolean inferFloat() {
        return this.inferFloat;
    }

    public boolean inferInt() {
        return this.inferInt;
    }

    public boolean inferLong() {
        return this.inferLong;
    }

    public boolean inferShort() {
        return this.inferShort;
    }

    public int metadataTimeout() {
        return this.metadataTimeout;
    }

    public Option<Object> minSplitSize() {
        return this.minSplitSize;
    }

    public Option<Object> maxSplitSize() {
        return this.maxSplitSize;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    private Logger log$lzycompute() {
        SasRelation sasRelation = this;
        synchronized (sasRelation) {
            if (!this.bitmap$trans$0) {
                this.log = LogManager.getLogger((String)this.getClass().getName());
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public StructType schema() {
        return this.schema;
    }

    public RDD<Row> buildScan() {
        Configuration conf = new Configuration(this.sqlContext().sparkContext().hadoopConfiguration());
        if (this.minSplitSize().isDefined()) {
            conf.setLong("mapred.min.split.size", BoxesRunTime.unboxToLong((Object)this.minSplitSize().get()));
        }
        if (this.maxSplitSize().isDefined()) {
            conf.setLong("mapred.max.split.size", BoxesRunTime.unboxToLong((Object)this.maxSplitSize().get()));
        }
        RDD baseRDD = this.sqlContext().sparkContext().newAPIHadoopFile(this.location(), SasInputFormat.class, NullWritable.class, Object[].class, conf).map((Function1 & Serializable & scala.Serializable)x$1 -> (Object[])x$1._2(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Object.class)));
        return baseRDD.mapPartitions((Function1 & Serializable & scala.Serializable)rowIterator -> this.parseSAS((Iterator<Object[]>)rowIterator, (Seq<StructField>)Predef$.MODULE$.wrapRefArray((Object[])this.schema().fields())), baseRDD.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class));
    }

    private Iterator<Row> parseSAS(Iterator<Object[]> rowIterator, Seq<StructField> schemaFields) {
        BooleanRef isFirstRow = BooleanRef.create((boolean)true);
        return rowIterator.map((Function1 & Serializable & scala.Serializable)rowArray -> {
            if (isFirstRow$1.elem) {
                int numColsRead = ((Object[])rowArray).length;
                int numColsSchema = schemaFields.length();
                if (numColsRead != numColsSchema) {
                    throw new IOException(new StringBuilder(47).append("Provided schema has ").append(numColsSchema).append(" but SAS file has ").append(numColsRead).append(" columns.").toString());
                }
                isFirstRow$1.elem = false;
            }
            Object[] conformedRowArray = (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(rowArray)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                String string;
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Object elementValue = tuple2._1();
                int index = tuple2._2$mcI$sp();
                Object object = elementValue;
                if (object == null) {
                    boolean bl = ((StructField)schemaFields.apply(index)).nullable();
                    if (bl) {
                        return null;
                    }
                    if (false != bl) throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                    throw new IOException(new StringBuilder(100).append("Column: '").append(((StructField)schemaFields.apply(index)).name()).append("' (at index: ").append(index).append("),").append(" contains a null value but the provided schema specified it as non-nullable.").toString());
                }
                if (object instanceof Number) {
                    void var6_17;
                    Number number = (Number)object;
                    DataType dataType = ((StructField)schemaFields.apply(index)).dataType();
                    if (DecimalType$.MODULE$.unapply(dataType)) {
                        BigDecimal bigDecimal = new BigDecimal(number.toString());
                    } else if (DoubleType$.MODULE$.equals(dataType)) {
                        Double d = BoxesRunTime.boxToDouble((double)number.doubleValue());
                    } else if (FloatType$.MODULE$.equals(dataType)) {
                        Float f = BoxesRunTime.boxToFloat((float)number.floatValue());
                    } else if (IntegerType$.MODULE$.equals(dataType)) {
                        Integer n = BoxesRunTime.boxToInteger((int)number.intValue());
                    } else if (LongType$.MODULE$.equals(dataType)) {
                        Long l = BoxesRunTime.boxToLong((long)number.longValue());
                    } else {
                        if (!ShortType$.MODULE$.equals(dataType)) throw new IOException(new StringBuilder(64).append("Column: '").append(((StructField)schemaFields.apply(index)).name()).append("' (at index: ").append(index).append("), cannot").append(" have DataType: '").append(((StructField)schemaFields.apply(index)).dataType()).append("', found value: ").append(number).toString());
                        Short s = BoxesRunTime.boxToShort((short)number.shortValue());
                    }
                    string = var6_17;
                    return string;
                } else if (object instanceof String) {
                    String string2 = (String)object;
                    DataType dataType = ((StructField)schemaFields.apply(index)).dataType();
                    if (!StringType$.MODULE$.equals(dataType)) throw new IOException(new StringBuilder(64).append("Column: '").append(((StructField)schemaFields.apply(index)).name()).append("' (at index: ").append(index).append("), cannot").append(" have DataType: '").append(((StructField)schemaFields.apply(index)).dataType()).append("', found value: ").append(string2).toString());
                    String string3 = string2;
                    string = string3;
                    return string;
                } else {
                    void var4_25;
                    if (!(object instanceof java.util.Date)) throw new MatchError(object);
                    java.util.Date date = (java.util.Date)object;
                    DataType dataType = ((StructField)schemaFields.apply(index)).dataType();
                    if (TimestampType$.MODULE$.equals(dataType)) {
                        Timestamp timestamp = new Timestamp(date.getTime());
                    } else {
                        if (!DateType$.MODULE$.equals(dataType)) throw new IOException(new StringBuilder(64).append("Column: '").append(((StructField)schemaFields.apply(index)).name()).append("' (at index: ").append(index).append("), cannot").append(" have DataType: '").append(((StructField)schemaFields.apply(index)).dataType()).append("', found value: ").append(date).toString());
                        Date date2 = new Date(date.getTime());
                    }
                    string = var4_25;
                }
                return string;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
            return Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray((Object)conformedRowArray));
        });
    }

    private StructType inferSchema(boolean extractLabel, boolean forceLowercaseNames, boolean inferDecimal, Option<Object> inferDecimalScale, boolean inferFloat, boolean inferInt, boolean inferLong, boolean inferShort, int metadataTimeout) {
        StructType structType;
        if (this.userSchema() != null) {
            structType = this.userSchema();
        } else {
            SasFileReaderImpl sasFileReaderImpl;
            Configuration conf = this.sqlContext().sparkContext().hadoopConfiguration();
            Path path = new Path(this.location());
            FileSystem fs = path.getFileSystem(conf);
            FSDataInputStream rawInputStream = fs.open(path);
            Option codec2 = Option$.MODULE$.apply((Object)new CompressionCodecFactory(conf).getCodec(path));
            InputStream inputStream = (InputStream)codec2.map((Function1 & Serializable & scala.Serializable)codec -> codec.createInputStream((InputStream)rawInputStream)).getOrElse((Function0 & Serializable & scala.Serializable)() -> rawInputStream);
            Future sasFileReaderFuture = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new SasFileReaderImpl(inputStream), ExecutionContext.Implicits$.MODULE$.global());
            try {
                sasFileReaderImpl = (SasFileReaderImpl)Await$.MODULE$.result((Awaitable)sasFileReaderFuture, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(metadataTimeout)).seconds());
            }
            catch (TimeoutException e) {
                throw new TimeoutException(new StringBuilder(122).append("Timed out after ").append(metadataTimeout).append(" sec while ").append("reading file metadata, file might be corrupt. (Change timeout with 'metadataTimeout' paramater)").toString());
            }
            SasFileReaderImpl sasFileReader = sasFileReaderImpl;
            long columnCount = sasFileReader.getSasFileProperties().getColumnsCount();
            if (columnCount == 0L) {
                throw new IOException("SAS file has no columns, or might not be a valid SAS file.");
            }
            Set<String> DATE_FORMAT_STRINGS = ParsoWrapper$.MODULE$.DATE_FORMAT_STRINGS();
            Set<String> DATE_TIME_FORMAT_STRINGS = ParsoWrapper$.MODULE$.DATE_TIME_FORMAT_STRINGS();
            Buffer schemaFields = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sasFileReader.getColumns()).asScala()).map((Function1 & Serializable & scala.Serializable)column -> {
                Object object;
                String columnName;
                Class columnClass = column.getType();
                String string = columnName = forceLowercaseNames ? column.getName().toLowerCase() : column.getName();
                None$ columnLabel = extractLabel ? (!column.getLabel().isEmpty() ? Option$.MODULE$.apply((Object)column.getLabel()) : None$.MODULE$) : None$.MODULE$;
                int columnLength = column.getLength();
                ColumnFormat columnFormat = column.getFormat();
                String columnFormatName = columnFormat.getName();
                int columnFormatWidth = columnFormat.getWidth();
                int columnFormatPrecision = columnFormat.getPrecision();
                Class clazz = columnClass;
                Class<Number> clazz2 = Number.class;
                if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                    if (DATE_TIME_FORMAT_STRINGS.contains(columnFormatName)) {
                        object = TimestampType$.MODULE$;
                    } else if (DATE_FORMAT_STRINGS.contains(columnFormatName)) {
                        object = DateType$.MODULE$;
                    } else if (columnFormatPrecision == 0 && columnFormatWidth != 0) {
                        int n = columnLength;
                        switch (n) {
                            default: 
                        }
                        object = inferShort && n <= 2 ? ShortType$.MODULE$ : (inferInt && n <= 4 ? IntegerType$.MODULE$ : (inferLong && n <= 8 ? LongType$.MODULE$ : DoubleType$.MODULE$));
                    } else {
                        object = inferDecimal && columnFormatPrecision >= 1 && columnFormatWidth != 0 ? new DecimalType(BoxesRunTime.unboxToInt((Object)inferDecimalScale.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> columnFormatWidth)), columnFormatPrecision) : (inferFloat && columnLength <= 4 ? FloatType$.MODULE$ : DoubleType$.MODULE$);
                    }
                } else {
                    object = StringType$.MODULE$;
                }
                StringType$ columnSparkType = object;
                return columnLabel.isEmpty() ? new StructField(columnName, (DataType)columnSparkType, true, StructField$.MODULE$.apply$default$4()) : new StructField(columnName, (DataType)columnSparkType, true, StructField$.MODULE$.apply$default$4()).withComment((String)columnLabel.get());
            }, Buffer$.MODULE$.canBuildFrom());
            inputStream.close();
            structType = StructType$.MODULE$.apply((Seq)schemaFields);
        }
        return structType;
    }

    public SasRelation copy(String location, StructType userSchema, boolean extractLabel, boolean forceLowercaseNames, boolean inferDecimal, Option<Object> inferDecimalScale, boolean inferFloat, boolean inferInt, boolean inferLong, boolean inferShort, int metadataTimeout, Option<Object> minSplitSize, Option<Object> maxSplitSize, SQLContext sqlContext) {
        return new SasRelation(location, userSchema, extractLabel, forceLowercaseNames, inferDecimal, inferDecimalScale, inferFloat, inferInt, inferLong, inferShort, metadataTimeout, minSplitSize, maxSplitSize, sqlContext);
    }

    public String copy$default$1() {
        return this.location();
    }

    public boolean copy$default$10() {
        return this.inferShort();
    }

    public int copy$default$11() {
        return this.metadataTimeout();
    }

    public Option<Object> copy$default$12() {
        return this.minSplitSize();
    }

    public Option<Object> copy$default$13() {
        return this.maxSplitSize();
    }

    public StructType copy$default$2() {
        return this.userSchema();
    }

    public boolean copy$default$3() {
        return this.extractLabel();
    }

    public boolean copy$default$4() {
        return this.forceLowercaseNames();
    }

    public boolean copy$default$5() {
        return this.inferDecimal();
    }

    public Option<Object> copy$default$6() {
        return this.inferDecimalScale();
    }

    public boolean copy$default$7() {
        return this.inferFloat();
    }

    public boolean copy$default$8() {
        return this.inferInt();
    }

    public boolean copy$default$9() {
        return this.inferLong();
    }

    public String productPrefix() {
        return "SasRelation";
    }

    public int productArity() {
        return 13;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.location();
                break;
            }
            case 1: {
                object = this.userSchema();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.extractLabel());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.forceLowercaseNames());
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToBoolean((boolean)this.inferDecimal());
                break;
            }
            case 5: {
                object = this.inferDecimalScale();
                break;
            }
            case 6: {
                object = BoxesRunTime.boxToBoolean((boolean)this.inferFloat());
                break;
            }
            case 7: {
                object = BoxesRunTime.boxToBoolean((boolean)this.inferInt());
                break;
            }
            case 8: {
                object = BoxesRunTime.boxToBoolean((boolean)this.inferLong());
                break;
            }
            case 9: {
                object = BoxesRunTime.boxToBoolean((boolean)this.inferShort());
                break;
            }
            case 10: {
                object = BoxesRunTime.boxToInteger((int)this.metadataTimeout());
                break;
            }
            case 11: {
                object = this.minSplitSize();
                break;
            }
            case 12: {
                object = this.maxSplitSize();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SasRelation;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.location()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.userSchema()));
        n = Statics.mix((int)n, (int)(this.extractLabel() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.forceLowercaseNames() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.inferDecimal() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.inferDecimalScale()));
        n = Statics.mix((int)n, (int)(this.inferFloat() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.inferInt() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.inferLong() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.inferShort() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)this.metadataTimeout());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.minSplitSize()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.maxSplitSize()));
        return Statics.finalizeHash((int)n, (int)13);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SasRelation)) return false;
        boolean bl = true;
        if (!bl) return false;
        SasRelation sasRelation = (SasRelation)((Object)x$1);
        String string = this.location();
        String string2 = sasRelation.location();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        StructType structType = this.userSchema();
        StructType structType2 = sasRelation.userSchema();
        if (structType == null) {
            if (structType2 != null) {
                return false;
            }
        } else if (!structType.equals(structType2)) return false;
        if (this.extractLabel() != sasRelation.extractLabel()) return false;
        if (this.forceLowercaseNames() != sasRelation.forceLowercaseNames()) return false;
        if (this.inferDecimal() != sasRelation.inferDecimal()) return false;
        Option<Object> option = this.inferDecimalScale();
        Option<Object> option2 = sasRelation.inferDecimalScale();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (this.inferFloat() != sasRelation.inferFloat()) return false;
        if (this.inferInt() != sasRelation.inferInt()) return false;
        if (this.inferLong() != sasRelation.inferLong()) return false;
        if (this.inferShort() != sasRelation.inferShort()) return false;
        if (this.metadataTimeout() != sasRelation.metadataTimeout()) return false;
        Option<Object> option3 = this.minSplitSize();
        Option<Object> option4 = sasRelation.minSplitSize();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<Object> option5 = this.maxSplitSize();
        Option<Object> option6 = sasRelation.maxSplitSize();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        if (!sasRelation.canEqual((Object)this)) return false;
        return true;
    }

    public SasRelation(String location, StructType userSchema, boolean extractLabel, boolean forceLowercaseNames, boolean inferDecimal, Option<Object> inferDecimalScale, boolean inferFloat, boolean inferInt, boolean inferLong, boolean inferShort, int metadataTimeout, Option<Object> minSplitSize, Option<Object> maxSplitSize, SQLContext sqlContext) {
        this.location = location;
        this.userSchema = userSchema;
        this.extractLabel = extractLabel;
        this.forceLowercaseNames = forceLowercaseNames;
        this.inferDecimal = inferDecimal;
        this.inferDecimalScale = inferDecimalScale;
        this.inferFloat = inferFloat;
        this.inferInt = inferInt;
        this.inferLong = inferLong;
        this.inferShort = inferShort;
        this.metadataTimeout = metadataTimeout;
        this.minSplitSize = minSplitSize;
        this.maxSplitSize = maxSplitSize;
        this.sqlContext = sqlContext;
        Product.$init$((Product)this);
        this.schema = this.inferSchema(extractLabel, forceLowercaseNames, inferDecimal, inferDecimalScale, inferFloat, inferInt, inferLong, inferShort, metadataTimeout);
    }
}

