/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.config;

import ai.tripl.arc.api.API;
import ai.tripl.arc.api.API$EncodingTypeBase64$;
import ai.tripl.arc.api.API$EncodingTypeHexadecimal$;
import ai.tripl.arc.api.API$FailModeTypeFailFast$;
import ai.tripl.arc.api.API$FailModeTypePermissive$;
import ai.tripl.arc.api.API$OutputModeTypeAppend$;
import ai.tripl.arc.api.API$OutputModeTypeComplete$;
import ai.tripl.arc.api.API$OutputModeTypeUpdate$;
import ai.tripl.arc.api.Delimiter;
import ai.tripl.arc.api.Delimiter$Comma$;
import ai.tripl.arc.api.Delimiter$Custom$;
import ai.tripl.arc.api.Delimiter$DefaultHive$;
import ai.tripl.arc.api.Delimiter$Pipe$;
import ai.tripl.arc.api.QuoteCharacter;
import ai.tripl.arc.api.QuoteCharacter$Disabled$;
import ai.tripl.arc.api.QuoteCharacter$DoubleQuote$;
import ai.tripl.arc.api.QuoteCharacter$SingleQuote$;
import ai.tripl.arc.config.ConfigUtils$;
import ai.tripl.arc.config.Error;
import ai.tripl.arc.config.Error$;
import ai.tripl.arc.util.CloudUtils$;
import ai.tripl.arc.util.ControlUtils$;
import ai.tripl.arc.util.EitherUtils$;
import ai.tripl.arc.util.MetadataSchema$;
import ai.tripl.arc.util.SQLUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.GlobPattern;
import org.apache.spark.SparkFiles$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.parser.ParserInterface;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Properties$;
import scala.util.Right;

public final class ConfigUtils$ {
    public static final ConfigUtils$ MODULE$;

    static {
        new ConfigUtils$();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Either<List<Error.Error>, String> getConfigString(URI uri, API.ARCContext arcContext, SparkSession spark, Logger logger) {
        String value;
        String string10;
        String string = uri.getScheme();
        if ("local".equals(string)) {
            URI filePath = new URI(SparkFiles$.MODULE$.get(uri.getPath()));
            String etlConfString = CloudUtils$.MODULE$.getTextBlob(filePath, spark, logger);
            return package$.MODULE$.Right().apply((Object)etlConfString);
        }
        if ("file".equals(string)) {
            String etlConfString = CloudUtils$.MODULE$.getTextBlob(uri, spark, logger);
            return package$.MODULE$.Right().apply((Object)etlConfString);
        }
        if ("classpath".equals(string)) {
            String path = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri.getHost(), uri.getPath()}));
            String etlConfString = (String)ControlUtils$.MODULE$.using(this.getClass().getResourceAsStream(path), new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(InputStream is) {
                    return Source$.MODULE$.fromInputStream(is, Codec$.MODULE$.fallbackSystemCodec()).mkString();
                }
            });
            return package$.MODULE$.Right().apply((Object)etlConfString);
        }
        if ("dbfs".equals(string)) {
            String etlConfString = CloudUtils$.MODULE$.getTextBlob(uri, spark, logger);
            return package$.MODULE$.Right().apply((Object)etlConfString);
        }
        if ("s3a".equals(string)) {
            None$ none$;
            String value2;
            String string3;
            String value3;
            String string2;
            Option s3aAccessKey = arcContext.commandLineArguments().get((Object)"etl.config.fs.s3a.access.key").orElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply() {
                    return Properties$.MODULE$.envOrNone("ETL_CONF_S3A_ACCESS_KEY");
                }
            });
            Option s3aSecretKey = arcContext.commandLineArguments().get((Object)"etl.config.fs.s3a.secret.key").orElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply() {
                    return Properties$.MODULE$.envOrNone("ETL_CONF_S3A_SECRET_KEY");
                }
            });
            Option s3aEndpoint = arcContext.commandLineArguments().get((Object)"etl.config.fs.s3a.endpoint").orElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply() {
                    return Properties$.MODULE$.envOrNone("ETL_CONF_S3A_ENDPOINT");
                }
            });
            Option s3aConnectionSSLEnabled = arcContext.commandLineArguments().get((Object)"etl.config.fs.s3a.connection.ssl.enabled").orElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply() {
                    return Properties$.MODULE$.envOrNone("ETL_CONF_S3A_CONNECTION_SSL_ENABLED");
                }
            });
            Option option = s3aAccessKey;
            if (!(option instanceof Some)) {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AWS Access Key not provided for: ", ". Set etl.config.fs.s3a.access.key property or ETL_CONF_S3A_ACCESS_KEY environment variable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
            }
            Some some = (Some)option;
            String accessKey = string2 = (value3 = (String)some.x());
            Option option2 = s3aSecretKey;
            if (!(option2 instanceof Some)) {
                if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AWS Secret Key not provided for: ", ". Set etl.config.fs.s3a.secret.key property or ETL_CONF_S3A_SECRET_KEY environment variable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
            }
            Some some2 = (Some)option2;
            String secretKey = string3 = (value2 = (String)some2.x());
            Option option3 = s3aConnectionSSLEnabled;
            if (option3 instanceof Some) {
                Some some3 = (Some)option3;
                String value32 = (String)some3.x();
                try {
                    none$ = Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString(value32)).toBoolean()));
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AWS SSL configuration incorrect for: ", ". Ensure etl.config.fs.s3a.connection.ssl.enabled or ETL_CONF_S3A_CONNECTION_SSL_ENABLED environment variables are boolean."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
                }
            } else {
                if (!None$.MODULE$.equals(option3)) throw new MatchError((Object)option3);
                none$ = None$.MODULE$;
            }
            None$ connectionSSLEnabled = none$;
            CloudUtils$.MODULE$.setHadoopConfiguration((Option<API.Authentication>)new Some((Object)new API.Authentication.AmazonAccessKey(accessKey, secretKey, (Option<String>)s3aEndpoint, (Option<Object>)connectionSSLEnabled)), spark, logger);
            String etlConfString = CloudUtils$.MODULE$.getTextBlob(uri, spark, logger);
            return package$.MODULE$.Right().apply((Object)etlConfString);
        }
        boolean bl = "wasb".equals(string) ? true : "wasbs".equals(string);
        if (bl) {
            String value4;
            String string4;
            Option azureAccountName = arcContext.commandLineArguments().get((Object)"etl.config.fs.azure.account.name").orElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply() {
                    return Properties$.MODULE$.envOrNone("ETL_CONF_AZURE_ACCOUNT_NAME");
                }
            });
            Option azureAccountKey = arcContext.commandLineArguments().get((Object)"etl.config.fs.azure.account.key").orElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply() {
                    return Properties$.MODULE$.envOrNone("ETL_CONF_AZURE_ACCOUNT_KEY");
                }
            });
            Option option = azureAccountName;
            if (!(option instanceof Some)) {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Azure Account Name not provided for: ", ". Set etl.config.fs.azure.account.name property or ETL_CONF_AZURE_ACCOUNT_NAME environment variable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
            }
            Some some = (Some)option;
            String accountName = string4 = (value4 = (String)some.x());
            Option option4 = azureAccountKey;
            if (option4 instanceof Some) {
                String value42;
                String string5;
                Some some4 = (Some)option4;
                String accountKey = string5 = (value42 = (String)some4.x());
                CloudUtils$.MODULE$.setHadoopConfiguration((Option<API.Authentication>)new Some((Object)new API.Authentication.AzureSharedKey(accountName, accountKey)), spark, logger);
                String etlConfString = CloudUtils$.MODULE$.getTextBlob(uri, spark, logger);
                return package$.MODULE$.Right().apply((Object)etlConfString);
            }
            if (!None$.MODULE$.equals(option4)) throw new MatchError((Object)option4);
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Azure Account Key not provided for: ", ". Set etl.config.fs.azure.account.key property or ETL_CONF_AZURE_ACCOUNT_KEY environment variable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
        }
        if ("adl".equals(string)) {
            String value5;
            String string6;
            Option adlClientID = arcContext.commandLineArguments().get((Object)"etl.config.fs.adl.oauth2.client.id").orElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply() {
                    return Properties$.MODULE$.envOrNone("ETL_CONF_ADL_OAUTH2_CLIENT_ID");
                }
            });
            Option adlRefreshToken = arcContext.commandLineArguments().get((Object)"etl.config.fs.adl.oauth2.refresh.token").orElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply() {
                    return Properties$.MODULE$.envOrNone("ETL_CONF_ADL_OAUTH2_REFRESH_TOKEN");
                }
            });
            Option option = adlClientID;
            if (!(option instanceof Some)) {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Azure Data Lake Storage Client ID not provided for: ", ". Set etl.config.fs.adl.oauth2.client.id or ETL_CONF_ADL_OAUTH2_CLIENT_ID environment variable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
            }
            Some some = (Some)option;
            String clientID = string6 = (value5 = (String)some.x());
            Option option5 = adlRefreshToken;
            if (option5 instanceof Some) {
                String value52;
                String string7;
                Some some5 = (Some)option5;
                String refreshToken = string7 = (value52 = (String)some5.x());
                CloudUtils$.MODULE$.setHadoopConfiguration((Option<API.Authentication>)new Some((Object)new API.Authentication.AzureDataLakeStorageToken(clientID, refreshToken)), spark, logger);
                String etlConfString = CloudUtils$.MODULE$.getTextBlob(uri, spark, logger);
                return package$.MODULE$.Right().apply((Object)etlConfString);
            }
            if (!None$.MODULE$.equals(option5)) throw new MatchError((Object)option5);
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Azure Data Lake Storage Refresh Token not provided for: ", ". Set etl.config.fs.adl.oauth2.refresh.token property or ETL_CONF_ADL_OAUTH2_REFRESH_TOKEN environment variable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
        }
        boolean bl2 = "abfs".equals(string) ? true : "abfss".equals(string);
        if (bl2) {
            String value6;
            String string8;
            Option dfAccountName = arcContext.commandLineArguments().get((Object)"etl.config.fs.dfs.account.name").orElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply() {
                    return Properties$.MODULE$.envOrNone("ETL_CONF_DFS_ACCOUNT_NAME");
                }
            });
            Option dfAccessKey = arcContext.commandLineArguments().get((Object)"etl.config.fs.dfs.access.key").orElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply() {
                    return Properties$.MODULE$.envOrNone("ETL_CONF_DFS_ACCESS_KEY");
                }
            });
            Option option = dfAccountName;
            if (!(option instanceof Some)) {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Azure DLS Account Name not provided for: ", ". Set etl.config.fs.dfs.account.name property or ETL_CONF_DFS_ACCOUNT_NAME environment variable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
            }
            Some some = (Some)option;
            String accountName = string8 = (value6 = (String)some.x());
            Option option6 = dfAccessKey;
            if (option6 instanceof Some) {
                String value62;
                String string9;
                Some some6 = (Some)option6;
                String accountKey = string9 = (value62 = (String)some6.x());
                CloudUtils$.MODULE$.setHadoopConfiguration((Option<API.Authentication>)new Some((Object)new API.Authentication.AzureDataLakeStorageGen2AccountKey(accountName, accountKey)), spark, logger);
                String etlConfString = CloudUtils$.MODULE$.getTextBlob(uri, spark, logger);
                return package$.MODULE$.Right().apply((Object)etlConfString);
            }
            if (!None$.MODULE$.equals(option6)) throw new MatchError((Object)option6);
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Azure DLS Access Key not provided for: ", ". Set etl.config.fs.dfs.access.key property or ETL_CONF_DFS_ACCESS_KEY environment variable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
        }
        if (!"gs".equals(string)) {
            Error.ConfigError configError = new Error.ConfigError("file", (Option<Object>)None$.MODULE$, "make sure url scheme is defined e.g. file://${pwd}");
            return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
        }
        Option gsProjectID = arcContext.commandLineArguments().get((Object)"etl.config.fs.gs.project.id").orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply() {
                return Properties$.MODULE$.envOrNone("ETL_CONF_GOOGLE_CLOUD_PROJECT_ID");
            }
        });
        Option gsKeyfilePath = arcContext.commandLineArguments().get((Object)"etl.config.fs.google.cloud.auth.service.account.json.keyfile").orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply() {
                return Properties$.MODULE$.envOrNone("ETL_CONF_GOOGLE_CLOUD_AUTH_SERVICE_ACCOUNT_JSON_KEYFILE");
            }
        });
        Option option = gsProjectID;
        if (!(option instanceof Some)) {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Google Cloud Project ID not provided for: ", ". Set etl.config.fs.gs.project.id or ETL_CONF_GOOGLE_CLOUD_PROJECT_ID environment variable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
        }
        Some some = (Some)option;
        String projectID = string10 = (value = (String)some.x());
        Option option7 = gsKeyfilePath;
        if (option7 instanceof Some) {
            String value7;
            String string11;
            Some some7 = (Some)option7;
            String keyFilePath = string11 = (value7 = (String)some7.x());
            CloudUtils$.MODULE$.setHadoopConfiguration((Option<API.Authentication>)new Some((Object)new API.Authentication.GoogleCloudStorageKeyFile(projectID, keyFilePath)), spark, logger);
            String etlConfString = CloudUtils$.MODULE$.getTextBlob(uri, spark, logger);
            return package$.MODULE$.Right().apply((Object)etlConfString);
        }
        if (!None$.MODULE$.equals(option7)) throw new MatchError((Object)option7);
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Google Cloud KeyFile Path not provided for: ", ". Set etl.config.fs.google.cloud.auth.service.account.json.keyfile property or ETL_CONF_GOOGLE_CLOUD_AUTH_SERVICE_ACCOUNT_JSON_KEYFILE environment variable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
    }

    public Map<String, String> readMap(String path, Config c) {
        Map map;
        if (c.hasPath(path)) {
            Set params = c.getConfig(path).entrySet();
            map = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(params).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, String> apply(Map.Entry<String, ConfigValue> e) {
                    String k = e.getKey().replaceAll("^\"|\"$", "");
                    String v = e.getValue().unwrapped().toString();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
                }
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        } else {
            map = Predef$.MODULE$.Map().empty();
        }
        return map;
    }

    public Either<List<Error.ConfigError>, String> checkValidKeys(Config c, Function0<Seq<String>> expectedKeys) {
        List diffKeys = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(c.root().keySet()).asScala()).toSeq().diff((GenSeq)expectedKeys.apply())).toList();
        return diffKeys.isEmpty() ? package$.MODULE$.Right().apply((Object)"") : package$.MODULE$.Left().apply(diffKeys.map((Function1)new Serializable(c, expectedKeys){
            public static final long serialVersionUID = 0L;
            private final Config c$1;
            private final Function0 expectedKeys$1;

            public final Error.ConfigError apply(String key) {
                Seq<String> possibleKeys = ConfigUtils$.MODULE$.levenshteinDistance((Seq<String>)((Seq)this.expectedKeys$1.apply()), key, 4);
                return possibleKeys.isEmpty() ? new Error.ConfigError(key, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.c$1.getValue(key).origin().lineNumber())), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid attribute '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key}))) : (this.c$1.getValue(key).origin().description().contains("merge of") ? new Error.ConfigError(key, (Option<Object>)None$.MODULE$, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid attribute '", "'. Perhaps you meant one of: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, ((TraversableOnce)possibleKeys.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String field) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{field}));
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")}))) : new Error.ConfigError(key, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.c$1.getValue(key).origin().lineNumber())), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid attribute '", "'. Perhaps you meant one of: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, ((TraversableOnce)possibleKeys.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String field) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{field}));
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")}))));
            }
            {
                this.c$1 = c$1;
                this.expectedKeys$1 = expectedKeys$1;
            }
        }, List$.MODULE$.canBuildFrom()));
    }

    public Seq<String> levenshteinDistance(Seq<String> keys, String input, int limit) {
        UTF8String inputUTF8 = UTF8String.fromString((String)input);
        return (Seq)((TraversableLike)keys.map((Function1)new Serializable(inputUTF8){
            public static final long serialVersionUID = 0L;
            private final UTF8String inputUTF8$1;

            public final Tuple2<String, Object> apply(String k) {
                int v = this.inputUTF8$1.levenshteinDistance(UTF8String.fromString((String)k));
                return new Tuple2((Object)k, (Object)BoxesRunTime.boxToInteger((int)v));
            }
            {
                this.inputUTF8$1 = inputUTF8$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(limit){
            public static final long serialVersionUID = 0L;
            private final int limit$1;

            public final boolean apply(Tuple2<String, Object> x$2) {
                Tuple2<String, Object> tuple2 = x$2;
                if (tuple2 != null) {
                    int v = tuple2._2$mcI$sp();
                    boolean bl = v < this.limit$1;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.limit$1 = limit$1;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x$3) {
                Tuple2<String, Object> tuple2 = x$3;
                if (tuple2 != null) {
                    String k;
                    String string = k = (String)tuple2._1();
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Either<List<Error.ConfigError>, String> parseGlob(String path, String glob, Config c) {
        Right right;
        try {
            GlobPattern.compile((String)glob);
            right = package$.MODULE$.Right().apply((Object)glob);
        }
        catch (Exception exception) {
            right = this.err$1((Option)new Some((Object)BoxesRunTime.boxToInteger((int)c.getValue(path).origin().lineNumber())), exception.getMessage(), path);
        }
        return right;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Either<List<Error.ConfigError>, Option<API.Authentication>> readAuthentication(String path, Config c) {
        Right right;
        try {
            Map<String, String> authentication;
            block39: {
                Right right2;
                block33: {
                    String v;
                    String string;
                    String v2;
                    String string2;
                    String string3;
                    Some some;
                    boolean bl;
                    block38: {
                        None$ none$;
                        None$ none$2;
                        String v3;
                        String string4;
                        String v4;
                        String string5;
                        String string6;
                        block37: {
                            String v5;
                            String string7;
                            String v6;
                            String string8;
                            String v7;
                            String string9;
                            String string10;
                            block36: {
                                String v8;
                                String string11;
                                String v9;
                                String string12;
                                String string13;
                                block35: {
                                    String v10;
                                    String string14;
                                    String v11;
                                    String string15;
                                    String string16;
                                    block34: {
                                        String v12;
                                        String string17;
                                        String v13;
                                        String string18;
                                        String string19;
                                        block32: {
                                            String v14;
                                            String string20;
                                            if (!c.hasPath(path)) {
                                                right = package$.MODULE$.Right().apply((Object)None$.MODULE$);
                                                return right;
                                            }
                                            authentication = this.readMap("authentication", c);
                                            if (authentication.isEmpty()) {
                                                right = package$.MODULE$.Right().apply((Object)None$.MODULE$);
                                                return right;
                                            }
                                            bl = false;
                                            some = null;
                                            Option option = authentication.get((Object)"method");
                                            if (!(option instanceof Some)) break block32;
                                            bl = true;
                                            some = (Some)option;
                                            String string21 = (String)some.x();
                                            if (!"AzureSharedKey".equals(string21)) break block32;
                                            Option option2 = authentication.get((Object)"accountName");
                                            if (!(option2 instanceof Some)) {
                                                if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
                                                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureSharedKey' requires 'accountName' parameter."})).s((Seq)Nil$.MODULE$));
                                            }
                                            Some some2 = (Some)option2;
                                            String v15 = (String)some2.x();
                                            String string22 = v15;
                                            String accountName = string22;
                                            if (accountName.contains("fs.azure")) {
                                                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureSharedKey' 'accountName' should be just the account name not 'fs.azure.account.key...''."})).s((Seq)Nil$.MODULE$));
                                            }
                                            Option option3 = authentication.get((Object)"signature");
                                            if (!(option3 instanceof Some)) {
                                                if (!None$.MODULE$.equals(option3)) throw new MatchError((Object)option3);
                                                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureSharedKey' requires 'signature' parameter."})).s((Seq)Nil$.MODULE$));
                                            }
                                            Some some3 = (Some)option3;
                                            String signature = string20 = (v14 = (String)some3.x());
                                            right2 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.AzureSharedKey(accountName, signature)));
                                            break block33;
                                        }
                                        if (!bl || !"AzureSharedAccessSignature".equals(string19 = (String)some.x())) break block34;
                                        Option option = authentication.get((Object)"accountName");
                                        if (!(option instanceof Some)) {
                                            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                                            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureSharedAccessSignature' requires 'accountName' parameter."})).s((Seq)Nil$.MODULE$));
                                        }
                                        Some some4 = (Some)option;
                                        String v16 = (String)some4.x();
                                        String string23 = v16;
                                        String accountName = string23;
                                        if (accountName.contains("fs.azure")) {
                                            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureSharedAccessSignature' 'accountName' should be just the account name not 'fs.azure.account.key...''."})).s((Seq)Nil$.MODULE$));
                                        }
                                        Option option4 = authentication.get((Object)"container");
                                        if (!(option4 instanceof Some)) {
                                            if (!None$.MODULE$.equals(option4)) throw new MatchError((Object)option4);
                                            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureSharedAccessSignature' requires 'container' parameter."})).s((Seq)Nil$.MODULE$));
                                        }
                                        Some some5 = (Some)option4;
                                        String container = string18 = (v13 = (String)some5.x());
                                        if (accountName.contains("fs.azure")) {
                                            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureSharedAccessSignature' 'container' should be just the container name not 'fs.azure.account.key...''."})).s((Seq)Nil$.MODULE$));
                                        }
                                        Option option5 = authentication.get((Object)"token");
                                        if (!(option5 instanceof Some)) {
                                            if (!None$.MODULE$.equals(option5)) throw new MatchError((Object)option5);
                                            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureSharedAccessSignature' requires 'container' parameter."})).s((Seq)Nil$.MODULE$));
                                        }
                                        Some some6 = (Some)option5;
                                        String token = string17 = (v12 = (String)some6.x());
                                        right2 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.AzureSharedAccessSignature(accountName, container, token)));
                                        break block33;
                                    }
                                    if (!bl || !"AzureDataLakeStorageToken".equals(string16 = (String)some.x())) break block35;
                                    Option option = authentication.get((Object)"clientID");
                                    if (!(option instanceof Some)) {
                                        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                                        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureDataLakeStorageToken' requires 'clientID' parameter."})).s((Seq)Nil$.MODULE$));
                                    }
                                    Some some7 = (Some)option;
                                    String clientID = string15 = (v11 = (String)some7.x());
                                    Option option6 = authentication.get((Object)"refreshToken");
                                    if (!(option6 instanceof Some)) {
                                        if (!None$.MODULE$.equals(option6)) throw new MatchError((Object)option6);
                                        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureDataLakeStorageToken' requires 'refreshToken' parameter."})).s((Seq)Nil$.MODULE$));
                                    }
                                    Some some8 = (Some)option6;
                                    String refreshToken = string14 = (v10 = (String)some8.x());
                                    right2 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.AzureDataLakeStorageToken(clientID, refreshToken)));
                                    break block33;
                                }
                                if (!bl || !"AzureDataLakeStorageGen2AccountKey".equals(string13 = (String)some.x())) break block36;
                                Option option = authentication.get((Object)"accountName");
                                if (!(option instanceof Some)) {
                                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                                    throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureDataLakeStorageGen2AccountKey' requires 'accountName' parameter."})).s((Seq)Nil$.MODULE$));
                                }
                                Some some9 = (Some)option;
                                String accountName = string12 = (v9 = (String)some9.x());
                                Option option7 = authentication.get((Object)"accessKey");
                                if (!(option7 instanceof Some)) {
                                    if (!None$.MODULE$.equals(option7)) throw new MatchError((Object)option7);
                                    throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureDataLakeStorageGen2AccountKey' requires 'accessKey' parameter."})).s((Seq)Nil$.MODULE$));
                                }
                                Some some10 = (Some)option7;
                                String accessKey = string11 = (v8 = (String)some10.x());
                                right2 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.AzureDataLakeStorageGen2AccountKey(accountName, accessKey)));
                                break block33;
                            }
                            if (!bl || !"AzureDataLakeStorageGen2OAuth".equals(string10 = (String)some.x())) break block37;
                            Option option = authentication.get((Object)"clientID");
                            if (!(option instanceof Some)) {
                                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureDataLakeStorageGen2OAuth' requires 'clientID' parameter."})).s((Seq)Nil$.MODULE$));
                            }
                            Some some11 = (Some)option;
                            String clientID = string9 = (v7 = (String)some11.x());
                            Option option8 = authentication.get((Object)"secret");
                            if (!(option8 instanceof Some)) {
                                if (!None$.MODULE$.equals(option8)) throw new MatchError((Object)option8);
                                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureDataLakeStorageGen2OAuth' requires 'secret' parameter."})).s((Seq)Nil$.MODULE$));
                            }
                            Some some12 = (Some)option8;
                            String secret = string8 = (v6 = (String)some12.x());
                            Option option9 = authentication.get((Object)"directoryID");
                            if (!(option9 instanceof Some)) {
                                if (!None$.MODULE$.equals(option9)) throw new MatchError((Object)option9);
                                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureDataLakeStorageGen2OAuth' requires 'directoryID' parameter."})).s((Seq)Nil$.MODULE$));
                            }
                            Some some13 = (Some)option9;
                            String directoryID = string7 = (v5 = (String)some13.x());
                            right2 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.AzureDataLakeStorageGen2OAuth(clientID, secret, directoryID)));
                            break block33;
                        }
                        if (!bl || !"AmazonAccessKey".equals(string6 = (String)some.x())) break block38;
                        Option option = authentication.get((Object)"accessKeyID");
                        if (!(option instanceof Some)) {
                            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AmazonAccessKey' requires 'accessKeyID' parameter."})).s((Seq)Nil$.MODULE$));
                        }
                        Some some14 = (Some)option;
                        String accessKeyID = string5 = (v4 = (String)some14.x());
                        Option option10 = authentication.get((Object)"secretAccessKey");
                        if (!(option10 instanceof Some)) {
                            if (!None$.MODULE$.equals(option10)) throw new MatchError((Object)option10);
                            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AmazonAccessKey' requires 'secretAccessKey' parameter."})).s((Seq)Nil$.MODULE$));
                        }
                        Some some15 = (Some)option10;
                        String secretAccessKey = string4 = (v3 = (String)some15.x());
                        Option option11 = authentication.get((Object)"endpoint");
                        if (option11 instanceof Some) {
                            Some some16 = (Some)option11;
                            String v17 = (String)some16.x();
                            URI uri = new URI(v17);
                            InetAddress inetAddress = InetAddress.getByName(uri.getHost());
                            URI replacedURI = new URI(uri.getScheme(), uri.getUserInfo(), inetAddress.getHostAddress(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
                            none$2 = Option$.MODULE$.apply((Object)replacedURI.toString());
                        } else {
                            if (!None$.MODULE$.equals(option11)) throw new MatchError((Object)option11);
                            none$2 = None$.MODULE$;
                        }
                        None$ endpoint = none$2;
                        Option option12 = authentication.get((Object)"sslEnabled");
                        if (option12 instanceof Some) {
                            Some some17 = (Some)option12;
                            String v18 = (String)some17.x();
                            try {
                                none$ = Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString(v18)).toBoolean()));
                            }
                            catch (Exception exception) {
                                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AmazonAccessKey' expects 'sslEnabled' parameter to be boolean."})).s((Seq)Nil$.MODULE$));
                            }
                        } else {
                            if (!None$.MODULE$.equals(option12)) throw new MatchError((Object)option12);
                            none$ = None$.MODULE$;
                        }
                        None$ sslEnabled = none$;
                        right2 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.AmazonAccessKey(accessKeyID, secretAccessKey, (Option<String>)endpoint, (Option<Object>)sslEnabled)));
                        break block33;
                    }
                    if (!bl || !"GoogleCloudStorageKeyFile".equals(string3 = (String)some.x())) break block39;
                    Option option = authentication.get((Object)"projectID");
                    if (!(option instanceof Some)) {
                        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'GoogleCloudStorageKeyFile' requires 'projectID' parameter."})).s((Seq)Nil$.MODULE$));
                    }
                    Some some18 = (Some)option;
                    String projectID = string2 = (v2 = (String)some18.x());
                    Option option13 = authentication.get((Object)"keyFilePath");
                    if (!(option13 instanceof Some)) {
                        if (!None$.MODULE$.equals(option13)) throw new MatchError((Object)option13);
                        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'GoogleCloudStorageKeyFile' requires 'keyFilePath' parameter."})).s((Seq)Nil$.MODULE$));
                    }
                    Some some19 = (Some)option13;
                    String keyFilePath = string = (v = (String)some19.x());
                    right2 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.GoogleCloudStorageKeyFile(projectID, keyFilePath)));
                }
                right = right2;
                return right;
            }
            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to parse authentication method: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{authentication.get((Object)"method").getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            })})));
        }
        catch (Exception exception) {
            right = this.err$2((Option)new Some((Object)BoxesRunTime.boxToInteger((int)c.getValue(path).origin().lineNumber())), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to read config value: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception.getMessage()})), path);
        }
        return right;
    }

    public Either<List<Error.ConfigError>, URI> parseURI(String path, String uri, Config c) {
        Right right;
        try {
            right = package$.MODULE$.Right().apply((Object)new URI(uri));
        }
        catch (Exception exception) {
            right = this.err$3((Option)new Some((Object)BoxesRunTime.boxToInteger((int)c.getValue(path).origin().lineNumber())), exception.getMessage(), path);
        }
        return right;
    }

    public Either<List<Error.ConfigError>, List<API.ExtractColumn>> getExtractColumns(String uriKey, Either<List<Error.ConfigError>, Option<API.Authentication>> authentication, URI uri, SparkSession spark, Logger logger, Config c) {
        Either schema = EitherUtils$.MODULE$.eitherToMappableEither(this.textContentForURI(uriKey, authentication, uri, spark, logger, c)).rightFlatMap(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Right<Nothing$, Option<String>> apply(String text) {
                return package$.MODULE$.Right().apply((Object)Option$.MODULE$.apply((Object)text));
            }
        });
        return EitherUtils$.MODULE$.eitherToMappableEither(schema).rightFlatMap(new Serializable(logger){
            public static final long serialVersionUID = 0L;
            public final Logger logger$1;

            public final Either<List<Error.ConfigError>, List<API.ExtractColumn>> apply(Option<String> sch) {
                Either either;
                block4: {
                    Right right;
                    block3: {
                        block2: {
                            Either cols = (Either)sch.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.getExtractColumns.1 $outer;

                                public final Either<List<Error.StageError>, List<API.ExtractColumn>> apply(String s) {
                                    return MetadataSchema$.MODULE$.parseJsonMetadata(s, this.$outer.logger$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }).getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Right<Nothing$, Nil$> apply() {
                                    return package$.MODULE$.Right().apply((Object)Nil$.MODULE$);
                                }
                            });
                            either = cols;
                            if (!(either instanceof Left)) break block2;
                            Left left = (Left)either;
                            List errs = (List)left.a();
                            right = package$.MODULE$.Left().apply(errs.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Error.ConfigError apply(Error.StageError e) {
                                    return new Error.ConfigError("metadata error", (Option<Object>)None$.MODULE$, Error$.MODULE$.pipelineSimpleErrorMsg(e.errors()));
                                }
                            }, List$.MODULE$.canBuildFrom()));
                            break block3;
                        }
                        if (!(either instanceof Right)) break block4;
                        Right right2 = (Right)either;
                        List extractColumns = (List)right2.b();
                        right = package$.MODULE$.Right().apply((Object)extractColumns);
                    }
                    return right;
                }
                throw new MatchError((Object)either);
            }
            {
                this.logger$1 = logger$1;
            }
        });
    }

    public Either<List<Error.ConfigError>, String> textContentForURI(String uriKey, Either<List<Error.ConfigError>, Option<API.Authentication>> authentication, URI uri, SparkSession spark, Logger logger, Config c) {
        Either either;
        String string = uri.getScheme();
        if ("classpath".equals(string)) {
            String path = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri.getHost(), uri.getPath()}));
            either = (Either)ControlUtils$.MODULE$.using(this.getClass().getResourceAsStream(path), new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Right<Nothing$, String> apply(InputStream is) {
                    String text = Source$.MODULE$.fromInputStream(is, Codec$.MODULE$.fallbackSystemCodec()).mkString();
                    return package$.MODULE$.Right().apply((Object)text);
                }
            });
        } else {
            authentication.right().map((Function1)new Serializable(spark, logger){
                public static final long serialVersionUID = 0L;
                private final SparkSession spark$1;
                private final Logger logger$2;

                public final void apply(Option<API.Authentication> auth) {
                    CloudUtils$.MODULE$.setHadoopConfiguration(auth, this.spark$1, this.logger$2);
                }
                {
                    this.spark$1 = spark$1;
                    this.logger$2 = logger$2;
                }
            });
            either = this.getBlob(uriKey, uri, spark, logger, c);
        }
        return either;
    }

    public Either<List<Error.ConfigError>, String> getBlob(String path, URI uri, SparkSession spark, Logger logger, Config c) {
        Object object;
        try {
            String textFile = CloudUtils$.MODULE$.getTextBlob(uri, spark, logger);
            object = textFile.length() == 0 ? this.err$4((Option)new Some((Object)BoxesRunTime.boxToInteger((int)c.getValue(path).origin().lineNumber())), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File at ", " is empty."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri.toString()})), path) : package$.MODULE$.Right().apply((Object)textFile);
        }
        catch (Exception exception) {
            object = this.err$4((Option)new Some((Object)BoxesRunTime.boxToInteger((int)c.getValue(path).origin().lineNumber())), exception.getMessage(), path);
        }
        return object;
    }

    public Either<List<Error.ConfigError>, API.EncodingType> parseEncoding(String path, String encoding, Config c) {
        Right right;
        String string = encoding.toLowerCase().trim();
        if ("base64".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)API$EncodingTypeBase64$.MODULE$);
        } else if ("hexadecimal".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)API$EncodingTypeHexadecimal$.MODULE$);
        } else {
            Error.ConfigError configError = new Error.ConfigError(path, (Option<Object>)None$.MODULE$, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid state please raise issue."})).s((Seq)Nil$.MODULE$));
            right = package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
        }
        return right;
    }

    public Either<List<Error.ConfigError>, SaveMode> parseSaveMode(String path, String delim, Config c) {
        Right right;
        String string = delim.toLowerCase().trim();
        if ("append".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)SaveMode.Append);
        } else if ("errorifexists".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)SaveMode.ErrorIfExists);
        } else if ("ignore".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)SaveMode.Ignore);
        } else if ("overwrite".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)SaveMode.Overwrite);
        } else {
            Error.ConfigError configError = new Error.ConfigError(path, (Option<Object>)None$.MODULE$, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid state please raise issue."})).s((Seq)Nil$.MODULE$));
            right = package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
        }
        return right;
    }

    public Either<List<Error.ConfigError>, API.OutputModeType> parseOutputModeType(String path, String delim, Config c) {
        Right right;
        String string = delim.toLowerCase().trim();
        if ("append".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)API$OutputModeTypeAppend$.MODULE$);
        } else if ("complete".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)API$OutputModeTypeComplete$.MODULE$);
        } else if ("update".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)API$OutputModeTypeUpdate$.MODULE$);
        } else {
            Error.ConfigError configError = new Error.ConfigError(path, (Option<Object>)None$.MODULE$, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid state please raise issue."})).s((Seq)Nil$.MODULE$));
            right = package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
        }
        return right;
    }

    public Either<List<Error.ConfigError>, API.FailModeType> parseFailMode(String path, String delim, Config c) {
        Right right;
        String string = delim.toLowerCase().trim();
        if ("permissive".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)API$FailModeTypePermissive$.MODULE$);
        } else if ("failfast".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)API$FailModeTypeFailFast$.MODULE$);
        } else {
            Error.ConfigError configError = new Error.ConfigError(path, (Option<Object>)None$.MODULE$, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid state please raise issue."})).s((Seq)Nil$.MODULE$));
            right = package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
        }
        return right;
    }

    public Either<List<Error.ConfigError>, Delimiter> parseDelimiter(String path, String delim, Config c) {
        Right right;
        String string = delim.toLowerCase().trim();
        if ("comma".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)Delimiter$Comma$.MODULE$);
        } else if ("defaulthive".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)Delimiter$DefaultHive$.MODULE$);
        } else if ("pipe".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)Delimiter$Pipe$.MODULE$);
        } else if ("custom".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)Delimiter$Custom$.MODULE$);
        } else {
            Error.ConfigError configError = new Error.ConfigError(path, (Option<Object>)None$.MODULE$, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid state please raise issue."})).s((Seq)Nil$.MODULE$));
            right = package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
        }
        return right;
    }

    public Either<List<Error.ConfigError>, QuoteCharacter> parseQuote(String path, String quote, Config c) {
        Right right;
        String string = quote.toLowerCase().trim();
        if ("doublequote".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)QuoteCharacter$DoubleQuote$.MODULE$);
        } else if ("singlequote".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)QuoteCharacter$SingleQuote$.MODULE$);
        } else if ("none".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)QuoteCharacter$Disabled$.MODULE$);
        } else {
            Error.ConfigError configError = new Error.ConfigError(path, (Option<Object>)None$.MODULE$, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid state please raise issue."})).s((Seq)Nil$.MODULE$));
            right = package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
        }
        return right;
    }

    public Either<List<Error.ConfigError>, Driver> getJDBCDriver(String path, String uri, Config c) {
        Right right;
        List drivers = (List)((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(DriverManager.getDrivers()).asScala()).toList().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Driver driver) {
                return driver.getClass().getName();
            }
        }, List$.MODULE$.canBuildFrom());
        try {
            right = package$.MODULE$.Right().apply((Object)DriverManager.getDriver(uri));
        }
        catch (Exception exception) {
            right = this.err$5((Option)new Some((Object)BoxesRunTime.boxToInteger((int)c.getValue(path).origin().lineNumber())), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid driver for ('", "'). Available JDBC drivers: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri, drivers.mkString("[", ", ", "]")})), path);
        }
        return right;
    }

    public Either<List<Error.ConfigError>, String> injectSQLParams(String path, Map<String, String> sqlParams, boolean allowMissing, String sql, SparkSession spark, Logger logger, Config c) {
        Right right;
        try {
            right = package$.MODULE$.Right().apply((Object)SQLUtils$.MODULE$.injectParameters(sql, sqlParams, allowMissing, logger));
        }
        catch (Exception exception) {
            right = this.err$6((Option)new Some((Object)BoxesRunTime.boxToInteger((int)c.getValue(path).origin().lineNumber())), exception.getMessage(), path);
        }
        return right;
    }

    public Either<List<Error.ConfigError>, String> validateSQL(String path, String sql, SparkSession spark, Config c) {
        Right right;
        try {
            ParserInterface parser = spark.sessionState().sqlParser();
            parser.parsePlan(sql);
            right = package$.MODULE$.Right().apply((Object)sql);
        }
        catch (Exception exception) {
            right = this.err$7((Option)new Some((Object)BoxesRunTime.boxToInteger((int)c.getValue(path).origin().lineNumber())), exception.getMessage(), path);
        }
        return right;
    }

    private final Either err$1(Option lineNumber, String msg, String path$1) {
        Error.ConfigError configError = new Error.ConfigError(path$1, (Option<Object>)lineNumber, msg);
        return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
    }

    private final Either err$2(Option lineNumber, String msg, String path$2) {
        Error.ConfigError configError = new Error.ConfigError(path$2, (Option<Object>)lineNumber, msg);
        return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
    }

    private final Either err$3(Option lineNumber, String msg, String path$3) {
        Error.ConfigError configError = new Error.ConfigError(path$3, (Option<Object>)lineNumber, msg);
        return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
    }

    private final Either err$4(Option lineNumber, String msg, String path$4) {
        Error.ConfigError configError = new Error.ConfigError(path$4, (Option<Object>)lineNumber, msg);
        return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
    }

    private final Either err$5(Option lineNumber, String msg, String path$5) {
        Error.ConfigError configError = new Error.ConfigError(path$5, (Option<Object>)lineNumber, msg);
        return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
    }

    private final Either err$6(Option lineNumber, String msg, String path$6) {
        Error.ConfigError configError = new Error.ConfigError(path$6, (Option<Object>)lineNumber, msg);
        return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
    }

    private final Either err$7(Option lineNumber, String msg, String path$7) {
        Error.ConfigError configError = new Error.ConfigError(path$7, (Option<Object>)lineNumber, msg);
        return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
    }

    private ConfigUtils$() {
        MODULE$ = this;
    }
}

