/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.extract;

import ai.tripl.arc.api.API;
import ai.tripl.arc.extract.ORCExtract;
import ai.tripl.arc.extract.ORCExtractStage;
import ai.tripl.arc.util.CloudUtils$;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.ExtractUtils$;
import ai.tripl.arc.util.MetadataUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple14;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class ORCExtractStage$
implements Serializable {
    public static final ORCExtractStage$ MODULE$;

    static {
        new ORCExtractStage$();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Option<Dataset<Row>> execute(ORCExtractStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        AnalysisException analysisException2;
        block35: {
            Option<StructType> option;
            Product error;
            block36: {
                BoxedUnit boxedUnit;
                Dataset dataset;
                Dataset dataset2;
                Option<StructType> option2;
                Dataset sourceEnrichedDF;
                Left left;
                Option<StructType> optionSchema;
                try {
                    optionSchema = ExtractUtils$.MODULE$.getSchema(stage.schema(), spark, logger);
                    CloudUtils$.MODULE$.setHadoopConfiguration(stage.authentication(), spark, logger);
                }
                catch (Exception exception) {
                    throw new DetailException(stage, exception){
                        private final Map<String, Object> detail;

                        public Map<String, Object> detail() {
                            return this.detail;
                        }
                        {
                            this.detail = stage$2.stageDetail();
                        }
                    };
                }
                try {
                    if (arcContext.isStreaming()) {
                        Right right;
                        Option<StructType> option3 = optionSchema;
                        if (!(option3 instanceof Some)) {
                            if (!None$.MODULE$.equals(option3)) throw new MatchError(option3);
                            throw new Exception("ORCExtract requires 'schemaURI' or 'schemaView' to be set if Arc is running in streaming mode.");
                        }
                        Some some = (Some)option3;
                        StructType schema = (StructType)some.x();
                        Option<API.Watermark> option4 = stage.watermark();
                        if (option4 instanceof Some) {
                            Some some2 = (Some)option4;
                            API.Watermark watermark = (API.Watermark)some2.x();
                            right = package$.MODULE$.Right().apply((Object)spark.readStream().option("mergeSchema", "true").schema(schema).orc(stage.input()).withWatermark(watermark.eventTime(), watermark.delayThreshold()));
                        } else {
                            if (!None$.MODULE$.equals(option4)) throw new MatchError(option4);
                            right = package$.MODULE$.Right().apply((Object)spark.readStream().option("mergeSchema", "true").schema(schema).orc(stage.input()));
                        }
                        Right right2 = right;
                        left = right2;
                    } else {
                        Right right;
                        Option<String> option5 = stage.basePath();
                        if (option5 instanceof Some) {
                            Some some = (Some)option5;
                            String basePath = (String)some.x();
                            right = package$.MODULE$.Right().apply((Object)spark.read().option("mergeSchema", "true").option("basePath", basePath).orc(stage.input()));
                        } else {
                            if (!None$.MODULE$.equals(option5)) throw new MatchError(option5);
                            right = package$.MODULE$.Right().apply((Object)spark.read().option("mergeSchema", "true").orc(stage.input()));
                        }
                        left = right;
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new DetailException(stage, exception){
                        private final Map<String, Object> detail;

                        public Map<String, Object> detail() {
                            return this.detail;
                        }
                        {
                            this.detail = stage$2.stageDetail();
                        }
                    };
                }
                catch (AnalysisException analysisException2) {
                    String string = analysisException2.getMessage();
                    String string2 = "Unable to infer schema for ORC. It must be specified manually.;";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        left = package$.MODULE$.Left().apply((Object)new API.FileNotFoundExtractError((Option<String>)Option$.MODULE$.apply((Object)stage.input())));
                    }
                    if (!analysisException2.getMessage().contains("Path does not exist")) break block35;
                    left = package$.MODULE$.Left().apply((Object)new API.PathNotExistsExtractError((Option<String>)Option$.MODULE$.apply((Object)stage.input())));
                }
                Left df = left;
                try {
                    Dataset dataset3;
                    Left left2 = df;
                    if (left2 instanceof Right) {
                        Dataset dataset4;
                        Right right = (Right)left2;
                        Dataset df2 = (Dataset)right.b();
                        if (df2.schema().length() == 0) {
                            Dataset dataset5;
                            Option<StructType> option6 = optionSchema;
                            if (!(option6 instanceof Some)) {
                                if (!None$.MODULE$.equals(option6)) throw new MatchError(option6);
                                throw new Exception(new API.EmptySchemaExtractError((Option<String>)new Some((Object)stage.input())).getMessage());
                            }
                            Some some = (Some)option6;
                            StructType structType = (StructType)some.x();
                            dataset4 = dataset5 = spark.createDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), structType);
                        } else {
                            dataset4 = df2;
                        }
                        dataset3 = dataset4;
                    } else {
                        Dataset dataset6;
                        if (!(left2 instanceof Left)) throw new MatchError((Object)left2);
                        Left left3 = left2;
                        error = (Product)left3.a();
                        stage.stageDetail().put((Object)"records", (Object)0);
                        option = optionSchema;
                        if (!(option instanceof Some)) break block36;
                        Some some = (Some)option;
                        StructType s = (StructType)some.x();
                        dataset3 = dataset6 = spark.createDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), s);
                    }
                    Dataset emptyDataframeHandlerDF = dataset3;
                    sourceEnrichedDF = ExtractUtils$.MODULE$.addInternalColumns((Dataset<Row>)emptyDataframeHandlerDF, stage.contiguousIndex(), arcContext);
                    option2 = optionSchema;
                }
                catch (Exception exception) {
                    throw new DetailException(stage, exception){
                        private final Map<String, Object> detail;

                        public Map<String, Object> detail() {
                            return this.detail;
                        }
                        {
                            this.detail = stage$2.stageDetail();
                        }
                    };
                }
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    StructType schema = (StructType)some.x();
                    dataset2 = MetadataUtils$.MODULE$.setMetadata(sourceEnrichedDF, schema, spark, logger);
                } else {
                    if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                    dataset2 = sourceEnrichedDF;
                }
                Dataset enrichedDF = dataset2;
                List<String> list = stage.partitionBy();
                if (Nil$.MODULE$.equals(list)) {
                    Dataset dataset7;
                    Option<Object> option7 = stage.numPartitions();
                    if (option7 instanceof Some) {
                        Some some = (Some)option7;
                        int numPartitions = BoxesRunTime.unboxToInt((Object)some.x());
                        dataset7 = enrichedDF.repartition(numPartitions);
                    } else {
                        if (!None$.MODULE$.equals(option7)) throw new MatchError(option7);
                        dataset7 = enrichedDF;
                    }
                    dataset = dataset7;
                } else {
                    Dataset dataset8;
                    List partitionCols = (List)list.map((Function1)new Serializable(enrichedDF){
                        public static final long serialVersionUID = 0L;
                        private final Dataset enrichedDF$1;

                        public final Column apply(String col) {
                            return this.enrichedDF$1.apply(col);
                        }
                        {
                            this.enrichedDF$1 = enrichedDF$1;
                        }
                    }, List$.MODULE$.canBuildFrom());
                    Option<Object> option8 = stage.numPartitions();
                    if (option8 instanceof Some) {
                        Some some = (Some)option8;
                        int numPartitions = BoxesRunTime.unboxToInt((Object)some.x());
                        dataset8 = enrichedDF.repartition(numPartitions, (Seq)partitionCols);
                    } else {
                        if (!None$.MODULE$.equals(option8)) throw new MatchError(option8);
                        dataset8 = enrichedDF.repartition((Seq)partitionCols);
                    }
                    dataset = dataset8;
                }
                Dataset repartitionedDF = dataset;
                if (arcContext.immutableViews()) {
                    repartitionedDF.createTempView(stage.outputView());
                } else {
                    repartitionedDF.createOrReplaceTempView(stage.outputView());
                }
                if (repartitionedDF.isStreaming()) {
                    boxedUnit = BoxedUnit.UNIT;
                    return Option$.MODULE$.apply((Object)repartitionedDF);
                }
                stage.stageDetail().put((Object)"inputFiles", (Object)repartitionedDF.inputFiles().length);
                stage.stageDetail().put((Object)"outputColumns", (Object)repartitionedDF.schema().length());
                stage.stageDetail().put((Object)"numPartitions", (Object)repartitionedDF.rdd().partitions().length);
                if (stage.persist()) {
                    repartitionedDF.persist(arcContext.storageLevel());
                    boxedUnit = stage.stageDetail().put((Object)"records", (Object)repartitionedDF.count());
                    return Option$.MODULE$.apply((Object)repartitionedDF);
                }
                boxedUnit = BoxedUnit.UNIT;
                return Option$.MODULE$.apply((Object)repartitionedDF);
            }
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            throw new Exception(((API.ExtractError)error).getMessage());
        }
        Predef$.MODULE$.println((Object)analysisException2.getMessage());
        throw new Exception(analysisException2);
    }

    public ORCExtractStage apply(ORCExtract plugin, String name, Option<String> description, Either<String, List<API.ExtractColumn>> schema, String outputView, String input, Option<API.Authentication> authentication, scala.collection.immutable.Map<String, String> params, boolean persist, Option<Object> numPartitions, List<String> partitionBy, boolean contiguousIndex, Option<String> basePath, Option<API.Watermark> watermark) {
        return new ORCExtractStage(plugin, name, description, schema, outputView, input, authentication, params, persist, numPartitions, partitionBy, contiguousIndex, basePath, watermark);
    }

    public Option<Tuple14<ORCExtract, String, Option<String>, Either<String, List<API.ExtractColumn>>, String, String, Option<API.Authentication>, scala.collection.immutable.Map<String, String>, Object, Option<Object>, List<String>, Object, Option<String>, Option<API.Watermark>>> unapply(ORCExtractStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple14((Object)x$0.plugin(), (Object)x$0.name(), x$0.description(), x$0.schema(), (Object)x$0.outputView(), (Object)x$0.input(), x$0.authentication(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist()), x$0.numPartitions(), x$0.partitionBy(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.contiguousIndex()), x$0.basePath(), x$0.watermark()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ORCExtractStage$() {
        MODULE$ = this;
    }
}

