/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.extract;

import ai.tripl.arc.api.API;
import ai.tripl.arc.extract.AvroExtract;
import ai.tripl.arc.extract.AvroExtractStage;
import ai.tripl.arc.util.CloudUtils$;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.ExtractUtils$;
import ai.tripl.arc.util.MetadataUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import java.io.FileNotFoundException;
import org.apache.avro.Schema;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple15;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class AvroExtractStage$
implements Serializable {
    public static final AvroExtractStage$ MODULE$;

    static {
        new AvroExtractStage$();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Option<Dataset<Row>> execute(AvroExtractStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        Throwable throwable;
        Throwable throwable22;
        block38: {
            Option<StructType> option;
            Product error;
            block40: {
                BoxedUnit boxedUnit;
                Dataset dataset;
                Dataset dataset2;
                Option<StructType> option2;
                Dataset sourceEnrichedDF;
                Left left;
                Option<StructType> optionSchema;
                try {
                    optionSchema = ExtractUtils$.MODULE$.getSchema(stage.schema(), spark, logger);
                    CloudUtils$.MODULE$.setHadoopConfiguration(stage.authentication(), spark, logger);
                }
                catch (Exception exception) {
                    throw new DetailException(stage, exception){
                        private final Map<String, Object> detail;

                        public Map<String, Object> detail() {
                            return this.detail;
                        }
                        {
                            this.detail = stage$2.stageDetail();
                        }
                    };
                }
                try {
                    Right right;
                    Either<String, String> either = stage.input();
                    if (either instanceof Right) {
                        Right right2;
                        Right right3 = (Right)either;
                        String glob = (String)right3.b();
                        Option<String> option3 = stage.basePath();
                        if (option3 instanceof Some) {
                            Some some = (Some)option3;
                            String basePath = (String)some.x();
                            right2 = package$.MODULE$.Right().apply((Object)spark.read().format("avro").option("basePath", basePath).load(glob));
                        } else {
                            if (!None$.MODULE$.equals(option3)) throw new MatchError(option3);
                            right2 = package$.MODULE$.Right().apply((Object)spark.read().format("avro").load(glob));
                        }
                        right = right2;
                    } else {
                        Right right4;
                        Right right5;
                        if (!(either instanceof Left)) throw new MatchError(either);
                        Left left2 = (Left)either;
                        String view = (String)left2.a();
                        Dataset inputView = spark.table(view);
                        Option<Schema> option4 = stage.avroSchema();
                        if (!(option4 instanceof Some)) {
                            if (!None$.MODULE$.equals(option4)) throw new MatchError(option4);
                            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AvroExtract requires the 'avroSchema' to be provided when reading from an 'inputView'."})).s((Seq)Nil$.MODULE$));
                        }
                        Some some = (Some)option4;
                        Schema avroSchema = (Schema)some.x();
                        Option<String> option5 = stage.inputField();
                        if (option5 instanceof Some) {
                            Some some2 = (Some)option5;
                            String inputField = (String)some2.x();
                            right5 = package$.MODULE$.Right().apply((Object)inputView.withColumn(inputField, org.apache.spark.sql.avro.package$.MODULE$.from_avro(functions$.MODULE$.col(inputField), avroSchema.toString())));
                        } else {
                            if (!None$.MODULE$.equals(option5)) throw new MatchError(option5);
                            right5 = package$.MODULE$.Right().apply((Object)inputView.withColumn("value", org.apache.spark.sql.avro.package$.MODULE$.from_avro(functions$.MODULE$.col("value"), avroSchema.toString())));
                        }
                        right = right4 = right5;
                    }
                    left = right;
                }
                catch (Throwable throwable22) {
                    Left left3;
                    throwable = throwable22;
                    if (throwable instanceof FileNotFoundException) {
                        Left left4;
                        Either<String, String> either = stage.input();
                        if (either instanceof Right) {
                            Right right = (Right)either;
                            String glob = (String)right.b();
                            left4 = package$.MODULE$.Left().apply((Object)new API.FileNotFoundExtractError((Option<String>)Option$.MODULE$.apply((Object)glob)));
                        } else {
                            if (!(either instanceof Left)) throw new MatchError(either);
                            left4 = package$.MODULE$.Left().apply((Object)new API.FileNotFoundExtractError((Option<String>)None$.MODULE$));
                        }
                        left3 = left4;
                    } else {
                        Left left5;
                        AnalysisException analysisException;
                        if (!(throwable instanceof AnalysisException) || !(analysisException = (AnalysisException)throwable).getMessage().contains("Path does not exist")) break block38;
                        Either<String, String> either = stage.input();
                        if (either instanceof Right) {
                            Right right = (Right)either;
                            String glob = (String)right.b();
                            left5 = package$.MODULE$.Left().apply((Object)new API.PathNotExistsExtractError((Option<String>)Option$.MODULE$.apply((Object)glob)));
                        } else {
                            if (!(either instanceof Left)) throw new MatchError(either);
                            left5 = package$.MODULE$.Left().apply((Object)new API.PathNotExistsExtractError((Option<String>)None$.MODULE$));
                        }
                        left3 = left5;
                    }
                    left = left3;
                }
                Left df = left;
                try {
                    Dataset dataset3;
                    Left left6 = df;
                    if (left6 instanceof Right) {
                        Dataset dataset4;
                        block39: {
                            Right right = (Right)left6;
                            Dataset df2 = (Dataset)right.b();
                            if (df2.schema().length() == 0) {
                                Option<StructType> option6 = optionSchema;
                                if (option6 instanceof Some) {
                                    Dataset dataset5;
                                    Some some = (Some)option6;
                                    StructType structType = (StructType)some.x();
                                    dataset4 = dataset5 = spark.createDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), structType);
                                    break block39;
                                } else {
                                    if (!None$.MODULE$.equals(option6)) throw new MatchError(option6);
                                    Either<String, String> either = stage.input();
                                    if (either instanceof Right) {
                                        Right right6 = (Right)either;
                                        String glob = (String)right6.b();
                                        throw new Exception(new API.EmptySchemaExtractError((Option<String>)new Some((Object)glob)).getMessage());
                                    }
                                    if (!(either instanceof Left)) throw new MatchError(either);
                                    throw new Exception(new API.EmptySchemaExtractError((Option<String>)None$.MODULE$).getMessage());
                                }
                            }
                            dataset4 = df2;
                        }
                        dataset3 = dataset4;
                    } else {
                        Dataset dataset6;
                        if (!(left6 instanceof Left)) throw new MatchError((Object)left6);
                        Left left7 = left6;
                        error = (Product)left7.a();
                        stage.stageDetail().put((Object)"records", (Object)0);
                        option = optionSchema;
                        if (!(option instanceof Some)) break block40;
                        Some some = (Some)option;
                        StructType s = (StructType)some.x();
                        dataset3 = dataset6 = spark.createDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), s);
                    }
                    Dataset emptyDataframeHandlerDF = dataset3;
                    sourceEnrichedDF = ExtractUtils$.MODULE$.addInternalColumns((Dataset<Row>)emptyDataframeHandlerDF, stage.contiguousIndex(), arcContext);
                    option2 = optionSchema;
                }
                catch (Exception exception) {
                    throw new DetailException(stage, exception){
                        private final Map<String, Object> detail;

                        public Map<String, Object> detail() {
                            return this.detail;
                        }
                        {
                            this.detail = stage$2.stageDetail();
                        }
                    };
                }
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    StructType schema = (StructType)some.x();
                    dataset2 = MetadataUtils$.MODULE$.setMetadata(sourceEnrichedDF, schema, spark, logger);
                } else {
                    if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                    dataset2 = sourceEnrichedDF;
                }
                Dataset enrichedDF = dataset2;
                List<String> list = stage.partitionBy();
                if (Nil$.MODULE$.equals(list)) {
                    Dataset dataset7;
                    Option<Object> option7 = stage.numPartitions();
                    if (option7 instanceof Some) {
                        Some some = (Some)option7;
                        int numPartitions = BoxesRunTime.unboxToInt((Object)some.x());
                        dataset7 = enrichedDF.repartition(numPartitions);
                    } else {
                        if (!None$.MODULE$.equals(option7)) throw new MatchError(option7);
                        dataset7 = enrichedDF;
                    }
                    dataset = dataset7;
                } else {
                    Dataset dataset8;
                    List partitionCols = (List)list.map((Function1)new Serializable(enrichedDF){
                        public static final long serialVersionUID = 0L;
                        private final Dataset enrichedDF$1;

                        public final Column apply(String col) {
                            return this.enrichedDF$1.apply(col);
                        }
                        {
                            this.enrichedDF$1 = enrichedDF$1;
                        }
                    }, List$.MODULE$.canBuildFrom());
                    Option<Object> option8 = stage.numPartitions();
                    if (option8 instanceof Some) {
                        Some some = (Some)option8;
                        int numPartitions = BoxesRunTime.unboxToInt((Object)some.x());
                        dataset8 = enrichedDF.repartition(numPartitions, (Seq)partitionCols);
                    } else {
                        if (!None$.MODULE$.equals(option8)) throw new MatchError(option8);
                        dataset8 = enrichedDF.repartition((Seq)partitionCols);
                    }
                    dataset = dataset8;
                }
                Dataset repartitionedDF = dataset;
                if (arcContext.immutableViews()) {
                    repartitionedDF.createTempView(stage.outputView());
                } else {
                    repartitionedDF.createOrReplaceTempView(stage.outputView());
                }
                if (repartitionedDF.isStreaming()) {
                    boxedUnit = BoxedUnit.UNIT;
                    return Option$.MODULE$.apply((Object)repartitionedDF);
                }
                stage.stageDetail().put((Object)"inputFiles", (Object)repartitionedDF.inputFiles().length);
                stage.stageDetail().put((Object)"outputColumns", (Object)repartitionedDF.schema().length());
                stage.stageDetail().put((Object)"numPartitions", (Object)repartitionedDF.rdd().partitions().length);
                if (stage.persist()) {
                    repartitionedDF.persist(arcContext.storageLevel());
                    boxedUnit = stage.stageDetail().put((Object)"records", (Object)repartitionedDF.count());
                    return Option$.MODULE$.apply((Object)repartitionedDF);
                }
                boxedUnit = BoxedUnit.UNIT;
                return Option$.MODULE$.apply((Object)repartitionedDF);
            }
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            throw new Exception(((API.ExtractError)error).getMessage());
        }
        if (!(throwable instanceof Exception)) throw throwable22;
        Exception exception = (Exception)throwable;
        throw new DetailException(stage, exception){
            private final Map<String, Object> detail;

            public Map<String, Object> detail() {
                return this.detail;
            }
            {
                this.detail = stage$2.stageDetail();
            }
        };
    }

    public AvroExtractStage apply(AvroExtract plugin, String name, Option<String> description, Either<String, List<API.ExtractColumn>> schema, String outputView, Either<String, String> input, Option<API.Authentication> authentication, scala.collection.immutable.Map<String, String> params, boolean persist, Option<Object> numPartitions, List<String> partitionBy, boolean contiguousIndex, Option<String> basePath, Option<Schema> avroSchema, Option<String> inputField) {
        return new AvroExtractStage(plugin, name, description, schema, outputView, input, authentication, params, persist, numPartitions, partitionBy, contiguousIndex, basePath, avroSchema, inputField);
    }

    public Option<Tuple15<AvroExtract, String, Option<String>, Either<String, List<API.ExtractColumn>>, String, Either<String, String>, Option<API.Authentication>, scala.collection.immutable.Map<String, String>, Object, Option<Object>, List<String>, Object, Option<String>, Option<Schema>, Option<String>>> unapply(AvroExtractStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple15((Object)x$0.plugin(), (Object)x$0.name(), x$0.description(), x$0.schema(), (Object)x$0.outputView(), x$0.input(), x$0.authentication(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist()), x$0.numPartitions(), x$0.partitionBy(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.contiguousIndex()), x$0.basePath(), x$0.avroSchema(), x$0.inputField()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private AvroExtractStage$() {
        MODULE$ = this;
    }
}

