/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.util.log.logger;

import ai.tripl.arc.util.log.logger.JsonLogger;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.text.Format;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.slf4j.Marker;

public class StandardJsonLogger
implements JsonLogger {
    private final Logger slf4jLogger;
    private final FastDateFormat formatter;
    private final Gson gson;
    private final JsonObject jsonObject;
    private final Consumer<String> logOperation;
    private final BiConsumer<Marker, String> logWithMarkerOperation;
    private final String levelName;
    private Marker marker;
    private boolean includeLoggerName = true;
    private boolean includeThreadName = true;
    private boolean includeClassName = true;

    public StandardJsonLogger(Logger logger, FastDateFormat fastDateFormat, Gson gson, String string, Consumer<String> consumer, BiConsumer<Marker, String> biConsumer) {
        this.slf4jLogger = logger;
        this.formatter = fastDateFormat;
        this.gson = gson;
        this.levelName = string;
        this.logOperation = consumer;
        this.logWithMarkerOperation = biConsumer;
        this.jsonObject = new JsonObject();
    }

    public boolean isIncludeLoggerName() {
        return this.includeLoggerName;
    }

    public void setIncludeLoggerName(boolean bl) {
        this.includeLoggerName = bl;
    }

    public boolean isIncludeThreadName() {
        return this.includeThreadName;
    }

    public void setIncludeThreadName(boolean bl) {
        this.includeThreadName = bl;
    }

    public boolean isIncludeClassName() {
        return this.includeClassName;
    }

    public void setIncludeClassName(boolean bl) {
        this.includeClassName = bl;
    }

    @Override
    public JsonLogger message(String string) {
        try {
            this.jsonObject.add("message", this.gson.toJsonTree((Object)string));
        }
        catch (Exception exception) {
            this.jsonObject.add("message", this.gson.toJsonTree((Object)this.formatException(exception)));
        }
        return this;
    }

    @Override
    public JsonLogger message(Supplier<String> supplier) {
        try {
            this.jsonObject.add("message", this.gson.toJsonTree((Object)supplier.get()));
        }
        catch (Exception exception) {
            this.jsonObject.add("message", this.gson.toJsonTree((Object)this.formatException(exception)));
        }
        return this;
    }

    @Override
    public JsonLogger map(String string, Map map) {
        try {
            this.jsonObject.add(string, this.gson.toJsonTree((Object)map));
        }
        catch (Exception exception) {
            this.jsonObject.add(string, this.gson.toJsonTree((Object)this.formatException(exception)));
        }
        return this;
    }

    @Override
    public JsonLogger map(String string, Supplier<Map> supplier) {
        try {
            this.jsonObject.add(string, this.gson.toJsonTree((Object)supplier.get()));
        }
        catch (Exception exception) {
            this.jsonObject.add(string, this.gson.toJsonTree((Object)this.formatException(exception)));
        }
        return this;
    }

    @Override
    public JsonLogger list(String string, List list) {
        try {
            this.jsonObject.add(string, this.gson.toJsonTree((Object)list));
        }
        catch (Exception exception) {
            this.jsonObject.add(string, this.gson.toJsonTree((Object)this.formatException(exception)));
        }
        return this;
    }

    @Override
    public JsonLogger list(String string, Supplier<List> supplier) {
        try {
            this.jsonObject.add(string, this.gson.toJsonTree((Object)supplier.get()));
        }
        catch (Exception exception) {
            this.jsonObject.add(string, this.gson.toJsonTree((Object)this.formatException(exception)));
        }
        return this;
    }

    @Override
    public JsonLogger field(String string, Object object) {
        try {
            this.jsonObject.add(string, this.gson.toJsonTree(object));
        }
        catch (Exception exception) {
            this.jsonObject.add(string, this.gson.toJsonTree((Object)this.formatException(exception)));
        }
        return this;
    }

    @Override
    public JsonLogger field(String string, Supplier supplier) {
        try {
            if (supplier == null) {
                this.jsonObject.add(string, null);
            } else {
                this.jsonObject.add(string, this.gson.toJsonTree(supplier.get()));
            }
        }
        catch (Exception exception) {
            this.jsonObject.add(string, this.gson.toJsonTree((Object)this.formatException(exception)));
        }
        return this;
    }

    @Override
    public JsonLogger json(String string, JsonElement jsonElement) {
        try {
            this.jsonObject.add(string, jsonElement);
        }
        catch (Exception exception) {
            this.jsonObject.add(string, this.gson.toJsonTree((Object)this.formatException(exception)));
        }
        return this;
    }

    @Override
    public JsonLogger json(String string, Supplier<JsonElement> supplier) {
        try {
            this.jsonObject.add(string, supplier.get());
        }
        catch (Exception exception) {
            this.jsonObject.add(string, this.gson.toJsonTree((Object)this.formatException(exception)));
        }
        return this;
    }

    @Override
    public JsonLogger exception(String string, Exception exception) {
        try {
            this.jsonObject.add(string, this.gson.toJsonTree((Object)this.formatException(exception)));
        }
        catch (Exception exception2) {
            this.jsonObject.add(string, this.gson.toJsonTree((Object)this.formatException(exception2)));
        }
        return this;
    }

    @Override
    public JsonLogger stack() {
        try {
            this.jsonObject.add("stacktrace", this.gson.toJsonTree((Object)this.formatStack()));
        }
        catch (Exception exception) {
            this.jsonObject.add("stacktrace", this.gson.toJsonTree((Object)this.formatException(exception)));
        }
        return this;
    }

    @Override
    public JsonLogger marker(Marker marker) {
        this.marker = marker;
        this.jsonObject.add("marker", this.gson.toJsonTree((Object)marker.getName()));
        return this;
    }

    @Override
    public void log() {
        String string = this.formatMessage(this.levelName);
        if (this.marker == null) {
            this.logOperation.accept(string);
        } else {
            this.logWithMarkerOperation.accept(this.marker, string);
        }
    }

    protected String formatMessage(String string3) {
        this.jsonObject.add("level", this.gson.toJsonTree((Object)string3));
        if (this.includeThreadName) {
            this.jsonObject.add("thread_name", this.gson.toJsonTree((Object)Thread.currentThread().getName()));
        }
        if (this.includeClassName) {
            try {
                this.jsonObject.add("class", this.gson.toJsonTree((Object)this.getCallingClass()));
            }
            catch (Exception exception) {
                this.jsonObject.add("class", this.gson.toJsonTree((Object)this.formatException(exception)));
            }
        }
        if (this.includeLoggerName) {
            this.jsonObject.add("logger_name", this.gson.toJsonTree((Object)this.slf4jLogger.getName()));
        }
        try {
            this.jsonObject.add("timestamp", this.gson.toJsonTree((Object)this.getCurrentTimestamp((Format)this.formatter)));
        }
        catch (Exception exception) {
            this.jsonObject.add("timestamp", this.gson.toJsonTree((Object)this.formatException(exception)));
        }
        Map map = MDC.getCopyOfContextMap();
        if (map != null && !map.isEmpty()) {
            try {
                map.forEach((string, string2) -> this.jsonObject.add(string.toString(), this.gson.toJsonTree(string2)));
            }
            catch (Exception exception) {
                this.jsonObject.add("mdc", this.gson.toJsonTree((Object)this.formatException(exception)));
            }
        }
        return this.gson.toJson((JsonElement)this.jsonObject);
    }

    private String getCallingClass() {
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        return stackTraceElementArray[3].getClassName();
    }

    private String getCurrentTimestamp(Format format) {
        return format.format(System.currentTimeMillis());
    }

    private String formatException(Exception exception) {
        return ExceptionUtils.getStackTrace((Throwable)exception);
    }

    private String formatStack() {
        StringBuilder stringBuilder = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        stringBuilder.append(stackTraceElementArray[2]);
        for (int i = 3; i < stackTraceElementArray.length; ++i) {
            stringBuilder.append("\n\tat ").append(stackTraceElementArray[i]);
        }
        return stringBuilder.toString();
    }
}

