/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.load;

import ai.tripl.arc.api.API;
import ai.tripl.arc.load.TextLoad;
import ai.tripl.arc.load.TextLoadStage;
import ai.tripl.arc.util.CloudUtils$;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.SerializableConfiguration;
import ai.tripl.arc.util.log.logger.Logger;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.util.CollectionAccumulator;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple14;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Map;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TextLoadStage$
implements Serializable {
    public static final TextLoadStage$ MODULE$;
    private final Tuple2<String, StringType$>[] validValueFilename;
    private final Tuple2<String, AtomicType>[] validValueFilenameIndex;

    static {
        new TextLoadStage$();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Dataset<Row>> execute(TextLoadStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        Option<Object> option;
        block10: {
            String signature = "TextLoad requires input [value: string], [value: string, filename: string] or [value: string, filename: string, index: integer] signature when in singleFile mode.";
            Option<URI> stageOutputURI = stage.outputURI();
            String stagePrefix = stage.prefix();
            String stageSeparator = stage.separator();
            String stageSuffix = stage.suffix();
            SaveMode stageSaveMode = stage.saveMode();
            SerializableConfiguration contextSerializableConfiguration = arcContext.serializableConfiguration();
            Dataset df = spark.table(stage.inputView());
            CloudUtils$.MODULE$.setHadoopConfiguration(stage.authentication(), spark, logger);
            try {
                void var12_12;
                BoxedUnit boxedUnit;
                block11: {
                    Dataset repartitionedDF;
                    block13: {
                        block12: {
                            if (!stage.singleFile()) break block11;
                            if (df.schema().length() != 1) break block12;
                            DataType dataType = df.schema().fields()[0].dataType();
                            StringType$ stringType$ = StringType$.MODULE$;
                            if (!(dataType == null ? stringType$ != null : !dataType.equals(stringType$))) break block13;
                        }
                        if ((df.schema().length() != 2 || !Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])df.schema().fields()).map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<String, DataType> apply(StructField field) {
                                return new Tuple2((Object)field.name(), (Object)field.dataType());
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Tuple2<String, DataType> field) {
                                return Predef$.MODULE$.refArrayOps((Object[])TextLoadStage$.MODULE$.validValueFilename()).contains(field);
                            }
                        })) && (df.schema().length() != 3 || !Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])df.schema().fields()).map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<String, DataType> apply(StructField field) {
                                return new Tuple2((Object)field.name(), (Object)field.dataType());
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Tuple2<String, DataType> field) {
                                return Predef$.MODULE$.refArrayOps((Object[])TextLoadStage$.MODULE$.validValueFilenameIndex()).contains(field);
                            }
                        }))) throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " Got [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{signature, ((TraversableOnce)df.schema().map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply(StructField f) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f.name(), f.dataType().simpleString()}));
                            }
                        }, Seq$.MODULE$.canBuildFrom())).mkString(", ")})));
                    }
                    boolean hasFilename = df.schema().length() == 2 || df.schema().length() == 3;
                    boolean hasIndex = df.schema().length() == 3;
                    Dataset dataset = repartitionedDF = hasFilename ? df.repartition(stage.singleFileNumPartitions(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("filename")})) : df.repartition(1);
                    if (!hasFilename && stageOutputURI.isEmpty()) {
                        throw new Exception("TextLoad requires 'outputURI' to be set if in 'singleFile' mode and no 'filename' column exists.");
                    }
                    CollectionAccumulator outputFileAccumulator = spark.sparkContext().collectionAccumulator();
                    repartitionedDF.foreachPartition((Function1)new Serializable(stageOutputURI, stagePrefix, stageSeparator, stageSuffix, stageSaveMode, contextSerializableConfiguration, hasFilename, hasIndex, outputFileAccumulator){
                        public static final long serialVersionUID = 0L;
                        private final Option stageOutputURI$1;
                        private final String stagePrefix$1;
                        private final String stageSeparator$1;
                        private final String stageSuffix$1;
                        private final SaveMode stageSaveMode$1;
                        private final SerializableConfiguration contextSerializableConfiguration$1;
                        private final boolean hasFilename$1;
                        private final boolean hasIndex$1;
                        private final CollectionAccumulator outputFileAccumulator$1;

                        public final void apply(Iterator<Row> partition) {
                            block8: {
                                Option outputStream;
                                Option option;
                                if (!partition.hasNext()) break block8;
                                Configuration hadoopConf = this.contextSerializableConfiguration$1.value();
                                BufferedIterator bufferedPartition = partition.buffered();
                                Row firstRow = (Row)bufferedPartition.head();
                                int valueIndex = this.hasFilename$1 ? firstRow.fieldIndex("value") : 0;
                                int indexIndex = this.hasIndex$1 ? firstRow.fieldIndex("index") : 0;
                                Path path = this.hasFilename$1 ? new Path(new URI(firstRow.getString(firstRow.fieldIndex("filename")))) : new Path((URI)this.stageOutputURI$1.get());
                                FileSystem fs = path.getFileSystem(hadoopConf);
                                if (fs.exists(path)) {
                                    SaveMode saveMode = this.stageSaveMode$1;
                                    if (SaveMode.ErrorIfExists.equals(saveMode)) {
                                        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File '", "' already exists and 'saveMode' equals 'ErrorIfExists' so cannot continue."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path.toString()})));
                                    }
                                    Object object = SaveMode.Overwrite.equals(saveMode) ? Option$.MODULE$.apply((Object)fs.create(path, true)) : (SaveMode.Append.equals(saveMode) ? Option$.MODULE$.apply((Object)fs.append(path)) : None$.MODULE$);
                                    option = object;
                                } else {
                                    option = Option$.MODULE$.apply((Object)fs.create(path));
                                }
                                Option option2 = outputStream = option;
                                if (option2 instanceof Some) {
                                    BufferedIterator iterator;
                                    Some some = (Some)option2;
                                    FSDataOutputStream os = (FSDataOutputStream)some.x();
                                    os.writeBytes(this.stagePrefix$1);
                                    Object object = iterator = this.hasIndex$1 ? ((IterableLike)bufferedPartition.toSeq().sortBy((Function1)new Serializable(this, indexIndex){
                                        public static final long serialVersionUID = 0L;
                                        private final int indexIndex$1;

                                        public final int apply(Row row) {
                                            return row.getInt(this.indexIndex$1);
                                        }
                                        {
                                            this.indexIndex$1 = indexIndex$1;
                                        }
                                    }, (Ordering)Ordering.Int$.MODULE$)).toIterator() : bufferedPartition;
                                    while (iterator.hasNext()) {
                                        os.writeBytes(((Row)iterator.next()).getString(valueIndex));
                                        if (!iterator.hasNext()) continue;
                                        os.writeBytes(this.stageSeparator$1);
                                    }
                                    os.writeBytes(this.stageSuffix$1);
                                    os.close();
                                    this.outputFileAccumulator$1.add((Object)path.toString());
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    if (!None$.MODULE$.equals(option2)) {
                                        throw new MatchError((Object)option2);
                                    }
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                }
                                fs.close();
                            }
                        }
                        {
                            this.stageOutputURI$1 = stageOutputURI$1;
                            this.stagePrefix$1 = stagePrefix$1;
                            this.stageSeparator$1 = stageSeparator$1;
                            this.stageSuffix$1 = stageSuffix$1;
                            this.stageSaveMode$1 = stageSaveMode$1;
                            this.contextSerializableConfiguration$1 = contextSerializableConfiguration$1;
                            this.hasFilename$1 = hasFilename$1;
                            this.hasIndex$1 = hasIndex$1;
                            this.outputFileAccumulator$1 = outputFileAccumulator$1;
                        }
                    });
                    boxedUnit = stage.stageDetail().put((Object)"outputFiles", JavaConverters$.MODULE$.seqAsJavaListConverter(((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(outputFileAccumulator.value()).asScala()).toSet().toSeq()).asJava());
                    return Option$.MODULE$.apply((Object)df);
                }
                if (df.schema().length() != 1) throw new DetailException(stage, (Dataset)var12_12){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
                DataType dataType = df.schema().fields()[0].dataType();
                StringType$ stringType$ = StringType$.MODULE$;
                if (dataType != null ? !dataType.equals(stringType$) : stringType$ != null) throw new /* invalid duplicate definition of identical inner class */;
                option = stage.numPartitions();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    int n = BoxesRunTime.unboxToInt((Object)some.x());
                    df.repartition(n).write().mode(stage.saveMode()).text(((URI)stage.outputURI().get()).toString());
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    if (!None$.MODULE$.equals(option)) break block10;
                    df.write().mode(stage.saveMode()).text(((URI)stage.outputURI().get()).toString());
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Exception exception) {
                throw new DetailException(stage, exception){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
            return Option$.MODULE$.apply((Object)df);
        }
        throw new MatchError(option);
    }

    public Tuple2<String, StringType$>[] validValueFilename() {
        return this.validValueFilename;
    }

    public Tuple2<String, AtomicType>[] validValueFilenameIndex() {
        return this.validValueFilenameIndex;
    }

    public TextLoadStage apply(TextLoad plugin, String name, Option<String> description, String inputView, Option<URI> outputURI, Option<Object> numPartitions, Option<API.Authentication> authentication, SaveMode saveMode, scala.collection.immutable.Map<String, String> params, boolean singleFile, String prefix, String separator, String suffix, int singleFileNumPartitions) {
        return new TextLoadStage(plugin, name, description, inputView, outputURI, numPartitions, authentication, saveMode, params, singleFile, prefix, separator, suffix, singleFileNumPartitions);
    }

    public Option<Tuple14<TextLoad, String, Option<String>, String, Option<URI>, Option<Object>, Option<API.Authentication>, SaveMode, scala.collection.immutable.Map<String, String>, Object, String, String, String, Object>> unapply(TextLoadStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple14((Object)x$0.plugin(), (Object)x$0.name(), x$0.description(), (Object)x$0.inputView(), x$0.outputURI(), x$0.numPartitions(), x$0.authentication(), (Object)x$0.saveMode(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.singleFile()), (Object)x$0.prefix(), (Object)x$0.separator(), (Object)x$0.suffix(), (Object)BoxesRunTime.boxToInteger((int)x$0.singleFileNumPartitions())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TextLoadStage$() {
        MODULE$ = this;
        this.validValueFilename = (Tuple2[])((Object[])new Tuple2[]{new Tuple2((Object)"value", (Object)StringType$.MODULE$), new Tuple2((Object)"filename", (Object)StringType$.MODULE$)});
        this.validValueFilenameIndex = (Tuple2[])((Object[])new Tuple2[]{new Tuple2((Object)"value", (Object)StringType$.MODULE$), new Tuple2((Object)"filename", (Object)StringType$.MODULE$), new Tuple2((Object)"index", (Object)IntegerType$.MODULE$)});
    }
}

