/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.extract;

import ai.tripl.arc.api.API;
import ai.tripl.arc.api.API$FailMode$FailFast$;
import ai.tripl.arc.datasource.BinaryContent$;
import ai.tripl.arc.extract.BytesExtract;
import ai.tripl.arc.extract.BytesExtractStage;
import ai.tripl.arc.util.CloudUtils$;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.log.logger.Logger;
import org.apache.hadoop.mapreduce.lib.input.InvalidInputException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple11;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BytesExtractStage$
implements Serializable {
    public static final BytesExtractStage$ MODULE$;

    static {
        new BytesExtractStage$();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Dataset<Row>> execute(BytesExtractStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        BoxedUnit boxedUnit;
        Dataset dataset;
        Option<Object> option;
        Dataset df;
        Dataset dataset2;
        String signature = "BytesExtract requires 'inputView' to be dataset with [value: string] signature.";
        CloudUtils$.MODULE$.setHadoopConfiguration(stage.authentication(), spark, logger);
        try {
            Dataset dataset3;
            Either<String, String> either = stage.input();
            if (either instanceof Left) {
                Left left = (Left)either;
                String view = (String)left.a();
                Dataset inputView = spark.table(view);
                StructType schema = inputView.schema();
                int fieldIndex = this.liftedTree1$1(stage, signature, inputView, schema);
                DataType dataType = schema.fields()[fieldIndex].dataType();
                if (!(dataType instanceof StringType)) void var16_11;
                void var15_10;
                throw new DetailException(stage, signature, (StructType)var15_10, (int)var16_11){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                String path = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])inputView.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("value")})).collect()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Row x$18) {
                        return x$18.getString(0);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(",");
                dataset3 = spark.read().format("bytes").load(path);
            } else {
                if (!(either instanceof Right)) throw new MatchError(either);
                Right right = (Right)either;
                String glob = (String)right.b();
                Dataset bytesDF = spark.read().format("bytes").load(glob);
                bytesDF.take(1);
                dataset3 = bytesDF;
            }
            dataset2 = dataset3;
        }
        catch (Exception exception) {
            throw new DetailException(stage, exception){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        catch (InvalidInputException invalidInputException) {
            API.FailMode failMode = stage.failMode();
            API$FailMode$FailFast$ aPI$FailMode$FailFast$ = API$FailMode$FailFast$.MODULE$;
            if (!(failMode != null ? !failMode.equals(aPI$FailMode$FailFast$) : aPI$FailMode$FailFast$ != null)) {
                throw new DetailException(stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
            dataset2 = df = spark.createDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), BinaryContent$.MODULE$.schema());
        }
        if ((option = stage.numPartitions()) instanceof Some) {
            Some some = (Some)option;
            int numPartitions = BoxesRunTime.unboxToInt((Object)some.x());
            dataset = df.repartition(numPartitions);
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            dataset = df;
        }
        Dataset repartitionedDF = dataset;
        if (arcContext.immutableViews()) {
            repartitionedDF.createTempView(stage.outputView());
        } else {
            repartitionedDF.createOrReplaceTempView(stage.outputView());
        }
        stage.stageDetail().put((Object)"inputFiles", (Object)repartitionedDF.inputFiles().length);
        stage.stageDetail().put((Object)"outputColumns", (Object)repartitionedDF.schema().length());
        stage.stageDetail().put((Object)"numPartitions", (Object)repartitionedDF.rdd().partitions().length);
        if (stage.persist() && !repartitionedDF.isStreaming()) {
            repartitionedDF.persist(arcContext.storageLevel());
            boxedUnit = stage.stageDetail().put((Object)"records", (Object)repartitionedDF.count());
            return Option$.MODULE$.apply((Object)repartitionedDF);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Option$.MODULE$.apply((Object)repartitionedDF);
    }

    public BytesExtractStage apply(BytesExtract plugin, String name, Option<String> description, String outputView, Either<String, String> input, Option<API.Authentication> authentication, scala.collection.immutable.Map<String, String> params, boolean persist, Option<Object> numPartitions, boolean contiguousIndex, API.FailMode failMode) {
        return new BytesExtractStage(plugin, name, description, outputView, input, authentication, params, persist, numPartitions, contiguousIndex, failMode);
    }

    public Option<Tuple11<BytesExtract, String, Option<String>, String, Either<String, String>, Option<API.Authentication>, scala.collection.immutable.Map<String, String>, Object, Option<Object>, Object, API.FailMode>> unapply(BytesExtractStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple11((Object)x$0.plugin(), (Object)x$0.name(), x$0.description(), (Object)x$0.outputView(), x$0.input(), x$0.authentication(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist()), x$0.numPartitions(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.contiguousIndex()), (Object)x$0.failMode()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final int liftedTree1$1(BytesExtractStage stage$2, String signature$1, Dataset inputView$1, StructType schema$1) {
        try {
            return schema$1.fieldIndex("value");
        }
        catch (Exception exception) {
            throw new DetailException(stage$2, signature$1, inputView$1){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
    }

    private BytesExtractStage$() {
        MODULE$ = this;
    }
}

