/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.util.log.logger;

import ai.tripl.arc.util.log.logger.JsonLogger;
import ai.tripl.arc.util.log.logger.NoopLogger;
import ai.tripl.arc.util.log.logger.StandardJsonLogger;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.apache.commons.lang3.time.FastDateFormat;

public class Logger {
    public static final String TRACE_LEVEL_NAME = "TRACE";
    public static final String DEBUG_LEVEL_NAME = "DEBUG";
    public static final String INFO_LEVEL_NAME = "INFO";
    public static final String WARN_LEVEL_NAME = "WARN";
    public static final String ERROR_LEVEL_NAME = "ERROR";
    private org.slf4j.Logger slf4jLogger;
    private Gson gson = new GsonBuilder().disableHtmlEscaping().serializeNulls().create();
    private FastDateFormat formatter;
    private boolean includeLoggerName = true;
    private boolean includeThreadName = true;
    private boolean includeClassName = true;
    private NoopLogger noopLogger = new NoopLogger();

    public Logger(org.slf4j.Logger logger, FastDateFormat fastDateFormat) {
        this.slf4jLogger = logger;
        this.formatter = fastDateFormat;
    }

    public boolean isTraceEnabled() {
        return this.slf4jLogger.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.slf4jLogger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.slf4jLogger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.slf4jLogger.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.slf4jLogger.isErrorEnabled();
    }

    public boolean isIncludeLoggerName() {
        return this.includeLoggerName;
    }

    public void setIncludeLoggerName(boolean bl) {
        this.includeLoggerName = bl;
    }

    public boolean isIncludeThreadName() {
        return this.includeThreadName;
    }

    public void setIncludeThreadName(boolean bl) {
        this.includeThreadName = bl;
    }

    public boolean isIncludeClassName() {
        return this.includeClassName;
    }

    public void setIncludeClassName(boolean bl) {
        this.includeClassName = bl;
    }

    public JsonLogger trace() {
        if (this.slf4jLogger.isTraceEnabled()) {
            StandardJsonLogger standardJsonLogger = new StandardJsonLogger(this.slf4jLogger, this.formatter, this.gson, TRACE_LEVEL_NAME, arg_0 -> ((org.slf4j.Logger)this.slf4jLogger).trace(arg_0), (arg_0, arg_1) -> ((org.slf4j.Logger)this.slf4jLogger).trace(arg_0, arg_1));
            this.configureLogger(standardJsonLogger);
            return standardJsonLogger;
        }
        return this.noopLogger;
    }

    public JsonLogger debug() {
        if (this.slf4jLogger.isDebugEnabled()) {
            StandardJsonLogger standardJsonLogger = new StandardJsonLogger(this.slf4jLogger, this.formatter, this.gson, DEBUG_LEVEL_NAME, arg_0 -> ((org.slf4j.Logger)this.slf4jLogger).debug(arg_0), (arg_0, arg_1) -> ((org.slf4j.Logger)this.slf4jLogger).debug(arg_0, arg_1));
            this.configureLogger(standardJsonLogger);
            return standardJsonLogger;
        }
        return this.noopLogger;
    }

    public JsonLogger info() {
        if (this.slf4jLogger.isInfoEnabled()) {
            StandardJsonLogger standardJsonLogger = new StandardJsonLogger(this.slf4jLogger, this.formatter, this.gson, INFO_LEVEL_NAME, arg_0 -> ((org.slf4j.Logger)this.slf4jLogger).info(arg_0), (arg_0, arg_1) -> ((org.slf4j.Logger)this.slf4jLogger).info(arg_0, arg_1));
            this.configureLogger(standardJsonLogger);
            return standardJsonLogger;
        }
        return this.noopLogger;
    }

    public JsonLogger warn() {
        if (this.slf4jLogger.isWarnEnabled()) {
            StandardJsonLogger standardJsonLogger = new StandardJsonLogger(this.slf4jLogger, this.formatter, this.gson, WARN_LEVEL_NAME, arg_0 -> ((org.slf4j.Logger)this.slf4jLogger).warn(arg_0), (arg_0, arg_1) -> ((org.slf4j.Logger)this.slf4jLogger).warn(arg_0, arg_1));
            this.configureLogger(standardJsonLogger);
            return standardJsonLogger;
        }
        return this.noopLogger;
    }

    public JsonLogger error() {
        if (this.slf4jLogger.isErrorEnabled()) {
            StandardJsonLogger standardJsonLogger = new StandardJsonLogger(this.slf4jLogger, this.formatter, this.gson, ERROR_LEVEL_NAME, arg_0 -> ((org.slf4j.Logger)this.slf4jLogger).error(arg_0), (arg_0, arg_1) -> ((org.slf4j.Logger)this.slf4jLogger).error(arg_0, arg_1));
            this.configureLogger(standardJsonLogger);
            return standardJsonLogger;
        }
        return this.noopLogger;
    }

    private void configureLogger(StandardJsonLogger standardJsonLogger) {
        standardJsonLogger.setIncludeClassName(this.includeClassName);
        standardJsonLogger.setIncludeLoggerName(this.includeLoggerName);
        standardJsonLogger.setIncludeThreadName(this.includeThreadName);
    }
}

