/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.util.log.logger;

import ai.tripl.arc.util.log.logger.Logger;
import org.apache.commons.lang3.time.FastDateFormat;

public class LoggerBuilder {
    private org.slf4j.Logger slf4jLogger;
    private FastDateFormat dateFormatter;
    private boolean includeLoggerName = true;
    private boolean includeThreadName = true;
    private boolean includeClassName = true;

    public LoggerBuilder slf4jLogger(org.slf4j.Logger logger, FastDateFormat fastDateFormat) {
        this.slf4jLogger = logger;
        this.dateFormatter = fastDateFormat;
        return this;
    }

    public LoggerBuilder includeLoggerName(boolean bl) {
        this.includeLoggerName = bl;
        return this;
    }

    public LoggerBuilder includeClassName(boolean bl) {
        this.includeClassName = bl;
        return this;
    }

    public LoggerBuilder includeThreadName(boolean bl) {
        this.includeThreadName = bl;
        return this;
    }

    public Logger build() {
        Logger logger = new Logger(this.slf4jLogger, this.dateFormatter);
        logger.setIncludeThreadName(this.includeThreadName);
        logger.setIncludeLoggerName(this.includeLoggerName);
        logger.setIncludeClassName(this.includeClassName);
        return logger;
    }
}

